/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.pcf.event.PCFFilter;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;

public class TxQueueDefs2
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/TxQueueDefs2.java";
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    PCFFilter xmitqs = PCFFilter.getFilter((int)12, (PCFFilter.Operation)PCFFilter.EQUAL_TO, (int)1);
    DmObjectFilter txquery = new DmObjectFilter(Trace.getDefault(), 13, this.xmitqs);
    DmObjectFilter qrquery = new DmObjectFilter(Trace.getDefault(), 13, 6);
    DmObjectFilter all_q_query = new DmObjectFilter(Trace.getDefault(), 13);
    DmObjectFilter sdrchanquery = new DmObjectFilter(Trace.getDefault(), 25, 1);
    DmObjectFilter svrchanquery = new DmObjectFilter(Trace.getDefault(), 25, 2);
    private static final int NUMBER_OF_STAGES_PER_QMGR = 8;
    private int NUMBER_OF_TEST_STAGES = 0;
    private boolean includeSystemObjects = false;
    private ArrayList xmitqNames = new ArrayList();
    private HashMap xmitqUses = new HashMap();

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 8;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> allQueues = this.syncDataModelQuery(t, nextQm, this.all_q_query);
            if (allQueues == null) break;
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> txQueues = this.syncDataModelQuery(t, nextQm, this.txquery);
            if (txQueues == null) break;
            this.getGUIMonitor().worked(1);
            this.xmitqNames = TxQueueDefs2.getObjectTitles(t, txQueues);
            this.xmitqUses = new HashMap();
            int j = 0;
            while (j < this.xmitqNames.size()) {
                this.xmitqUses.put(this.xmitqNames.get(j), 0);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> sdrChans = this.syncDataModelQuery(t, nextQm, this.sdrchanquery);
            if (sdrChans == null) break;
            this.getGUIMonitor().worked(1);
            int j2 = 0;
            while (j2 < sdrChans.size()) {
                DmChannel senderChannel = (DmChannel)sdrChans.get(j2);
                this.analyseChannel(t, senderChannel, allQueues, nextQm);
                ++j2;
            }
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> svrChans = this.syncDataModelQuery(t, nextQm, this.svrchanquery);
            if (svrChans == null) break;
            this.getGUIMonitor().worked(1);
            int j3 = 0;
            while (j3 < svrChans.size()) {
                DmChannel serverChannel = (DmChannel)svrChans.get(j3);
                this.analyseChannel(t, serverChannel, allQueues, nextQm);
                ++j3;
            }
            this.getGUIMonitor().worked(1);
            this.identifyXmitqUses(t, nextQm);
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseChannel(Trace t, DmChannel channel, ArrayList allqueues, DmQueueManager qmgr) {
        String channelName = channel.getTitle();
        if (!this.includeSystemObjects && channelName.startsWith("SYSTEM.")) {
            return;
        }
        String xmitqname = channel.getAttributeValue(t, 3505, 0);
        if (xmitqname == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TxQueueDefs2.error", channelName), TxQueueDefs2.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "TxQueueDefs2.analyseChannel", 900, "Error encountered while getting transmission queue name from channel definition " + channelName);
            }
        } else if (xmitqname.length() == 0) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TxQueueDefs2.noXmitQ", channelName), TxQueueDefs2.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        } else {
            DmQueue xmitQobj = this.getQueue(t, xmitqname, allqueues);
            if (xmitQobj != null) {
                this.analyseXmitQueue(t, channelName, channel, xmitqname, xmitQobj, qmgr);
            } else {
                int i = 0;
                while (i < allqueues.size()) {
                    DmQueue nxtQueue = (DmQueue)allqueues.get(i);
                    if (nxtQueue.getTitle().equalsIgnoreCase(xmitqname)) {
                        xmitQobj = nxtQueue;
                        break;
                    }
                    ++i;
                }
                if (xmitQobj != null) {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TxQueueDefs2.caps", new String[]{xmitqname, channelName}), TxQueueDefs2.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                } else {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TxQueueDefs2.notExist", new String[]{channelName, xmitqname}), TxQueueDefs2.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                }
            }
        }
    }

    private final void analyseXmitQueue(Trace t, String channelName, DmChannel channel, String xmitqname, DmQueue xmitQobj, DmQueueManager qmgr) {
        int xmitqtype = TxQueueDefs2.getAttr(t, (DmObject)xmitQobj, 20);
        if (xmitqtype != 1) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TxQueueDefs2.notLocal", new String[]{channelName, xmitqname}), TxQueueDefs2.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        } else {
            int usage = TxQueueDefs2.getAttr(t, (DmObject)xmitQobj, 12);
            if (usage != 1) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TxQueueDefs2.badUsage", new String[]{channelName, xmitqname}), TxQueueDefs2.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            } else {
                Integer current_count = (Integer)this.xmitqUses.get(xmitqname);
                int new_count = current_count + 1;
                this.xmitqUses.put(xmitqname, new_count);
                int chanmsglen = TxQueueDefs2.getAttr(t, (DmObject)channel, 1510);
                int queuemsglen = TxQueueDefs2.getAttr(t, (DmObject)xmitQobj, 13);
                if (chanmsglen < queuemsglen) {
                    this.testresults.add(new WMQTestResult(1, Messages.getString(t, "TxQueueDefs2.msgLength", new String[]{channelName, "" + chanmsglen, "" + queuemsglen, xmitqname}), TxQueueDefs2.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                }
            }
        }
    }

    private void identifyXmitqUses(Trace t, DmQueueManager qmgr) {
        int i = 0;
        while (i < this.xmitqNames.size()) {
            String qname = (String)this.xmitqNames.get(i);
            if (this.includeSystemObjects || !qname.startsWith("SYSTEM.")) {
                Integer countObj = (Integer)this.xmitqUses.get(qname);
                int count = countObj;
                if (count == 0) {
                    this.testresults.add(new WMQTestResult(1, Messages.getString(t, "TxQueueDefs2.noChanUsingXmitQ", qname), TxQueueDefs2.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                } else if (count > 1) {
                    this.testresults.add(new WMQTestResult(1, Messages.getString(t, "TxQueueDefs2.multipleUse", new String[]{"" + count, qname}), TxQueueDefs2.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                }
            }
            ++i;
        }
    }
}

