/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.pcf.event.PCFFilter;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class TxQueueDefs1
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/TxQueueDefs1.java";
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    PCFFilter xmitqs = PCFFilter.getFilter((int)12, (PCFFilter.Operation)PCFFilter.EQUAL_TO, (int)1);
    DmObjectFilter txquery = new DmObjectFilter(Trace.getDefault(), 13, this.xmitqs);
    DmObjectFilter qrquery = new DmObjectFilter(Trace.getDefault(), 13, 6);
    DmObjectFilter all_q_query = new DmObjectFilter(Trace.getDefault(), 13);
    private static final int NUMBER_OF_STAGES_PER_QMGR = 3;
    private int NUMBER_OF_TEST_STAGES = 0;
    private boolean includeSystemObjects = false;

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 3;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> remoteQueues = this.syncDataModelQuery(t, nextQm, this.qrquery);
            if (remoteQueues == null) break;
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> allQueues = this.syncDataModelQuery(t, nextQm, this.all_q_query);
            if (allQueues == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < remoteQueues.size()) {
                DmQueue remoteQueue = (DmQueue)remoteQueues.get(j);
                this.analyseQueue(t, remoteQueue, allQueues, nextQm);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseQueue(Trace t, DmQueue remoteQueue, ArrayList allqueues, DmQueueManager qmgr) {
        String remoteQueueName = remoteQueue.getTitle();
        if (!this.includeSystemObjects && remoteQueueName.startsWith("SYSTEM.")) {
            return;
        }
        String xmitqname = remoteQueue.getAttributeValue(t, 2024, 0);
        if (xmitqname == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TxQueueDefs1.error", remoteQueueName), TxQueueDefs1.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "TxQueueDefs1.analyseQueue", 900, "Error encountered while getting transmission queue name from remote queue definition " + remoteQueueName);
            }
        } else if (xmitqname.length() == 0 || xmitqname.equals("[not_found]")) {
            this.testresults.add(new WMQTestResult(1, Messages.getString(t, "TxQueueDefs1.noTxQforRemote", remoteQueueName), TxQueueDefs1.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        } else if (xmitqname.equals(remoteQueueName)) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TxQueueDefs1.selfUse", remoteQueueName), TxQueueDefs1.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        } else {
            DmQueue xmitQobj = this.getQueue(t, xmitqname, allqueues);
            if (xmitQobj != null) {
                this.analyseXmitQueue(t, remoteQueueName, xmitqname, xmitQobj, qmgr);
            } else {
                int i = 0;
                while (i < allqueues.size()) {
                    DmQueue nxtQueue = (DmQueue)allqueues.get(i);
                    if (nxtQueue.getTitle().equalsIgnoreCase(xmitqname)) {
                        xmitQobj = nxtQueue;
                        break;
                    }
                    ++i;
                }
                if (xmitQobj != null) {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TxQueueDefs1.caps", new String[]{xmitqname, remoteQueueName}), TxQueueDefs1.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                } else {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TxQueueDefs1.notExist", new String[]{remoteQueueName, xmitqname}), TxQueueDefs1.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                }
            }
        }
    }

    private final void analyseXmitQueue(Trace t, String remoteQueueName, String xmitqname, DmQueue xmitQobj, DmQueueManager qmgr) {
        int xmitqtype = TxQueueDefs1.getAttr(t, (DmObject)xmitQobj, 20);
        if (xmitqtype != 1) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TxQueueDefs1.notLocal", new String[]{remoteQueueName, xmitqname}), TxQueueDefs1.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        } else {
            int usage = TxQueueDefs1.getAttr(t, (DmObject)xmitQobj, 12);
            if (usage != 1) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TxQueueDefs1.badUsage", new String[]{remoteQueueName, xmitqname}), TxQueueDefs1.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            }
        }
    }
}

