/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class TrigQueuesProcs
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/TrigQueuesProcs.java";
    private boolean includeSystemObjects = false;
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private static final int NUMBER_OF_STAGES_PER_QMGR = 2;
    private int NUMBER_OF_TEST_STAGES = 0;
    DmObjectFilter query = new DmObjectFilter(Trace.getDefault(), 13, 1);

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 2;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> localQueues = this.syncDataModelQuery(t, nextQm, this.query);
            if (localQueues == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < localQueues.size()) {
                DmQueue nxtQueue = (DmQueue)localQueues.get(j);
                this.analyseQueue(t, nxtQueue, nextQm);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseQueue(Trace t, DmQueue queue, DmQueueManager qmgr) {
        int trigmsgpriority;
        String queueName = queue.getTitle();
        if (!this.includeSystemObjects && queueName.startsWith("SYSTEM.")) {
            return;
        }
        int trigattr = TrigQueuesProcs.getAttr(t, (DmObject)queue, 24);
        if (trigattr == 1 && (trigmsgpriority = TrigQueuesProcs.getAttr(t, (DmObject)queue, 26)) == 0) {
            int ipprocs;
            boolean trigConditionsMet = false;
            int trigtype = TrigQueuesProcs.getAttr(t, (DmObject)queue, 28);
            switch (trigtype) {
                case 0: {
                    break;
                }
                case 1: {
                    int curdepth = TrigQueuesProcs.getAttr(t, (DmObject)queue, 3);
                    if (curdepth != 1) break;
                    trigConditionsMet = true;
                    break;
                }
                case 2: {
                    int curdepth = TrigQueuesProcs.getAttr(t, (DmObject)queue, 3);
                    if (curdepth <= 0) break;
                    trigConditionsMet = true;
                    break;
                }
                case 3: {
                    int trigdepth = TrigQueuesProcs.getAttr(t, (DmObject)queue, 29);
                    int curdepth = TrigQueuesProcs.getAttr(t, (DmObject)queue, 3);
                    if (curdepth < trigdepth) break;
                    trigConditionsMet = true;
                }
            }
            if (trigConditionsMet && (ipprocs = TrigQueuesProcs.getAttr(t, (DmObject)queue, 17)) <= 0) {
                this.testresults.add(new WMQTestResult(1, Messages.getString(t, "TrigQueuesProcs.noInputProcesses", queueName), TrigQueuesProcs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            }
        }
    }
}

