/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class TrigData
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/TrigData.java";
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    DmObjectFilter chans_query = new DmObjectFilter(Trace.getDefault(), 25);
    DmObjectFilter queue_query = new DmObjectFilter(Trace.getDefault(), 13);
    private static final int NUMBER_OF_STAGES_PER_QMGR = 3;
    private int NUMBER_OF_TEST_STAGES = 0;
    private boolean includeSystemObjects = false;

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 3;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> channels = this.syncDataModelQuery(t, nextQm, this.chans_query);
            if (channels == null) break;
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> queues = this.syncDataModelQuery(t, nextQm, this.queue_query);
            if (queues == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < queues.size()) {
                DmQueue nextQueue = (DmQueue)queues.get(j);
                this.analyseQueue(t, nextQueue, channels, nextQm);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseQueue(Trace t, DmQueue queue, ArrayList channels, DmQueueManager qmgr) {
        DmChannel chanObj;
        String queueName = queue.getTitle();
        if (!this.includeSystemObjects && queueName.startsWith("SYSTEM.")) {
            return;
        }
        String trigdataattr = queue.getAttributeValue(t, 2023, 0);
        if (trigdataattr == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TrigData.attrValError", queueName), TrigData.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        } else if (!trigdataattr.equals("[not_found]") && trigdataattr.length() != 0 && (chanObj = this.getChannel(t, trigdataattr, channels)) == null) {
            this.testresults.add(new WMQTestResult(1, Messages.getString(t, "TrigData.noChannel", new String[]{queueName, trigdataattr}), TrigData.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        }
    }
}

