/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmTopic;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;

public class TopicsNameCase
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/TopicsNameCase.java";
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private ArrayList<String> topicnames;
    private ArrayList<String> topicstrings;
    private Hashtable<String, String> tableTopicNames;
    private static final int NUMBER_OF_STAGES_PER_QMGR = 2;
    public static final String TOPICSTRING_SEPARATOR = "/";
    DmObjectFilter all_t_query = new DmObjectFilter(Trace.getDefault(), 174);
    private boolean includeSystemObjects = false;

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        guimonitor.beginTask(this.getTestName(), numqmgrs * 2);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> topics = this.syncDataModelQuery(t, nextQm, this.all_t_query);
            if (topics == null) break;
            this.getGUIMonitor().worked(1);
            this.topicnames = new ArrayList();
            this.topicstrings = new ArrayList();
            this.tableTopicNames = new Hashtable();
            int j = 0;
            while (j < topics.size()) {
                DmTopic nxttopic = (DmTopic)topics.get(j);
                this.analyseTopic(t, nxttopic, nextQm);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseTopic(Trace t, DmTopic topic, DmQueueManager qmgr) {
        String name1 = topic.getTitle();
        String string1 = topic.getAttributeValue(t, 2094, 0);
        if (this.includeSystemObjects || !topic.isSystemObject(t)) {
            int i = 0;
            while (i < this.topicnames.size()) {
                String name2 = this.topicnames.get(i);
                if (!name1.equals(name2) && name1.equalsIgnoreCase(name2)) {
                    this.logWarning(t, qmgr, "TopicsNamesCase.similar", name1, name2);
                }
                ++i;
            }
            this.topicnames.add(name1);
            String trimstring1 = string1.trim();
            String partialstring1 = this.trimSeparators(t, string1);
            int i2 = 0;
            while (i2 < this.topicstrings.size()) {
                String string2 = this.topicstrings.get(i2);
                String name2 = this.tableTopicNames.get(string2);
                if (!string1.equals(string2) && string1.equalsIgnoreCase(string2)) {
                    this.logWarning(t, qmgr, "TopicsNamesCase.similarstring", name1, name2);
                } else if (!string1.equals(string2) && trimstring1.equalsIgnoreCase(string2.trim())) {
                    this.logWarning(t, qmgr, "TopicsNamesCase.similarstring", name1, name2);
                } else if (!string1.equals(string2) && partialstring1.equalsIgnoreCase(this.trimSeparators(t, string2))) {
                    this.logWarning(t, qmgr, "TopicsNamesCase.similarstring", name1, name2);
                }
                ++i2;
            }
            this.topicstrings.add(string1);
            this.tableTopicNames.put(string1, name1);
        }
    }

    private void logWarning(Trace t, DmQueueManager qmgr, String type, String name1, String name2) {
        this.testresults.add(new WMQTestResult(1, Messages.getString(t, type, new String[]{name1, name2}), TopicsNameCase.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
    }

    private String trimSeparators(Trace t, String input) {
        String output = input;
        while (output.startsWith(TOPICSTRING_SEPARATOR)) {
            output = output.substring(1);
        }
        while (output.endsWith(TOPICSTRING_SEPARATOR)) {
            output = output.substring(0, output.length() - 1);
        }
        return output;
    }
}

