/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmTopic;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;

public class TopicsDiscoverParentage
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/TopicsDiscoverParentage.java";
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private Hashtable<String, String> topicStrings;
    private Hashtable<String, String> topicNames;
    private static final int NUMBER_OF_STAGES_PER_QMGR = 2;
    public static final String TOPICSTRING_SEPARATOR = "/";
    DmObjectFilter all_t_query = new DmObjectFilter(Trace.getDefault(), 174);
    private boolean includeSystemObjects = false;

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        guimonitor.beginTask(this.getTestName(), numqmgrs * 2);
        int i = 0;
        while (i < numqmgrs) {
            String topicString;
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> allTopics = this.syncDataModelQuery(t, nextQm, this.all_t_query);
            if (allTopics == null) break;
            this.topicNames = new Hashtable();
            this.topicStrings = new Hashtable();
            int j = 0;
            while (j < allTopics.size()) {
                DmTopic nxttopic = (DmTopic)allTopics.get(j);
                String topicName = nxttopic.getTitle();
                topicString = nxttopic.getAttributeValue(t, 2094, 0);
                this.topicNames.put(topicString, topicName);
                this.topicStrings.put(topicName, topicString);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            Vector<String> v = new Vector<String>(this.topicStrings.keySet());
            Collections.sort(v);
            for (String topicName : v) {
                topicString = this.topicStrings.get(topicName);
                this.analyseTopic(t, topicName, topicString, nextQm);
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseTopic(Trace t, String topicName, String topicString, DmQueueManager qmgr) {
        String parent = null;
        boolean candidateForAnalysis = true;
        if (!this.includeSystemObjects && topicName.startsWith("SYSTEM.")) {
            candidateForAnalysis = false;
        }
        if (topicName.compareTo(DmTopic.getBaseName((Trace)t)) == 0) {
            candidateForAnalysis = false;
        }
        if (candidateForAnalysis) {
            if (topicString.contains(TOPICSTRING_SEPARATOR)) {
                String subValue = topicString;
                while (subValue.length() > 0) {
                    int length = subValue.lastIndexOf(TOPICSTRING_SEPARATOR);
                    if (length < 0) break;
                    String test = this.topicNames.get(subValue = subValue.substring(0, length));
                    if (test == null) continue;
                    parent = test;
                    break;
                }
            }
            if (parent == null) {
                parent = DmTopic.getBaseName((Trace)t);
            }
            this.testresults.add(new WMQTestResult(0, Messages.getString(t, "TopicsDiscoverParentage.parentage", new String[]{topicName, parent}), TopicsDiscoverParentage.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        }
    }
}

