/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmTopic;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class TopicsBasicSetup
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/TopicsBasicSetup.java";
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private static final String MNDURMDL = "SYSTEM.NDURABLE.MODEL.QUEUE";
    private static final String MDURMDL = "SYSTEM.DURABLE.MODEL.QUEUE";
    private static final int NUMBER_OF_STAGES_PER_QMGR = 3;
    DmObjectFilter all_t_query = new DmObjectFilter(Trace.getDefault(), 174);
    DmObjectFilter all_q_query = new DmObjectFilter(Trace.getDefault(), 13);
    private boolean includeSystemObjects = false;

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        guimonitor.beginTask(this.getTestName(), numqmgrs * 3);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> topics = this.syncDataModelQuery(t, nextQm, this.all_t_query);
            if (topics == null) break;
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> allQueues = this.syncDataModelQuery(t, nextQm, this.all_q_query);
            if (allQueues == null) break;
            this.getGUIMonitor().worked(1);
            String baseName = DmTopic.getBaseName((Trace)t);
            String defaultName = DmTopic.getDefaultName((Trace)t);
            if (!this.includeSystemObjects) {
                DmTopic defaultTopic;
                DmTopic baseTopic = this.getTopic(t, baseName, topics);
                if (baseTopic == null) {
                    this.testresults.add(new WMQTestResult(1, Messages.getString(t, "TopicsBasicSetup.nobasetopic", new String[]{baseName}), TopicsBasicSetup.getQueueManagerName(t, nextQm), this.getTestSubCategory()));
                }
                if ((defaultTopic = this.getTopic(t, defaultName, topics)) == null) {
                    this.testresults.add(new WMQTestResult(1, Messages.getString(t, "TopicsBasicSetup.nodefaulttopic", new String[]{defaultName}), TopicsBasicSetup.getQueueManagerName(t, nextQm), this.getTestSubCategory()));
                }
            }
            int j = 0;
            while (j < topics.size()) {
                DmTopic nxttopic = (DmTopic)topics.get(j);
                if (this.includeSystemObjects || !nxttopic.isSystemObject(t)) {
                    this.analyseTopic(t, nxttopic, allQueues, nextQm);
                }
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseTopic(Trace t, DmTopic topic, ArrayList<DmObject> allQueues, DmQueueManager qmgr) {
        this.analyseNonDurableQueue(t, topic, allQueues, qmgr);
        this.analyseDurableQueue(t, topic, allQueues, qmgr);
    }

    private void analyseNonDurableQueue(Trace t, DmTopic topic, ArrayList<DmObject> allQueues, DmQueueManager qmgr) {
        String topicName = topic.getTitle();
        String queueName = topic.getAttributeValue(t, 2097, 0);
        if (queueName.compareTo("") == 0) {
            queueName = topicName.compareTo(DmTopic.getBaseName((Trace)t)) == 0 ? MNDURMDL : null;
        }
        if (queueName != null) {
            DmQueue durableQueue = this.getQueue(t, queueName, allQueues);
            if (durableQueue == null) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TopicsBasicSetup.nonondurq", new String[]{topicName, queueName}), TopicsBasicSetup.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            } else {
                int targqtype = TopicsBasicSetup.getAttr(t, (DmObject)durableQueue, 20);
                if (targqtype == 2) {
                    int targqdtype = TopicsBasicSetup.getAttr(t, (DmObject)durableQueue, 7);
                    if (targqdtype != 3) {
                        this.testresults.add(new WMQTestResult(1, Messages.getString(t, "TopicsBasicSetup.nondurisnttempdyn", new String[]{topicName, queueName}), TopicsBasicSetup.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                    }
                } else {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TopicsBasicSetup.nondurnotmodelq", new String[]{topicName, queueName}), TopicsBasicSetup.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                }
            }
        }
    }

    private void analyseDurableQueue(Trace t, DmTopic topic, ArrayList<DmObject> allQueues, DmQueueManager qmgr) {
        String topicName = topic.getTitle();
        String queueName = topic.getAttributeValue(t, 2096, 0);
        if (queueName.compareTo("") == 0) {
            queueName = topicName.compareTo(DmTopic.getBaseName((Trace)t)) == 0 ? MDURMDL : null;
        }
        if (queueName != null) {
            DmQueue durableQueue = this.getQueue(t, queueName, allQueues);
            if (durableQueue == null) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TopicsBasicSetup.nodurq", new String[]{topicName, queueName}), TopicsBasicSetup.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            } else {
                int targqtype = TopicsBasicSetup.getAttr(t, (DmObject)durableQueue, 20);
                if (targqtype == 2) {
                    int targqdtype = TopicsBasicSetup.getAttr(t, (DmObject)durableQueue, 7);
                    if (targqdtype == 3) {
                        this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TopicsBasicSetup.duristempdyn", new String[]{topicName, queueName}), TopicsBasicSetup.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                    }
                } else {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "TopicsBasicSetup.durnotmodelq", new String[]{topicName, queueName}), TopicsBasicSetup.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                }
            }
        }
    }
}

