/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmPubSubStatus;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmSubscription;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class SubscriptionsNameCase
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/SubscriptionsNameCase.java";
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private ArrayList<String> subNames;
    private ArrayList<String> topicStrings;
    private Hashtable<String, String> tableSubNames;
    private static final int NUMBER_OF_STAGES_PER_QMGR = 2;
    public static final String TOPICSTRING_SEPARATOR = "/";
    DmObjectFilter all_s_query = new DmObjectFilter(Trace.getDefault(), 176);
    DmObjectFilter is_pubsub_query = new DmObjectFilter(Trace.getDefault(), 185);
    private boolean includeSystemObjects = false;
    public static final String PUB_SUB_STATUS_INACTIVE = "Inactive";

    public MQExtObject[] getApplicableObjects(MQExtObject[] contextObjects) {
        Trace t = Trace.getDefault();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        Map<DmQueueManager, MQExtObject> qmgrMap = this.getFilteredQueueManagersMap(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        ArrayList<DmQueueManager> qmgrsToRemove = new ArrayList<DmQueueManager>();
        for (DmQueueManager qmgr : qmgrMap.keySet()) {
            if (qmgr.getCommandLevel() < 700) {
                qmgrsToRemove.add(qmgr);
                continue;
            }
            ArrayList<DmObject> isPubSubEnabled = this.syncDataModelQuery(t, qmgr, this.is_pubsub_query);
            DmPubSubStatus dpb = (DmPubSubStatus)isPubSubEnabled.get(0);
            if (!PUB_SUB_STATUS_INACTIVE.equals(dpb.getAttributeValue(t, 1311, 0))) continue;
            qmgrsToRemove.add(qmgr);
        }
        for (DmQueueManager qmgr : qmgrsToRemove) {
            qmgrMap.remove(qmgr);
        }
        MQExtObject[] validObjs = qmgrMap.values().toArray(new MQExtObject[0]);
        return validObjs;
    }

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        guimonitor.beginTask(this.getTestName(), numqmgrs * 2);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> subscriptions = this.syncDataModelQuery(t, nextQm, this.all_s_query);
            if (subscriptions == null) break;
            this.getGUIMonitor().worked(1);
            this.subNames = new ArrayList();
            this.topicStrings = new ArrayList();
            this.tableSubNames = new Hashtable();
            int j = 0;
            while (j < subscriptions.size()) {
                DmSubscription nxtsub = (DmSubscription)subscriptions.get(j);
                this.analyseSubscription(t, nxtsub, nextQm);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseSubscription(Trace t, DmSubscription subscription, DmQueueManager qmgr) {
        Integer subtype;
        int type;
        Attr subtypeattr;
        String subName;
        if ((this.includeSystemObjects || !subscription.isSystemObject(t)) && (subName = subscription.getTitle()).compareTo(DmSubscription.getDefaultName((Trace)t)) != 0 && (subtypeattr = subscription.getAttribute(t, 1289, 0)) != null && (type = (subtype = (Integer)subtypeattr.getValue(t)).intValue()) == 2) {
            String string1 = subscription.getAttributeValue(t, 2094, 0);
            int i = 0;
            while (i < this.subNames.size()) {
                String name2 = this.subNames.get(i);
                if (!subName.equals(name2) && subName.equalsIgnoreCase(name2)) {
                    this.logWarning(t, qmgr, "SubscriptionsNamesCase.similar", subName, name2);
                }
                ++i;
            }
            this.subNames.add(subName);
            String trimstring1 = string1.trim();
            String partialstring1 = this.trimSeparators(t, string1);
            int i2 = 0;
            while (i2 < this.topicStrings.size()) {
                String string2 = this.topicStrings.get(i2);
                String name2 = this.tableSubNames.get(string2);
                if (!string1.equals(string2) && string1.equalsIgnoreCase(string2)) {
                    this.logWarning(t, qmgr, "SubscriptionsNamesCase.similarstring", subName, name2);
                } else if (!string1.equals(string2) && trimstring1.equalsIgnoreCase(string2.trim())) {
                    this.logWarning(t, qmgr, "SubscriptionsNamesCase.similarstring", subName, name2);
                } else if (!string1.equals(string2) && partialstring1.equalsIgnoreCase(this.trimSeparators(t, string2))) {
                    this.logWarning(t, qmgr, "SubscriptionsNamesCase.similarstring", subName, name2);
                }
                ++i2;
            }
            this.topicStrings.add(string1);
            this.tableSubNames.put(string1, subName);
        }
    }

    private void logWarning(Trace t, DmQueueManager qmgr, String type, String name1, String name2) {
        this.testresults.add(new WMQTestResult(1, Messages.getString(t, type, new String[]{name1, name2}), SubscriptionsNameCase.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
    }

    private String trimSeparators(Trace t, String input) {
        String output = input;
        while (output.startsWith(TOPICSTRING_SEPARATOR)) {
            output = output.substring(1);
        }
        while (output.endsWith(TOPICSTRING_SEPARATOR)) {
            output = output.substring(0, output.length() - 1);
        }
        return output;
    }
}

