/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmPubSubStatus;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmSubscription;
import com.ibm.mq.explorer.core.internal.objects.DmTopic;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class SubscriptionsBasicSetup
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/SubscriptionsBasicSetup.java";
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private static final int NUMBER_OF_STAGES_PER_QMGR = 4;
    DmObjectFilter all_s_query = new DmObjectFilter(Trace.getDefault(), 176);
    DmObjectFilter all_q_query = new DmObjectFilter(Trace.getDefault(), 13);
    DmObjectFilter all_t_query = new DmObjectFilter(Trace.getDefault(), 174);
    DmObjectFilter is_pubsub_query = new DmObjectFilter(Trace.getDefault(), 185);
    private boolean includeSystemObjects = false;
    public static final String PUB_SUB_STATUS_INACTIVE = "Inactive";

    public MQExtObject[] getApplicableObjects(MQExtObject[] contextObjects) {
        Trace t = Trace.getDefault();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        Map<DmQueueManager, MQExtObject> qmgrMap = this.getFilteredQueueManagersMap(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        ArrayList<DmQueueManager> qmgrsToRemove = new ArrayList<DmQueueManager>();
        for (DmQueueManager qmgr : qmgrMap.keySet()) {
            if (qmgr.getCommandLevel() < 700) {
                qmgrsToRemove.add(qmgr);
                continue;
            }
            ArrayList<DmObject> isPubSubEnabled = this.syncDataModelQuery(t, qmgr, this.is_pubsub_query);
            DmPubSubStatus dpb = (DmPubSubStatus)isPubSubEnabled.get(0);
            if (!PUB_SUB_STATUS_INACTIVE.equals(dpb.getAttributeValue(t, 1311, 0))) continue;
            qmgrsToRemove.add(qmgr);
        }
        for (DmQueueManager qmgr : qmgrsToRemove) {
            qmgrMap.remove(qmgr);
        }
        MQExtObject[] validObjs = qmgrMap.values().toArray(new MQExtObject[0]);
        return validObjs;
    }

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        guimonitor.beginTask(this.getTestName(), numqmgrs * 4);
        int i = 0;
        while (i < numqmgrs) {
            DmSubscription baseSub;
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> subscriptions = this.syncDataModelQuery(t, nextQm, this.all_s_query);
            if (subscriptions == null) break;
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> allQueues = this.syncDataModelQuery(t, nextQm, this.all_q_query);
            if (allQueues == null) break;
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> allTopics = this.syncDataModelQuery(t, nextQm, this.all_t_query);
            if (allTopics == null) break;
            this.getGUIMonitor().worked(1);
            String defaultName = DmSubscription.getDefaultName((Trace)t);
            if (!this.includeSystemObjects && (baseSub = this.getSubscription(t, defaultName, subscriptions)) == null) {
                this.testresults.add(new WMQTestResult(1, Messages.getString(t, "SubscriptionsBasicSetup.nodefaultsub", new String[]{defaultName}), SubscriptionsBasicSetup.getQueueManagerName(t, nextQm), this.getTestSubCategory()));
            }
            int j = 0;
            while (j < subscriptions.size()) {
                DmSubscription nxtsub = (DmSubscription)subscriptions.get(j);
                if (this.includeSystemObjects || !nxtsub.isSystemObject(t)) {
                    this.analyseSubscription(t, nxtsub, allQueues, allTopics, nextQm);
                }
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseSubscription(Trace t, DmSubscription subscription, ArrayList<DmObject> allQueues, ArrayList<DmObject> allTopics, DmQueueManager qmgr) {
        Integer subtype;
        int type;
        Attr subtypeattr;
        String subName;
        if ((this.includeSystemObjects || !subscription.isSystemObject(t)) && (subName = subscription.getTitle()).compareTo(DmSubscription.getDefaultName((Trace)t)) != 0 && (subtypeattr = subscription.getAttribute(t, 1289, 0)) != null && (type = (subtype = (Integer)subtypeattr.getValue(t)).intValue()) == 2) {
            this.analyseTopic(t, subscription, subName, allTopics, qmgr);
            this.analyseDestination(t, subscription, subName, allQueues, qmgr);
        }
    }

    private void analyseTopic(Trace t, DmSubscription subscription, String subName, ArrayList<DmObject> allTopics, DmQueueManager qmgr) {
        DmTopic subTopic;
        String topicName = subscription.getAttributeValue(t, 2092, 0);
        if (topicName.compareTo("") != 0 && (subTopic = this.getTopic(t, topicName, allTopics)) == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "SubscriptionsBasicSetup.topicnotexist", new String[]{subName, topicName}), SubscriptionsBasicSetup.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        }
    }

    private void analyseDestination(Trace t, DmSubscription subscription, String subName, ArrayList<DmObject> allQueues, DmQueueManager qmgr) {
        String qmgrName = subscription.getAttributeValue(t, 3153, 0);
        String queueName = subscription.getAttributeValue(t, 3154, 0);
        if (queueName.compareTo("") == 0) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "SubscriptionsBasicSetup.destqnotdef", new String[]{subName}), SubscriptionsBasicSetup.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        } else if (qmgrName.compareTo("") == 0 || qmgrName.compareTo(SubscriptionsBasicSetup.getQueueManagerName(t, qmgr)) == 0) {
            DmQueue destQueue = this.getQueue(t, queueName, allQueues);
            if (destQueue == null) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "SubscriptionsBasicSetup.destqnotexist", new String[]{subName, queueName}), SubscriptionsBasicSetup.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            } else {
                int destutype;
                int desttype = SubscriptionsBasicSetup.getAttr(t, (DmObject)destQueue, 20);
                if (desttype == 3) {
                    int destbtype = SubscriptionsBasicSetup.getAttr(t, (DmObject)destQueue, 193);
                    if (destbtype == 8) {
                        this.testresults.add(new WMQTestResult(2, Messages.getString(t, "SubscriptionsBasicSetup.destqisbtypetop", new String[]{subName, queueName}), SubscriptionsBasicSetup.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                    }
                } else if ((desttype == 1 || desttype == 2) && (destutype = SubscriptionsBasicSetup.getAttr(t, (DmObject)destQueue, 12)) == 1) {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "SubscriptionsBasicSetup.destqisusexmit", new String[]{subName, queueName}), SubscriptionsBasicSetup.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                }
            }
        }
    }
}

