/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;

public class SSLPeerValues
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/SSLPeerValues.java";
    private boolean includeSystemObjects = false;
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private static final int NUMBER_OF_STAGES_PER_QMGR = 2;
    private int NUMBER_OF_TEST_STAGES = 0;
    DmObjectFilter query = new DmObjectFilter(Trace.getDefault(), 25);
    private static String VALIDCHARS = "a-zA-Z0-9 \\.'\\(\\)\\/\\-";
    private static String VALIDATTRIBS = "SERIALNUMBER|MAIL|E|UID|USERID|CN|T|O|OU|DC|STREET|L|ST|SP|S|PC|C|UNSTRUCTUREDNAME|UNSTRUCTUREDADDRESS|DNQ";
    private static String VALIDVALSTR1 = "(?:[" + VALIDCHARS + "\\*]|\\\\[^" + VALIDCHARS + "\\*])*";
    private static String VALIDVALSTR2 = "(?:[" + VALIDCHARS + ",;\\*]|\\\\[^" + VALIDCHARS + ",;])*";
    private static String VALIDVALSTR = String.valueOf(VALIDVALSTR1) + "|\"" + VALIDVALSTR2 + "\"";
    private static Pattern ATTRPATTERN = Pattern.compile("(" + VALIDATTRIBS + ")");
    private static Pattern VALPATTERN = Pattern.compile("(" + VALIDVALSTR + ")+");

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 2;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> channels = this.syncDataModelQuery(t, nextQm, this.query);
            if (channels == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < channels.size()) {
                DmChannel nxtChannel = (DmChannel)channels.get(j);
                this.analyseChannel(t, nxtChannel, nextQm);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseChannel(Trace t, DmChannel chan, DmQueueManager qmgr) {
        String channelName = chan.getTitle();
        if (!this.includeSystemObjects && channelName.startsWith("SYSTEM.")) {
            return;
        }
        String sslpeer = chan.getAttributeValue(t, 3545, 0);
        if (sslpeer != null && !sslpeer.equals("[not_defined]") && sslpeer.length() > 0) {
            this.analyseSSLPEERvalue(t, sslpeer, chan, qmgr);
            String sslciph = chan.getAttributeValue(t, 3544, 0);
            if (sslciph != null && (sslciph.equals("[not_defined]") || sslciph.length() == 0)) {
                this.testresults.add(new WMQTestResult(1, Messages.getString(t, "SSLPeerValues.peerWithoutCiph", chan.getTitle()), SSLPeerValues.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            }
        }
    }

    private void analyseSSLPEERvalue(Trace t, String sslpeer, DmChannel channel, DmQueueManager qmgr) {
        StringTokenizer st = new StringTokenizer(sslpeer, ",");
        while (st.hasMoreTokens()) {
            String current = st.nextToken();
            String[] data = (current = current.trim()).split("=");
            if (data.length == 2) {
                String attribute = data[0];
                String value = data[1];
                if (!ATTRPATTERN.matcher(attribute).matches()) {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "SSLPeerValues.badPeerAttr", new String[]{sslpeer, channel.getTitle()}), SSLPeerValues.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                    break;
                }
                if (VALPATTERN.matcher(value).matches()) continue;
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "SSLPeerValues.badPeerVal", new String[]{sslpeer, channel.getTitle()}), SSLPeerValues.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                break;
            }
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "SSLPeerValues.bad", new String[]{sslpeer, channel.getTitle()}), SSLPeerValues.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            break;
        }
    }
}

