/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class SSLKeyr
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/SSLKeyr.java";

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        ArrayList<WMQTestResult> testresults = new ArrayList<WMQTestResult>();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, true, true, true, visibleQmgrsOnly, true);
        guimonitor.beginTask(this.getTestName(), qmgrs.size() + 1);
        int i = 0;
        while (i < qmgrs.size()) {
            guimonitor.worked(1);
            DmQueueManager nxtQmgr = qmgrs.get(i);
            String sslkeyr = nxtQmgr.getAttributeValue(t, 2049, 0);
            if (sslkeyr != null) {
                if (sslkeyr.endsWith(".kdb")) {
                    testresults.add(new WMQTestResult(2, Messages.getString(t, "SSLKeyr.kdbExtension"), SSLKeyr.getQueueManagerName(t, nxtQmgr), this.getTestSubCategory()));
                    int index = sslkeyr.indexOf(".kdb");
                    sslkeyr = sslkeyr.substring(0, index);
                }
                if (nxtQmgr.isLocal()) {
                    boolean rdb_exists;
                    String key_kdb = String.valueOf(sslkeyr) + ".kdb";
                    String key_crl = String.valueOf(sslkeyr) + ".crl";
                    String key_sth = String.valueOf(sslkeyr) + ".sth";
                    String key_rdb = String.valueOf(sslkeyr) + ".rdb";
                    File filehandle_kdb = new File(key_kdb);
                    File filehandle_crl = new File(key_crl);
                    File filehandle_sth = new File(key_sth);
                    File filehandle_rdb = new File(key_rdb);
                    boolean kdb_exists = filehandle_kdb.exists() && filehandle_kdb.isFile();
                    boolean crl_exists = filehandle_crl.exists() && filehandle_crl.isFile();
                    boolean sth_exists = filehandle_sth.exists() && filehandle_sth.isFile();
                    boolean bl = rdb_exists = filehandle_rdb.exists() && filehandle_rdb.isFile();
                    if (!kdb_exists) {
                        testresults.add(new WMQTestResult(1, Messages.getString(t, "SSLKeyr.reposNotFound"), SSLKeyr.getQueueManagerName(t, nxtQmgr), this.getTestSubCategory()));
                    }
                    if (!sth_exists) {
                        testresults.add(new WMQTestResult(1, Messages.getString(t, "SSLKeyr.stashNotFound"), SSLKeyr.getQueueManagerName(t, nxtQmgr), this.getTestSubCategory()));
                    }
                    if (kdb_exists) {
                        this.SSLKeyrAccessCheck(t, key_kdb, nxtQmgr, testresults);
                    }
                    if (crl_exists) {
                        this.SSLKeyrAccessCheck(t, key_crl, nxtQmgr, testresults);
                    }
                    if (sth_exists) {
                        this.SSLKeyrAccessCheck(t, key_sth, nxtQmgr, testresults);
                    }
                    if (rdb_exists) {
                        this.SSLKeyrAccessCheck(t, key_rdb, nxtQmgr, testresults);
                    }
                }
            } else {
                testresults.add(new WMQTestResult(2, Messages.getString(t, "SSLKeyr.error", SSLKeyr.getQueueManagerName(t, nxtQmgr)), SSLKeyr.getQueueManagerName(t, nxtQmgr), this.getTestSubCategory()));
                if (Trace.isTracing) {
                    t.data(66, "SSLKeyr.runTest", 900, "Error encountered while getting SSLKEYR attribute from " + SSLKeyr.getQueueManagerName(t, nxtQmgr));
                }
            }
            ++i;
        }
        this.testComplete(testresults.toArray(new WMQTestResult[testresults.size()]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void SSLKeyrAccessCheck(Trace t, String keyfileName, DmQueueManager qmgr, ArrayList<WMQTestResult> testresults) {
        boolean badAccessControl;
        block41: {
            StringBuffer cmdResult;
            InputStream input;
            Process p;
            block42: {
                p = null;
                input = null;
                cmdResult = new StringBuffer();
                if (CommonServices.PLATFORM_ID != 1) break block42;
                boolean oneNonSystemUserWithWriteAccess = false;
                String nonSystemUserName = "";
                String[] cmd = new String[]{"cacls", "\"" + keyfileName + "\""};
                boolean badAccessControl2 = false;
                try {
                    p = Runtime.getRuntime().exec(cmd);
                    input = p.getInputStream();
                    while (true) {
                        int nxtVal;
                        if ((nxtVal = input.read()) == -1) {
                            if (p.exitValue() != 1) break;
                            testresults.add(new WMQTestResult(1, Messages.getString(t, "SSLKeyr.notNTFS", keyfileName), SSLKeyr.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                            return;
                        }
                        cmdResult.append((char)nxtVal);
                    }
                    if (p.exitValue() != 0) {
                        testresults.add(new WMQTestResult(2, Messages.getString(t, "SSLKeyr.errorFromCacls", keyfileName), SSLKeyr.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                        return;
                    }
                    String[] output_tokens = cmdResult.toString().trim().split("\\n");
                    boolean checkingSpecialAccessforMqm = false;
                    boolean checkingSpecialAccessforOwner = false;
                    int i = 0;
                    while (i < output_tokens.length) {
                        block44: {
                            int pos;
                            block49: {
                                block48: {
                                    block47: {
                                        block46: {
                                            block45: {
                                                block43: {
                                                    pos = output_tokens[i].indexOf(":N");
                                                    if (pos == -1) break block43;
                                                    checkingSpecialAccessforOwner = false;
                                                    checkingSpecialAccessforMqm = false;
                                                    break block44;
                                                }
                                                pos = output_tokens[i].indexOf("(DENY)");
                                                if (pos == -1) break block45;
                                                checkingSpecialAccessforOwner = false;
                                                checkingSpecialAccessforMqm = false;
                                                break block44;
                                            }
                                            if (!checkingSpecialAccessforOwner || (pos = output_tokens[i].indexOf("FILE_WRITE_DATA")) == -1) break block46;
                                            oneNonSystemUserWithWriteAccess = true;
                                            break block44;
                                        }
                                        if (checkingSpecialAccessforMqm) {
                                            pos = output_tokens[i].indexOf("STANDARD_RIGHTS_ALL");
                                            if (pos != -1) {
                                                badAccessControl2 = true;
                                                break;
                                            }
                                            pos = output_tokens[i].indexOf("DELETE");
                                            if (pos != -1) {
                                                badAccessControl2 = true;
                                                break;
                                            }
                                            pos = output_tokens[i].indexOf("WRITE_DAC");
                                            if (pos != -1) {
                                                badAccessControl2 = true;
                                                break;
                                            }
                                            pos = output_tokens[i].indexOf("WRITE_OWNER");
                                            if (pos != -1) {
                                                badAccessControl2 = true;
                                                break;
                                            }
                                            pos = output_tokens[i].indexOf("STANDARD_RIGHTS_REQUIRED");
                                            if (pos != -1) {
                                                badAccessControl2 = true;
                                                break;
                                            }
                                            pos = output_tokens[i].indexOf("FILE_GENERIC_WRITE");
                                            if (pos != -1) {
                                                badAccessControl2 = true;
                                                break;
                                            }
                                            pos = output_tokens[i].indexOf("FILE_WRITE_DATA");
                                            if (pos != -1) {
                                                badAccessControl2 = true;
                                                break;
                                            }
                                            pos = output_tokens[i].indexOf("FILE_APPEND_DATA");
                                            if (pos != -1) {
                                                badAccessControl2 = true;
                                                break;
                                            }
                                            pos = output_tokens[i].indexOf("FILE_WRITE_EA");
                                            if (pos != -1) {
                                                badAccessControl2 = true;
                                                break;
                                            }
                                            pos = output_tokens[i].indexOf("FILE_WRITE_ATTRIBUTES");
                                            if (pos != -1) {
                                                badAccessControl2 = true;
                                                break;
                                            }
                                        }
                                        if ((pos = output_tokens[i].indexOf("BUILTIN")) == -1) {
                                            pos = output_tokens[i].indexOf("Admin");
                                        }
                                        if (pos == -1) break block47;
                                        checkingSpecialAccessforOwner = false;
                                        checkingSpecialAccessforMqm = false;
                                        break block44;
                                    }
                                    pos = output_tokens[i].indexOf("NT");
                                    if (pos == -1 || (pos = output_tokens[i].indexOf("SYSTEM")) == -1) break block48;
                                    checkingSpecialAccessforOwner = false;
                                    checkingSpecialAccessforMqm = false;
                                    break block44;
                                }
                                pos = output_tokens[i].indexOf("Everyone");
                                if (pos != -1) {
                                    badAccessControl2 = true;
                                    break;
                                }
                                pos = output_tokens[i].indexOf("mqm");
                                if (pos == -1) break block49;
                                checkingSpecialAccessforOwner = false;
                                checkingSpecialAccessforMqm = false;
                                pos = output_tokens[i].indexOf(":R");
                                if (pos != -1) break block44;
                                pos = output_tokens[i].indexOf("mqm:(");
                                if (pos != -1) {
                                    checkingSpecialAccessforMqm = true;
                                    break block44;
                                } else {
                                    badAccessControl2 = true;
                                    break;
                                }
                            }
                            boolean writeAccess = false;
                            boolean specialAccess = false;
                            pos = output_tokens[i].indexOf(":F");
                            if (pos == -1) {
                                pos = output_tokens[i].indexOf(":W");
                            }
                            if (pos == -1) {
                                pos = output_tokens[i].indexOf(":C");
                            }
                            if (pos != -1) {
                                writeAccess = true;
                            }
                            if (pos == -1 && (pos = output_tokens[i].indexOf(":(special access:)")) != -1) {
                                specialAccess = true;
                            }
                            if (pos == -1) {
                                pos = output_tokens[i].indexOf(":R");
                            }
                            if (pos != -1) {
                                char testChar;
                                checkingSpecialAccessforMqm = false;
                                checkingSpecialAccessforOwner = false;
                                int namePos = pos;
                                while ((testChar = output_tokens[i].charAt(--namePos)) != ' ') {
                                }
                                String thisName = output_tokens[i].substring(namePos++, pos);
                                if (nonSystemUserName.length() != 0) {
                                    if (!thisName.equals(nonSystemUserName)) {
                                        badAccessControl2 = true;
                                        break;
                                    }
                                } else {
                                    nonSystemUserName = thisName;
                                }
                                if (writeAccess) {
                                    oneNonSystemUserWithWriteAccess = true;
                                } else if (specialAccess) {
                                    checkingSpecialAccessforOwner = true;
                                }
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println(e);
                }
                if (nonSystemUserName.length() != 0 && !oneNonSystemUserWithWriteAccess) {
                    badAccessControl2 = true;
                }
                if (!badAccessControl2) return;
                testresults.add(new WMQTestResult(2, Messages.getString(t, "SSLKeyr.badAccessControl", keyfileName), SSLKeyr.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                return;
            }
            if (CommonServices.PLATFORM_ID != 5) return;
            badAccessControl = false;
            String[] cmd = new String[]{"ls", "-l", keyfileName};
            try {
                p = Runtime.getRuntime().exec(cmd);
                int val = p.waitFor();
                if (val != 0) break block41;
                input = p.getInputStream();
                while (true) {
                    int nxtVal;
                    if ((nxtVal = input.read()) == -1) {
                        String[] tokens = cmdResult.toString().trim().split("\\s+");
                        String groupPermissions = tokens[0].trim().substring(4, 7);
                        String otherPermissions = tokens[0].trim().substring(7, 10);
                        if (groupPermissions.contains("w") || groupPermissions.contains("x") || otherPermissions.contains("r") || otherPermissions.contains("w") || otherPermissions.contains("x")) {
                            badAccessControl = true;
                        }
                        break;
                    }
                    cmdResult.append((char)nxtVal);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println(e);
            }
        }
        if (!badAccessControl) return;
        testresults.add(new WMQTestResult(2, Messages.getString(t, "SSLKeyr.badPermissions", keyfileName), SSLKeyr.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
    }
}

