/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmChannelStatusCurrent;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;

public class SSLChannelsReset
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/SSLChannelsReset.java";
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    DmObjectFilter chanquery = new DmObjectFilter(Trace.getDefault(), 25);
    DmObjectFilter chstatusquery = new DmObjectFilter(Trace.getDefault(), 1009);
    private static final int NUMBER_OF_STAGES_PER_QMGR = 3;
    private int NUMBER_OF_TEST_STAGES = 0;
    private boolean includeSystemObjects = false;

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 3;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> channels = this.syncDataModelQuery(t, nextQm, this.chanquery);
            if (channels == null) break;
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> channelStatuses = this.syncDataModelQuery(t, nextQm, this.chstatusquery);
            if (channelStatuses == null) break;
            this.getGUIMonitor().worked(1);
            Date sslkeyrModifiedDate = this.getSSLKEYRdate(t, nextQm);
            if (sslkeyrModifiedDate != null) {
                int j = 0;
                while (j < channelStatuses.size()) {
                    DmChannelStatusCurrent chanStatus = (DmChannelStatusCurrent)channelStatuses.get(j);
                    this.analyseChannel(t, chanStatus, channels, sslkeyrModifiedDate);
                    ++j;
                }
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private Date getSSLKEYRdate(Trace t, DmQueueManager qmgr) {
        Date lastmoddate = null;
        String sslkeyr = qmgr.getAttributeValue(t, 2049, 0);
        if (sslkeyr != null) {
            String key_kdb = String.valueOf(sslkeyr) + ".kdb";
            String key_sto = String.valueOf(sslkeyr) + ".sto";
            File filehandle_kdb = new File(key_kdb);
            File filehandle_sto = new File(key_sto);
            boolean kdb_exists = filehandle_kdb.exists() && filehandle_kdb.isFile();
            boolean sto_exists = filehandle_sto.exists() && filehandle_sto.isFile();
            long timecount = 0L;
            if (kdb_exists) {
                timecount = filehandle_kdb.lastModified();
            } else if (sto_exists) {
                timecount = filehandle_sto.lastModified();
            }
            lastmoddate = new Date(timecount);
        } else {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "SSLChannelsReset.sslkeyrError", SSLChannelsReset.getQueueManagerName(t, qmgr)), SSLChannelsReset.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "SSLChannelsReset.getSSLKEYRdate", 900, "Error encountered while getting SSLKEYR attribute from " + SSLChannelsReset.getQueueManagerName(t, qmgr));
            }
        }
        return lastmoddate;
    }

    private void analyseChannel(Trace t, DmChannelStatusCurrent channelstatus, ArrayList channels, Date sslkeyrdate) {
        block6: {
            boolean chanIsSSL;
            String channelName = channelstatus.getAttributeValue(t, 3501, 0);
            if (!this.includeSystemObjects && channelName.startsWith("SYSTEM.")) {
                return;
            }
            DmChannel matchingChannel = this.getChannel(t, channelName, channels);
            if (matchingChannel != null && (chanIsSSL = this.isChannelSSL(t, matchingChannel))) {
                String chanStartTime = channelstatus.getAttributeValue(t, 3528, 0);
                String chanStartDate = channelstatus.getAttributeValue(t, 3529, 0);
                if (chanStartTime != null && chanStartDate != null) {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss dd-MMM-yyyy");
                        sdf.setCalendar(Calendar.getInstance());
                        Date chanstrdate = sdf.parse(String.valueOf(chanStartTime) + " " + chanStartDate);
                        if (chanstrdate.before(sslkeyrdate)) {
                            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "SSLChannelsReset.notRestarted", channelName), SSLChannelsReset.getQueueManagerName(t, matchingChannel.getQueueManager()), this.getTestSubCategory()));
                        }
                    }
                    catch (ParseException parseException) {
                        this.testresults.add(new WMQTestResult(2, Messages.getString(t, "SSLChannelsReset.dateError", new String[]{chanStartTime, chanStartDate}), SSLChannelsReset.getQueueManagerName(t, matchingChannel.getQueueManager()), this.getTestSubCategory()));
                        if (!Trace.isTracing) break block6;
                        t.data(66, "SSLChannelsReset.analyseChannel", 900, "Error encountered while turning " + chanStartTime + " and " + chanStartDate + " into a Date");
                    }
                }
            }
        }
    }

    private boolean isChannelSSL(Trace t, DmChannel channel) {
        String sslciph = channel.getAttributeValue(t, 3544, 0);
        boolean result = true;
        if (sslciph == null || sslciph.equals("[not_defined]") || sslciph.length() == 0) {
            result = false;
        }
        return result;
    }
}

