/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFMessageAgent;
import com.ibm.mq.pcf.event.PCFQuery;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class SSLCIPHallon
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/SSLCIPHallon.java";
    private boolean includeSystemObjects = false;
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private static final int NUMBER_OF_STAGES_PER_QMGR = 2;
    private int NUMBER_OF_TEST_STAGES = 0;
    DmObjectFilter query = new DmObjectFilter(Trace.getDefault(), 25);

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<MQQmgrExtObject> allMQExtQmgrs = new ArrayList<MQQmgrExtObject>();
        int nx = 0;
        while (nx < contextObjects.length) {
            UiQueueManager uiQmgr;
            DmQueueManager dmQmgr;
            MQQmgrExtObject mqExtQmgr;
            Object obj;
            if (contextObjects[nx] instanceof MQQmgrExtObject && (obj = (mqExtQmgr = (MQQmgrExtObject)contextObjects[nx]).getInternalObject()) != null && obj instanceof UiQueueManager && (dmQmgr = (uiQmgr = (UiQueueManager)obj).getDmQueueManagerObject()).isRunning() && dmQmgr.isConnected() && dmQmgr.isVisible(t) == visibleQmgrsOnly) {
                allMQExtQmgrs.add((MQQmgrExtObject)contextObjects[nx]);
            }
            ++nx;
        }
        numqmgrs = allMQExtQmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 2;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            MQQmgrExtObject nextMQExtQmgr = (MQQmgrExtObject)allMQExtQmgrs.get(i);
            UiQueueManager nextUiQmgr = (UiQueueManager)nextMQExtQmgr.getInternalObject();
            DmQueueManager nextDmQmgr = nextUiQmgr.getDmQueueManagerObject();
            ArrayList<DmObject> channels = this.syncDataModelQuery(t, nextDmQmgr, this.query);
            if (channels == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < channels.size()) {
                DmChannel nxtChannel = (DmChannel)channels.get(j);
                this.analyseChannel(t, nxtChannel, nextMQExtQmgr);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseChannel(Trace t, DmChannel chan, MQQmgrExtObject extQmgr) {
        UiQueueManager uiQmgr = (UiQueueManager)extQmgr.getInternalObject();
        DmQueueManager dmQmgr = uiQmgr.getDmQueueManagerObject();
        String channelName = chan.getTitle();
        if (!this.includeSystemObjects && channelName.startsWith("SYSTEM.")) {
            return;
        }
        String sslciph = chan.getAttributeValue(t, 3544, 0);
        if (sslciph == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "SSLCIPHallon.sslciphError", channelName), SSLCIPHallon.getQueueManagerName(t, dmQmgr), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "SSLCIPHallon.analyseChannel", 900, "Error encountered while getting SSLCIPH attr from channel definition " + channelName);
            }
        } else if (sslciph.length() == 0 || sslciph.equals("[not_found]")) {
            int trptype = SSLCIPHallon.getAttr(t, (DmObject)chan, 1501);
            if (trptype == 2) {
                this.testresults.add(new WMQTestResult(0, Messages.getString(t, "SSLCIPHallon.notSSL", channelName), SSLCIPHallon.getQueueManagerName(t, dmQmgr), this.getTestSubCategory()));
            }
        } else {
            int trptype = SSLCIPHallon.getAttr(t, (DmObject)chan, 1501);
            if (trptype != 2) {
                this.testresults.add(new WMQTestResult(1, Messages.getString(t, "SSLCIPHallon.tcpSSLCIPH", channelName), SSLCIPHallon.getQueueManagerName(t, dmQmgr), this.getTestSubCategory()));
            } else {
                boolean hasSSLPeerChlAuth = this.hasChannelAuthenticationRecord(t, chan, extQmgr);
                String sslpeer = chan.getAttributeValue(t, 3545, 0);
                if (sslpeer == null) {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "SSLCIPHallon.sslpeerError", channelName), SSLCIPHallon.getQueueManagerName(t, dmQmgr), this.getTestSubCategory()));
                    if (Trace.isTracing) {
                        t.data(66, "SSLCIPHallon.analyseChannel", 900, "Error encountered while getting SSLPEER attr from channel definition " + channelName);
                    }
                } else if ((sslpeer.length() == 0 || sslpeer.equals("[not_found]")) && !hasSSLPeerChlAuth) {
                    this.testresults.add(new WMQTestResult(1, Messages.getString(t, "SSLCIPHallon.ciphWithoutPeer", channelName), SSLCIPHallon.getQueueManagerName(t, dmQmgr), this.getTestSubCategory()));
                }
            }
        }
    }

    private boolean hasChannelAuthenticationRecord(Trace t, DmChannel chan, MQQmgrExtObject extQmgr) {
        boolean hasChlAuth = false;
        try {
            PCFMessageAgent agent = new PCFMessageAgent(extQmgr.getMQQueueManager());
            PCFMessage cmd = new PCFMessage(204);
            cmd.addParameter(3501, chan.getTitle());
            cmd.addParameter(1352, 3);
            cmd.addParameter(1637, 3);
            cmd.addParameter(1355, PCFQuery.ALL_ATTRS);
            PCFMessage[] responses = agent.send(cmd);
            hasChlAuth = true;
            int nx = 0;
            while (nx < responses.length) {
                String name = responses[nx].getStringParameterValue(3501);
                if (Trace.isTracing) {
                    t.data(66, "SSLCIPHallon.hasChannelAuthenticationRecord", 300, "Channel " + chan.getTitle() + " is protected through channel authentication record " + name);
                }
                ++nx;
            }
        }
        catch (MQException e) {
            if (e.getReason() == 2085 || e.getReason() == 3312) {
                hasChlAuth = false;
            } else {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return hasChlAuth;
    }
}

