/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueue;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.QueueManagerConnections;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;

public class RemoteQueueDefs
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/RemoteQueueDefs.java";
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private ArrayList<DmQueueManager> qmgrs = new ArrayList();
    private DmObjectFilter qrquery = new DmObjectFilter(Trace.getDefault(), 13, 6);
    private DmObjectFilter qquery = new DmObjectFilter(Trace.getDefault(), 13);
    private DmObjectFilter clqquery = new DmObjectFilter(Trace.getDefault(), 1004);
    private static final int NUMBER_OF_STAGES_PER_QMGR = 4;
    private int NUMBER_OF_TEST_STAGES = 0;
    private boolean includeSystemObjects = false;
    private HashSet qmgrnames = new HashSet();
    private HashSet qmgrnames_lc = new HashSet();
    private HashMap qremotes = new HashMap();
    private HashMap qlocals = new HashMap();
    private HashMap qclusters = new HashMap();

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.qremotes = new HashMap();
        this.qlocals = new HashMap();
        this.qclusters = new HashMap();
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        this.qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        ArrayList<DmQueueManager> allqmgrs = this.getFilteredQueueManagers(t, (MQExtObject[])QueueManagerConnections.getExistingQueueManagers(), false, false, false, false, false);
        numqmgrs = this.qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 4;
        int i = 0;
        while (i < allqmgrs.size()) {
            DmQueueManager nxtqmgr = allqmgrs.get(i);
            String qmname = nxtqmgr.getTitle();
            String qmname_lc = qmname.toLowerCase();
            this.qmgrnames.add(qmname);
            this.qmgrnames_lc.add(qmname_lc);
            ++i;
        }
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = this.qmgrs.get(i);
            ArrayList<DmObject> remoteQueues = this.syncDataModelQuery(t, nextQm, this.qrquery);
            if (remoteQueues == null) break;
            this.qremotes.put(nextQm, remoteQueues);
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> allQueues = this.syncDataModelQuery(t, nextQm, this.qquery);
            if (allQueues == null) break;
            this.qlocals.put(nextQm, allQueues);
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> clusterQueues = this.syncDataModelQuery(t, nextQm, this.clqquery);
            if (clusterQueues == null) break;
            this.qclusters.put(nextQm, clusterQueues);
            this.getGUIMonitor().worked(1);
            ++i;
        }
        if (!this.isCancelled()) {
            int qmidx = 0;
            while (qmidx < numqmgrs) {
                DmQueueManager qmgr = this.qmgrs.get(qmidx);
                ArrayList rmqs = (ArrayList)this.qremotes.get(qmgr);
                int quidx = 0;
                while (quidx < rmqs.size()) {
                    DmQueue rmq = (DmQueue)rmqs.get(quidx);
                    this.analyseQueue(t, rmq, qmgr);
                    ++quidx;
                }
                this.getGUIMonitor().worked(1);
                ++qmidx;
            }
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseQueue(Trace t, DmQueue remoteq, DmQueueManager qmgr) {
        String rqmname;
        String remoteQueueName = remoteq.getTitle();
        if (!this.includeSystemObjects && remoteQueueName.startsWith("SYSTEM.")) {
            return;
        }
        String xmitqname = remoteq.getAttributeValue(t, 2024, 0);
        if (xmitqname == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "RemoteQueueDefs.getTXQErr", remoteQueueName), RemoteQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "RemoteQueueDefs.analyseQueue", 900, "Error encountered while getting transmission queue name from remote queue definition " + remoteQueueName);
            }
        }
        if ((rqmname = remoteq.getAttributeValue(t, 2017, 0)) == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "RemoteQueueDefs.getremoteQMQDefErr", remoteq.getTitle()), RemoteQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "RemoteQueueDefs.analyseQueue", 900, "Error encountered while getting remote qmgr name from queue definition " + remoteq.getTitle());
            }
        } else if (rqmname.length() == 0 || rqmname.equals("[not_found]")) {
            if (xmitqname.length() == 0 || xmitqname.equals("[not_found]")) {
                this.testresults.add(new WMQTestResult(1, Messages.getString(t, "RemoteQueueDefs.noXmitQ", remoteq.getTitle()), RemoteQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            }
        } else {
            if (!rqmname.matches("[A-Za-z0-9._%]{1}[A-Za-z0-9./_%]*")) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "RemoteQueueDefs.badQmChars", new String[]{rqmname, remoteq.getTitle()}), RemoteQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            }
            if (!this.qmgrnames.contains(rqmname)) {
                boolean outputMissingQmgrError = true;
                if (xmitqname.length() == 0 || xmitqname.equals("[not_found]")) {
                    DmQueue txq;
                    ArrayList<DmObject> queues = (ArrayList<DmObject>)this.qlocals.get(qmgr);
                    if (queues == null) {
                        queues = new ArrayList<DmObject>();
                    }
                    if ((txq = this.getQueue(t, rqmname, queues)) != null) {
                        this.analyseXmitQueue(t, remoteQueueName, rqmname, txq, qmgr);
                        outputMissingQmgrError = false;
                    }
                }
                if (outputMissingQmgrError) {
                    if (this.qmgrnames_lc.contains(rqmname.toLowerCase())) {
                        this.testresults.add(new WMQTestResult(1, Messages.getString(t, "RemoteQueueDefs.badCapital", new String[]{rqmname, remoteq.getTitle()}), RemoteQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                    } else {
                        this.testresults.add(new WMQTestResult(1, Messages.getString(t, "RemoteQueueDefs.unknownQM", new String[]{rqmname, remoteq.getTitle()}), RemoteQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                    }
                }
            } else {
                String rqname = remoteq.getAttributeValue(t, 2018, 0);
                if (rqname == null) {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "RemoteQueueDefs.getremoteQueueQDefErr", remoteq.getTitle()), RemoteQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                    if (Trace.isTracing) {
                        t.data(66, "RemoteQueueDefs.analyseQueue", 900, "Error encountered while getting remote queue name from queue definition " + remoteq.getTitle());
                    }
                } else if (rqname.length() > 0 && !rqname.equals("[not_found]")) {
                    if (!rqname.matches("[A-Za-z0-9._%]{1}[A-Za-z0-9./_%]*")) {
                        this.testresults.add(new WMQTestResult(2, Messages.getString(t, "RemoteQueueDefs.badQChars", new String[]{rqname, remoteq.getTitle()}), RemoteQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                    } else {
                        DmQueueManager rqmgrObj = this.getQueueManager(t, rqmname, this.qmgrs);
                        if (rqmgrObj != null && this.missingRemoteQueueName(t, rqname, rqmgrObj)) {
                            this.testresults.add(new WMQTestResult(1, Messages.getString(t, "RemoteQueueDefs.noRemoteQ", new String[]{remoteq.getTitle(), rqname, rqmname}), RemoteQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                        }
                    }
                }
            }
        }
    }

    private final void analyseXmitQueue(Trace t, String remoteQueueName, String xmitqname, DmQueue xmitQobj, DmQueueManager qmgr) {
        int xmitqtype = RemoteQueueDefs.getAttr(t, (DmObject)xmitQobj, 20);
        if (xmitqtype != 1) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "RemoteQueueDefs.notLocalQ", new String[]{remoteQueueName, xmitqname}), RemoteQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        } else {
            int usage = RemoteQueueDefs.getAttr(t, (DmObject)xmitQobj, 12);
            if (usage != 1) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "RemoteQueueDefs.notXmitQ", new String[]{remoteQueueName, xmitqname}), RemoteQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            }
        }
    }

    private final boolean missingRemoteQueueName(Trace t, String rqname, DmQueueManager remoteQmgr) {
        boolean result = false;
        DmQueue rqueueObj = null;
        ArrayList<DmClusterQueue> queuesOnRmtQmgr = (ArrayList<DmClusterQueue>)this.qlocals.get(remoteQmgr);
        if (queuesOnRmtQmgr == null) {
            queuesOnRmtQmgr = new ArrayList<DmClusterQueue>();
        }
        if ((rqueueObj = this.getQueue(t, rqname, queuesOnRmtQmgr)) == null) {
            queuesOnRmtQmgr = (ArrayList<DmClusterQueue>)this.qclusters.get(remoteQmgr);
            if (queuesOnRmtQmgr == null) {
                queuesOnRmtQmgr = new ArrayList<DmClusterQueue>();
            }
            if ((rqueueObj = this.getClusterQueue(t, rqname, queuesOnRmtQmgr)) == null) {
                result = true;
            }
        }
        return result;
    }
}

