/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmProcess;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class QueueProcess
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/QueueProcess.java";
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    DmObjectFilter procs_query = new DmObjectFilter(Trace.getDefault(), 7);
    DmObjectFilter loc_queue_query = new DmObjectFilter(Trace.getDefault(), 13, 1);
    DmObjectFilter mod_queue_query = new DmObjectFilter(Trace.getDefault(), 13, 2);
    DmObjectFilter chans_query = new DmObjectFilter(Trace.getDefault(), 25);
    private static final String CHANNEL_INITIATION_QUEUE = "SYSTEM.CHANNEL.INITQ";
    private static final String TRIGMON_INITIATION_QUEUE = "SYSTEM.DEFAULT.INITIATION.QUEUE";
    private static final int NUMBER_OF_STAGES_PER_QMGR = 5;
    private int NUMBER_OF_TEST_STAGES = 0;
    private boolean includeSystemObjects = false;
    private ArrayList processes = new ArrayList();

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 5;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            DmQueue nextQueue;
            DmQueueManager nextQm = qmgrs.get(i);
            this.processes = this.syncDataModelQuery(t, nextQm, this.procs_query);
            if (this.processes == null) break;
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> queues = this.syncDataModelQuery(t, nextQm, this.loc_queue_query);
            if (queues == null) break;
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> channels = this.syncDataModelQuery(t, nextQm, this.chans_query);
            if (channels == null) break;
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> mod_queues = this.syncDataModelQuery(t, nextQm, this.mod_queue_query);
            if (mod_queues == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < queues.size()) {
                nextQueue = (DmQueue)queues.get(j);
                this.analyseQueue(t, nextQueue, nextQm, channels);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            int k = 0;
            while (k < mod_queues.size()) {
                nextQueue = (DmQueue)mod_queues.get(k);
                this.analyseQueue(t, nextQueue, nextQm, channels);
                ++k;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseQueue(Trace t, DmQueue queue, DmQueueManager qmgr, ArrayList<DmObject> chans) {
        WMQTestResult err;
        DmProcess procObj;
        String queueName = queue.getTitle();
        if (!this.includeSystemObjects && queueName.startsWith("SYSTEM.")) {
            return;
        }
        int trigattr = QueueProcess.getAttr(t, (DmObject)queue, 24);
        if (Trace.isTracing) {
            t.data(66, "QueueProcess.analyseQueue", 300, "trig = " + trigattr);
        }
        if (trigattr != 1) {
            return;
        }
        int usageattr = QueueProcess.getAttr(t, (DmObject)queue, 12);
        if (Trace.isTracing) {
            t.data(66, "QueueProcess.analyseQueue", 300, "usage = " + usageattr);
        }
        String initq = queue.getAttributeValue(t, 2008, 0);
        if (Trace.isTracing && initq != null) {
            t.data(66, "QueueProcess.analyseQueue", 300, "initq name = " + initq);
        }
        if (initq == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "QueueProcess.error", queueName), QueueProcess.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "QueueProcess.analyseQueue", 900, "Error encountered while getting initq attr from queue definition " + queueName);
            } else if (initq.equals("[not_found]") && Trace.isTracing) {
                t.data(66, "QueueProcess.analyseQueue", 300, "no initq attribute found - assuming default");
            }
            initq = TRIGMON_INITIATION_QUEUE;
        }
        String procattr = this.getNameAttribute(t, 2012, (DmObject)queue, queueName, qmgr);
        String trigdata = this.getNameAttribute(t, 2023, (DmObject)queue, queueName, qmgr);
        String userdata = "";
        if (usageattr == 1 && (procObj = this.getProcess(t, procattr, this.processes)) != null) {
            userdata = this.getNameAttribute(t, 2021, (DmObject)procObj, procattr, qmgr);
        }
        if (Trace.isTracing) {
            t.data(66, "QueueProcess.analyseQueue", 300, "process name = " + procattr);
            t.data(66, "QueueProcess.analyseQueue", 300, "trigdata = " + procattr);
            t.data(66, "QueueProcess.analyseQueue", 300, "userdata = " + userdata);
        }
        if (usageattr == 1 && initq.equals(CHANNEL_INITIATION_QUEUE)) {
            if (Trace.isTracing) {
                t.data(66, "QueueProcess.analyseQueue", 300, "usage is xmitq, and initq SYSTEM.CHANNEL.INITQ so checking for channel rather than a process");
            }
            if ((err = this.checkForChannel(t, procattr, trigdata, chans, queueName, qmgr)) != null) {
                this.testresults.add(err);
            }
        } else if (usageattr == 1) {
            if (Trace.isTracing) {
                t.data(66, "QueueProcess.analyseQueue", 300, "usage is xmitq, so checking for channel existance first rather than a process");
            }
            if ((err = this.checkForChannel(t, procattr, trigdata = "", chans, queueName, qmgr)) != null) {
                if (Trace.isTracing) {
                    t.data(66, "QueueProcess.analyseQueue", 300, "usage is xmitq, but could not find channel, so checking for process to run");
                }
                if (this.checkForProcess(t, procattr, queueName, qmgr) != null) {
                    this.testresults.add(err);
                }
            }
        } else {
            if (Trace.isTracing) {
                t.data(66, "QueueProcess.analyseQueue", 300, "not a xmitq, check for a process to run");
            }
            if ((err = this.checkForProcess(t, procattr, queueName, qmgr)) != null) {
                this.testresults.add(err);
            }
        }
    }

    private WMQTestResult checkForChannel(Trace t, String procattr, String trigdata, ArrayList chans, String queueName, DmQueueManager qmgr) {
        WMQTestResult result = null;
        if (procattr.length() > 0) {
            DmChannel trigdChan = this.getChannel(t, procattr, chans);
            if (trigdChan == null) {
                result = new WMQTestResult(2, Messages.getString(t, "QueueProcess.noChan", new String[]{queueName, procattr}), QueueProcess.getQueueManagerName(t, qmgr), this.getTestSubCategory());
            }
        } else if (trigdata.length() > 0) {
            DmChannel trigdChan = this.getChannel(t, trigdata, chans);
            if (trigdChan == null) {
                result = new WMQTestResult(2, Messages.getString(t, "QueueProcess.noChan", new String[]{queueName, trigdata}), QueueProcess.getQueueManagerName(t, qmgr), this.getTestSubCategory());
            }
        } else {
            boolean matchFound = false;
            int i = 0;
            while (i < chans.size()) {
                DmChannel nxtChan = (DmChannel)chans.get(i);
                String xmitQ = this.getNameAttribute(t, 3505, (DmObject)nxtChan, nxtChan.getTitle(), qmgr);
                if (queueName.equals(xmitQ)) {
                    matchFound = true;
                    break;
                }
                ++i;
            }
            if (!matchFound) {
                result = new WMQTestResult(2, Messages.getString(t, "QueueProcess.noChan", new String[]{queueName, ""}), QueueProcess.getQueueManagerName(t, qmgr), this.getTestSubCategory());
            }
        }
        return result;
    }

    private WMQTestResult checkForProcess(Trace t, String procattr, String queueName, DmQueueManager qmgr) {
        WMQTestResult result = null;
        DmProcess procObj = this.getProcess(t, procattr, this.processes);
        if (procObj == null) {
            result = new WMQTestResult(2, Messages.getString(t, "QueueProcess.noProcess", new String[]{queueName, procattr}), QueueProcess.getQueueManagerName(t, qmgr), this.getTestSubCategory());
        }
        return result;
    }

    private String getNameAttribute(Trace t, int attrId, DmObject obj, String objName, DmQueueManager qmgr) {
        String attrStr = obj.getAttributeValue(t, attrId, 0);
        if (attrStr == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "QueueProcess.error", objName), QueueProcess.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "QueueProcess.getNameAttribute", 900, "Error encountered while getting attr " + attrId + " from " + objName);
            }
            attrStr = "";
        } else if (attrStr.equals("[not_found]")) {
            if (Trace.isTracing) {
                t.data(66, "QueueProcess.getNameAttribute", 300, "no attribute found - doing nothing");
            }
            attrStr = "";
        }
        return attrStr;
    }
}

