/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmProcess;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.CommonUtilities;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProcessObjects
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/ProcessObjects.java";
    private boolean includeSystemObjects = false;
    private ArrayList testresults = new ArrayList();
    private static final int NUMBER_OF_STAGES_PER_QMGR = 2;
    private int NUMBER_OF_TEST_STAGES = 0;
    DmObjectFilter query = new DmObjectFilter(Trace.getDefault(), 7);

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 2;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> processes = this.syncDataModelQuery(t, nextQm, this.query);
            if (processes == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < processes.size()) {
                DmProcess nxtprocess = (DmProcess)processes.get(j);
                this.analyseProcess(t, nxtprocess, nextQm);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseProcess(Trace t, DmProcess process, DmQueueManager qmgr) {
        String processName = process.getTitle();
        if (!this.includeSystemObjects && processName.startsWith("SYSTEM.")) {
            return;
        }
        String applid = process.getAttributeValue(t, 2001, 0);
        if (applid != null) {
            if (applid.length() == 0 || applid.equals("[not_defined]")) {
                this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ProcessObjects.noAppId", processName), ProcessObjects.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            } else if (qmgr.isLocal(t)) {
                File fileIfAbsolutePath = new File(applid);
                if (Trace.isTracing) {
                    t.data(66, "ProcessObjects.analyseProcess", 300, "Local qmgr, trying to find application: " + applid);
                    if (fileIfAbsolutePath != null) {
                        t.data(66, "ProcessObjects.analyseProcess", 300, "Created file object, exists = " + fileIfAbsolutePath.exists() + " isFile = " + fileIfAbsolutePath.isFile());
                    }
                }
                if (!fileIfAbsolutePath.exists() || !fileIfAbsolutePath.isFile()) {
                    if (Trace.isTracing) {
                        t.data(66, "ProcessObjects.analyseProcess", 300, "File does not exist - trying to search path");
                    }
                    String progname = "";
                    String[] applidbits = applid.split(" ");
                    if (applidbits.length == 1) {
                        progname = applid;
                    } else if (applidbits.length > 1) {
                        String platform = System.getProperty("os.name");
                        if (platform.indexOf("Windows") != -1) {
                            if (applidbits[0].equalsIgnoreCase("start")) {
                                int k = 1;
                                while (k < applidbits.length) {
                                    if (!applidbits[k].startsWith("/")) {
                                        progname = applidbits[k];
                                        break;
                                    }
                                    ++k;
                                }
                            } else {
                                progname = applidbits[0];
                            }
                        } else {
                            progname = applidbits[0];
                        }
                    }
                    if (Trace.isTracing) {
                        t.data(66, "ProcessObjects.analyseProcess", 300, "Looking in path for application called: " + progname);
                    }
                    boolean fileExtensionSpecified = false;
                    int extindex = progname.lastIndexOf(".");
                    String procname = progname;
                    String procextn = "";
                    if (extindex != -1) {
                        procname = progname.substring(0, extindex);
                        procextn = progname.substring(extindex);
                    }
                    if (procextn.length() > 1) {
                        fileExtensionSpecified = true;
                    }
                    String systempath = System.getProperty("java.library.path");
                    String pathsep = System.getProperty("path.separator");
                    if (Trace.isTracing) {
                        t.data(66, "ProcessObjects.analyseProcess", 300, "System path = " + systempath);
                        t.data(66, "ProcessObjects.analyseProcess", 300, "Path separator = " + pathsep);
                    }
                    String[] paths = CommonUtilities.convert((Trace)Trace.getDefault(), (String)systempath, (String)pathsep);
                    HashSet<String> paths_unique = new HashSet<String>();
                    int x = 0;
                    while (x < paths.length) {
                        paths_unique.add(paths[x]);
                        ++x;
                    }
                    paths = paths_unique.toArray(new String[paths_unique.size()]);
                    int found = 0;
                    int i = 0;
                    while (i < paths.length) {
                        File fileIfRelativePath;
                        if (Trace.isTracing) {
                            t.data(66, "ProcessObjects.analyseProcess", 300, "Check path item: " + paths[i]);
                        }
                        if ((fileIfRelativePath = new File(paths[i], applid)).exists() && fileIfRelativePath.isFile()) {
                            ++found;
                        } else {
                            File nextPath = new File(paths[i]);
                            if (nextPath.exists() && nextPath.isDirectory()) {
                                if (Trace.isTracing) {
                                    t.data(66, "ProcessObjects.analyseProcess", 300, "Getting file list for path: " + nextPath);
                                }
                                File[] filesAtNextPath = nextPath.listFiles();
                                int j = 0;
                                while (j < filesAtNextPath.length) {
                                    File nextFileAtPath = filesAtNextPath[j];
                                    String nextFileName = nextFileAtPath.getName();
                                    if (Trace.isTracing) {
                                        t.data(66, "ProcessObjects.analyseProcess", 300, "Comparing '" + progname + "' with file on disk: " + nextFileName);
                                    }
                                    if (fileExtensionSpecified) {
                                        String platform = System.getProperty("os.name");
                                        if (platform.indexOf("Windows") != -1) {
                                            if (progname.equalsIgnoreCase(nextFileName)) {
                                                ++found;
                                            }
                                        } else if (progname.equals(nextFileName)) {
                                            ++found;
                                        }
                                    } else {
                                        String platform;
                                        String nxtFileBase = nextFileName;
                                        String nxtFileExtn = "";
                                        int extnindex = nextFileName.lastIndexOf(".");
                                        if (extnindex != -1) {
                                            nxtFileBase = nextFileName.substring(0, extnindex);
                                            nxtFileExtn = nextFileName.substring(extnindex);
                                        }
                                        if ((platform = System.getProperty("os.name")).indexOf("Windows") != -1) {
                                            if (procname.equalsIgnoreCase(nxtFileBase) && this.isKnownExecutableExtension(nxtFileExtn)) {
                                                ++found;
                                            }
                                        } else if (procname.equals(nextFileName)) {
                                            ++found;
                                        }
                                    }
                                    ++j;
                                }
                            }
                        }
                        ++i;
                    }
                    if (found == 0) {
                        this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ProcessObjects.appIdNotFound", new String[]{applid, processName}), ProcessObjects.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                    } else if (found > 1) {
                        this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ProcessObjects.multipleMatches", new String[]{applid, processName}), ProcessObjects.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                    }
                }
            } else if (!qmgr.isLocal(t) && Trace.isTracing) {
                t.data(66, "ProcessObjects.analyseProcess", 300, "Tried to check non-local queue manager: " + qmgr.getTreeName(t));
            }
        }
    }

    private boolean isKnownExecutableExtension(String extension) {
        return extension.equalsIgnoreCase(".exe") || extension.equalsIgnoreCase(".pl") || extension.equalsIgnoreCase(".bat") || extension.equalsIgnoreCase(".sh") || extension.equalsIgnoreCase(".com") || extension.equalsIgnoreCase(".dll") || extension.equalsIgnoreCase(".lnk") || extension.equalsIgnoreCase(".pif") || extension.equalsIgnoreCase(".cmd");
    }
}

