/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.ConnectionName;
import com.ibm.mq.commonservices.internal.utils.ConnectionNameList;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;

public class PingConnNames
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/PingConnNames.java";
    private static final int NUMBER_OF_STAGES_PER_QMGR = 2;
    private int NUMBER_OF_TEST_STAGES = 0;
    private ArrayList<WMQTestResult> testresults;
    private boolean includeSystemObjects = false;
    private HashSet<String> verifiedConnNames;
    private HashSet<String> problemConnNames;
    DmObjectFilter query = new DmObjectFilter(Trace.getDefault(), 25);

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        this.verifiedConnNames = new HashSet();
        this.problemConnNames = new HashSet();
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        int numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 2;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        block0: while (i < numqmgrs) {
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> channels = this.syncDataModelQuery(t, nextQm, this.query);
            if (channels == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < channels.size()) {
                DmChannel nxtChannel = (DmChannel)channels.get(j);
                this.analyseChannel(t, nxtChannel, nextQm);
                if (this.isCancelled()) break block0;
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseChannel(Trace t, DmChannel chan, DmQueueManager qmgr) {
        String channelName = chan.getTitle();
        if (!this.includeSystemObjects && channelName.startsWith("SYSTEM.")) {
            return;
        }
        Attr chltypeattr = chan.getAttribute(t, 1511, 0);
        int chltypeint = -1;
        if (chltypeattr != null) {
            chltypeint = (Integer)chltypeattr.getValue(t);
        }
        if (chltypeint != 7 && chltypeint != 3 && chltypeint != 11) {
            if (chan.isRunning(t)) {
                return;
            }
            String conn_name = chan.getAttributeValue(t, 3506, 0);
            if (conn_name == null) {
                this.testresults.add(new WMQTestResult(0, Messages.getString(t, "PingConnNames.chanValErr", chan.getTitle()), PingConnNames.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                if (Trace.isTracing) {
                    t.data(66, "PingConnNames.analyseChannel", 900, "Error encountered while getting connection name value from channel" + chan.getTitle());
                }
            } else if (conn_name.equals("") || conn_name.equals("[not_found]")) {
                this.testresults.add(new WMQTestResult(0, Messages.getString(t, "PingConnNames.connNameMissing", chan.getTitle()), PingConnNames.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            } else if (!this.checkConnName(t, conn_name)) {
                this.testresults.add(new WMQTestResult(1, Messages.getString(t, "PingConnNames.noPingResponse", new String[]{conn_name, chan.getTitle()}), PingConnNames.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            }
        }
    }

    private boolean checkConnName(Trace t, String conn_name) {
        boolean result = true;
        ConnectionNameList cnl = new ConnectionNameList(t, conn_name);
        ArrayList list = cnl.getListOfConnNames();
        int i = 0;
        while (i < list.size()) {
            block8: {
                String host = ((ConnectionName)list.get(i)).getHost();
                if (this.problemConnNames.contains(host)) {
                    result = false;
                    break;
                }
                if (!this.verifiedConnNames.contains(host)) {
                    String platform = System.getProperty("os.name");
                    String pingCmd = platform.indexOf("Windows") == -1 ? "ping -c 4 " : "ping ";
                    try {
                        Process pingProc = Runtime.getRuntime().exec(String.valueOf(pingCmd) + host);
                        int exitVal = pingProc.waitFor();
                        if (exitVal == 0) {
                            this.verifiedConnNames.add(host);
                            break block8;
                        }
                        this.problemConnNames.add(host);
                        result = false;
                    }
                    catch (IOException iOException) {
                        this.testresults.add(new WMQTestResult(0, Messages.getString(t, "PingConnNames.pingNotAvailable"), "", this.getTestSubCategory()));
                        WMQTestResult[] finalresults = this.testresults.toArray(new WMQTestResult[0]);
                        this.testComplete(finalresults);
                        this.problemConnNames.add(host);
                        result = false;
                    }
                    catch (InterruptedException interruptedException) {
                        this.testresults.add(new WMQTestResult(0, Messages.getString(t, "PingConnNAmes.pingError"), "", this.getTestSubCategory()));
                        if (Trace.isTracing) {
                            t.data(66, "PingConnNames.checkConnName", 900, "Unexpected thread interrupted while waiting for ping process");
                        }
                        this.problemConnNames.add(host);
                        result = false;
                    }
                    break;
                }
            }
            ++i;
        }
        return result;
    }
}

