/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFMessageAgent;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.PCFQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class MCAallon
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/MCAallon.java";
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private static final int NUMBER_OF_STAGES_PER_QMGR = 3;
    private int NUMBER_OF_TEST_STAGES = 0;
    DmObjectFilter query = new DmObjectFilter(Trace.getDefault(), 25);

    public MQExtObject[] getApplicableObjects(MQExtObject[] contextObjects) {
        Trace t = Trace.getDefault();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        Map<DmQueueManager, MQExtObject> qmgrMap = this.getFilteredQueueManagersMap(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        ArrayList<DmQueueManager> qmgrsToRemove = new ArrayList<DmQueueManager>();
        for (DmQueueManager qmgr : qmgrMap.keySet()) {
            if (qmgr.getCommandLevel() >= 710) continue;
            qmgrsToRemove.add(qmgr);
        }
        for (DmQueueManager qmgr : qmgrsToRemove) {
            qmgrMap.remove(qmgr);
        }
        MQExtObject[] validObjs = qmgrMap.values().toArray(new MQExtObject[0]);
        return validObjs;
    }

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<MQQmgrExtObject> allMQExtQmgrs = new ArrayList<MQQmgrExtObject>();
        int nx = 0;
        while (nx < contextObjects.length) {
            UiQueueManager uiQmgr;
            DmQueueManager dmQmgr;
            MQQmgrExtObject mqExtQmgr;
            Object obj;
            if (contextObjects[nx] instanceof MQQmgrExtObject && (obj = (mqExtQmgr = (MQQmgrExtObject)contextObjects[nx]).getInternalObject()) != null && obj instanceof UiQueueManager && (dmQmgr = (uiQmgr = (UiQueueManager)obj).getDmQueueManagerObject()).isRunning() && dmQmgr.isConnected() && dmQmgr.isVisible(t) == visibleQmgrsOnly) {
                allMQExtQmgrs.add((MQQmgrExtObject)contextObjects[nx]);
            }
            ++nx;
        }
        numqmgrs = allMQExtQmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 3;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            MQQmgrExtObject nextMQExtQmgr = (MQQmgrExtObject)allMQExtQmgrs.get(i);
            UiQueueManager nextUiQmgr = (UiQueueManager)nextMQExtQmgr.getInternalObject();
            DmQueueManager nextDmQmgr = nextUiQmgr.getDmQueueManagerObject();
            ArrayList<DmObject> channels = this.syncDataModelQuery(t, nextDmQmgr, this.query);
            if (channels == null) break;
            this.getGUIMonitor().worked(1);
            int qmgrChlAuth = MCAallon.getAttr(t, (DmObject)nextDmQmgr, 248);
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < channels.size()) {
                DmChannel nxtChannel = (DmChannel)channels.get(j);
                this.analyseChannel(t, nxtChannel, nextMQExtQmgr, qmgrChlAuth);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseChannel(Trace t, DmChannel chan, MQQmgrExtObject extQmgr, int qmgrChlAuth) {
        int chlType;
        UiQueueManager uiQmgr = (UiQueueManager)extQmgr.getInternalObject();
        DmQueueManager dmQmgr = uiQmgr.getDmQueueManagerObject();
        String channelName = chan.getTitle();
        boolean checkingDynamicChan = false;
        boolean blankMCA = false;
        boolean hasChlAuth = false;
        if (channelName.startsWith("SYSTEM.AUTO.")) {
            int chad_enabled = MCAallon.getAttr(t, (DmObject)dmQmgr, 55);
            String chad_exit = dmQmgr.getAttributeValue(t, 2026, 0);
            if (chad_enabled == 1 && (chad_exit.length() == 0 || chad_exit.equals("[not_found]"))) {
                checkingDynamicChan = true;
            }
        }
        if ((chlType = MCAallon.getAttr(t, (DmObject)chan, 1511)) == 1 || chlType == 2 || chlType == 9) {
            return;
        }
        String mcaUser = chan.getAttributeValue(t, 3527, 0);
        if (mcaUser.length() == 0 || mcaUser.equals("[not_found]")) {
            blankMCA = true;
        } else if (!mcaUser.equals("mqm")) {
            return;
        }
        String securityExit = chan.getAttributeValue(t, 3508, 0);
        if (securityExit.length() != 0 && !securityExit.equals("[not_found]")) {
            return;
        }
        String sslCipherSpec = chan.getAttributeValue(t, 3544, 0);
        if (sslCipherSpec.length() != 0 && !sslCipherSpec.equals("[not_found]")) {
            return;
        }
        hasChlAuth = this.hasChannelAuthenticationRecord(t, chan, extQmgr);
        if (hasChlAuth && qmgrChlAuth == 1) {
            return;
        }
        if (checkingDynamicChan) {
            if (blankMCA) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "UnprotectedInboundChannels.dynUnprotInChlBlankMCA", channelName), MCAallon.getQueueManagerName(t, dmQmgr), this.getTestSubCategory()));
            } else {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "UnprotectedInboundChannels.dynUnprotInChlMqmMCA", channelName), MCAallon.getQueueManagerName(t, dmQmgr), this.getTestSubCategory()));
            }
        } else if (blankMCA) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "UnprotectedInboundChannels.unprotInChlBlankMCA", channelName), MCAallon.getQueueManagerName(t, dmQmgr), this.getTestSubCategory()));
        } else {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "UnprotectedInboundChannels.unprotInChlMqmMCA", channelName), MCAallon.getQueueManagerName(t, dmQmgr), this.getTestSubCategory()));
        }
    }

    private boolean hasChannelAuthenticationRecord(Trace t, DmChannel chan, MQQmgrExtObject extQmgr) {
        boolean hasChlAuth = false;
        boolean validName = false;
        try {
            PCFMessageAgent agent = new PCFMessageAgent(extQmgr.getMQQueueManager());
            PCFMessage cmd = new PCFMessage(204);
            cmd.addParameter(3501, chan.getTitle());
            cmd.addParameter(1352, 0);
            cmd.addParameter(1637, 3);
            cmd.addParameter(1355, PCFQuery.ALL_ATTRS);
            PCFMessage[] responses = agent.send(cmd);
            hasChlAuth = true;
            int nx = 0;
            while (nx < responses.length) {
                PCFParameter nameParam = responses[nx].getParameter(3501);
                if (nameParam != null) {
                    String name = nameParam.getStringValue();
                    validName = true;
                    if (Trace.isTracing) {
                        t.data(66, "MCAallon.hasChannelAuthenticationRecord", 300, "Channel " + chan.getTitle() + " is protected through channel authentication record " + name);
                    }
                }
                ++nx;
            }
            if (!validName) {
                hasChlAuth = false;
            }
        }
        catch (PCFException e) {
            if (e.getReason() == 3338) {
                hasChlAuth = false;
            } else {
                if (Trace.isTracing) {
                    t.data(66, "MCAallon.hasChannelAuthenticationRecord", 900, "Unexpected PCFException while checking chlauth: " + e.getMessage());
                    t.data(66, "MCAallon.hasChannelAuthenticationRecord", 900, t.getJavaStack((Throwable)e));
                }
                this.testresults.add(new WMQTestResult(1, Messages.getString(t, "UnprotectedInboundChannels.errorQueryingChl", new String[]{chan.getTitle(), this.getTestName()}), extQmgr.getName(), this.getTestSubCategory()));
            }
        }
        catch (MQException e) {
            if (e.getReason() == 2085 || e.getReason() == 3312) {
                hasChlAuth = false;
            } else {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return hasChlAuth;
    }
}

