/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;

public class ListenerPorts
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/ListenerPorts.java";
    private boolean includeSystemObjects = false;
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private static final int NUMBER_OF_STAGES_PER_QMGR = 2;
    private int NUMBER_OF_TEST_STAGES = 0;
    DmObjectFilter query = new DmObjectFilter(Trace.getDefault(), 97, 2);
    private HashMap<InetAddress, HashSet<Integer>> portNumsInUse;

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.portNumsInUse = new HashMap();
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, true);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 2;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> listeners = this.syncDataModelQuery(t, nextQm, this.query);
            if (listeners == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < listeners.size()) {
                DmListener nxtListener = (DmListener)listeners.get(j);
                this.analyseListener(t, nxtListener, nextQm);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseListener(Trace t, DmListener nxtListener, DmQueueManager nxtQmgr) {
        block11: {
            String listenerName = nxtListener.getTitle();
            if (!this.includeSystemObjects && listenerName.startsWith("SYSTEM.")) {
                return;
            }
            Attr portnumattr = nxtListener.getAttribute(t, 1522, 0);
            if (portnumattr != null) {
                Integer portnum = (Integer)portnumattr.getValue(t);
                int port = portnum;
                if (this.isPortNumberReserved(port)) {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ListenerPorts.reservedPort", new String[]{nxtQmgr.getTitle(), nxtListener.getTitle(), "" + port}), ListenerPorts.getQueueManagerName(t, nxtQmgr), this.getTestSubCategory()));
                }
                String machineaddr = "";
                if (nxtQmgr.isLocal()) {
                    machineaddr = "localhost";
                } else {
                    DmQueueManagerHandle hnd = nxtQmgr.getParent().getQueueManager().getConnectionHandle();
                    QueueManagerHandle connhandle = hnd.getQueueManagerHandle(t);
                    String conname = connhandle.getConnectionName();
                    if (conname != null && !conname.equals("[not_defined]") && conname.length() > 0 && (machineaddr = this.getHostName(t, conname)).equals("127.0.0.1")) {
                        machineaddr = "localhost";
                    }
                }
                try {
                    InetAddress address = InetAddress.getByName(machineaddr);
                    HashSet<Integer> portnums = this.portNumsInUse.get(address);
                    if (portnums == null) {
                        portnums = new HashSet();
                    }
                    if (portnums.contains(portnum)) {
                        this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ListenerPorts.portClash", new String[]{address.getHostName(), "" + port, nxtListener.getTitle()}), ListenerPorts.getQueueManagerName(t, nxtQmgr), this.getTestSubCategory()));
                    } else {
                        portnums.add(portnum);
                        this.portNumsInUse.put(address, portnums);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ListenerPorts.error", new String[]{machineaddr, nxtQmgr.getTitle()}), ListenerPorts.getQueueManagerName(t, nxtQmgr), this.getTestSubCategory()));
                    if (!Trace.isTracing) break block11;
                    t.data(66, "ListenerPorts.analyseListener", 900, "Error encountered while resolving the hostname (" + machineaddr + ") for " + nxtQmgr.getTitle());
                }
            }
        }
    }

    private boolean isPortNumberReserved(int portnum) {
        return portnum < 1024 && portnum > 0;
    }

    private String getHostName(Trace t, String conname) {
        String hostname = conname;
        int index = conname.lastIndexOf("(");
        if (index != -1) {
            hostname = conname.substring(0, index);
        }
        return hostname;
    }
}

