/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueue;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;

public class InitiationQueues
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/InitiationQueues.java";
    private boolean includeSystemObjects = false;
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private static final int NUMBER_OF_STAGES_PER_QMGR = 2;
    private int NUMBER_OF_TEST_STAGES = 0;
    DmObjectFilter query = new DmObjectFilter(Trace.getDefault(), 13);
    private HashMap<DmQueueManager, ArrayList<DmQueue>> confirmedInitQs = new HashMap();

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.confirmedInitQs = new HashMap();
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 2;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> queues = this.syncDataModelQuery(t, nextQm, this.query);
            ArrayList<DmObject> clusterQueues = this.syncDataModelQuery(t, nextQm, new DmObjectFilter(Trace.getDefault(), 1004));
            queues.addAll(clusterQueues);
            if (queues == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < queues.size()) {
                if (queues.get(j) instanceof DmQueue) {
                    DmQueue nxtQueue = (DmQueue)queues.get(j);
                    this.analyseQueue(t, nxtQueue, queues, nextQm);
                }
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseQueue(Trace t, DmQueue queue, ArrayList<DmObject> allqueues, DmQueueManager qmgr) {
        String queueName = queue.getTitle();
        if (!this.includeSystemObjects && queueName.startsWith("SYSTEM.")) {
            return;
        }
        String initqattr = queue.getAttributeValue(t, 2008, 0);
        if (initqattr == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "InitiationQueues.error", queueName), InitiationQueues.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "InitiationQueues.analyseQueue", 900, "Error encountered while getting initiation queue attribute from queue" + queueName);
            }
        } else if (!initqattr.equals("[not_found]") && initqattr.length() != 0) {
            for (DmObject nQ : allqueues) {
                DmQueue q;
                DmClusterQueue dcq;
                String name;
                if (!(nQ instanceof DmClusterQueue) || !initqattr.equals(name = (dcq = (DmClusterQueue)nQ).toString(t)) || (q = this.getQueue(t, name, allqueues)) != null) continue;
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "InitiationQueues.isCluster", new String[]{queueName, initqattr}), InitiationQueues.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                return;
            }
            DmQueue initQobj = this.getQueue(t, initqattr, allqueues);
            if (initQobj == null) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "InitiationQueues.queueNotExist", new String[]{queueName, initqattr}), InitiationQueues.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            } else {
                int initqtype = InitiationQueues.getAttr(t, (DmObject)initQobj, 20);
                switch (initqtype) {
                    case 3: {
                        this.testresults.add(new WMQTestResult(2, Messages.getString(t, "InitiationQueues.isAlias", new String[]{queueName, initqattr}), InitiationQueues.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                        break;
                    }
                    case 2: {
                        this.testresults.add(new WMQTestResult(2, Messages.getString(t, "InitiationQueues.isModel", new String[]{queueName, initqattr}), InitiationQueues.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                        break;
                    }
                    case 6: {
                        this.testresults.add(new WMQTestResult(2, Messages.getString(t, "InitiationQueues.isRemote", new String[]{queueName, initqattr}), InitiationQueues.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                        break;
                    }
                    case 1: {
                        this.analyseInitiationQueue(t, initQobj);
                        break;
                    }
                    default: {
                        this.testresults.add(new WMQTestResult(2, Messages.getString(t, "InitiationQueues.unrecognised", new String[]{"" + initqtype, initqattr}), InitiationQueues.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                        if (!Trace.isTracing) break;
                        t.data(66, "InitiationQueues.analyseQueue", 900, "Unrecognised type (" + initqtype + ") received for queue" + initqattr);
                    }
                }
            }
        }
    }

    private void analyseInitiationQueue(Trace t, DmQueue initq) {
        DmQueueManager host = initq.getQueueManager();
        ArrayList<Object> queuesAlreadyChecked = this.confirmedInitQs.get(host);
        if (queuesAlreadyChecked == null) {
            queuesAlreadyChecked = new ArrayList();
        }
        if (!queuesAlreadyChecked.contains(initq)) {
            int ipprocs = InitiationQueues.getAttr(t, (DmObject)initq, 17);
            if (ipprocs <= 0) {
                this.testresults.add(new WMQTestResult(1, Messages.getString(t, "InitiationQueues.noInput", initq.getTitle()), InitiationQueues.getQueueManagerName(t, host), this.getTestSubCategory()));
            }
            queuesAlreadyChecked.add(initq);
            this.confirmedInitQs.put(host, queuesAlreadyChecked);
        }
    }
}

