/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class DefXmitQ
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/DefXmitQ.java";
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private static final int NUMBER_OF_STAGES_PER_QMGR = 2;
    private int NUMBER_OF_TEST_STAGES = 0;
    private DmObjectFilter query = null;

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 2;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            ArrayList<DmObject> allQueues;
            DmQueueManager nextQm = qmgrs.get(i);
            if (this.query == null) {
                this.query = new DmObjectFilter(t, 13);
            }
            if ((allQueues = this.syncDataModelQuery(t, nextQm, this.query)) == null) break;
            this.getGUIMonitor().worked(1);
            this.analyseQmgr(t, nextQm, allQueues);
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseQmgr(Trace t, DmQueueManager qmgr, ArrayList allqueues) {
        String xmitqname = qmgr.getAttributeValue(t, 2025, 0);
        if (xmitqname == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "DefXmitQ.error", DefXmitQ.getQueueManagerName(t, qmgr)), DefXmitQ.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "DefXmitQ.analyseQmgr", 900, "Error encountered while getting default transmission queue name from " + DefXmitQ.getQueueManagerName(t, qmgr));
            }
        } else if (xmitqname.length() == 0 || xmitqname.equals("[not_found]")) {
            this.testresults.add(new WMQTestResult(0, Messages.getString(t, "DefXmitQ.noXmit", qmgr.getTitle()), DefXmitQ.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        } else {
            DmQueue xmitQobj = this.getQueue(t, xmitqname, allqueues);
            if (xmitQobj != null) {
                this.analyseXmitQueue(t, xmitqname, xmitQobj, qmgr);
            } else {
                int i = 0;
                while (i < allqueues.size()) {
                    DmQueue nxtQueue = (DmQueue)allqueues.get(i);
                    if (nxtQueue.getTitle().equalsIgnoreCase(xmitqname)) {
                        xmitQobj = nxtQueue;
                        break;
                    }
                    ++i;
                }
                if (xmitQobj != null) {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "DefXmitQ.capital", xmitqname), DefXmitQ.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                } else {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "DefXmitQ.notExist", xmitqname), DefXmitQ.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                }
            }
        }
    }

    private final void analyseXmitQueue(Trace t, String xmitqname, DmQueue xmitQobj, DmQueueManager qmgr) {
        int xmitqtype = DefXmitQ.getAttr(t, (DmObject)xmitQobj, 20);
        if (xmitqtype != 1) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "DefXmitQ.notLocal", new String[]{qmgr.getTitle(), xmitqname}), DefXmitQ.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        } else {
            int usage = DefXmitQ.getAttr(t, (DmObject)xmitQobj, 12);
            if (usage != 1) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "DefXmitQ.badUsage", new String[]{qmgr.getTitle(), xmitqname}), DefXmitQ.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            }
        }
    }
}

