/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class DLQ
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/DLQ.java";
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private DmObjectFilter all_q_query = null;
    private DmObjectFilter all_chans_query = null;
    private static final int NUMBER_OF_STAGES_PER_QMGR = 3;
    private int NUMBER_OF_TEST_STAGES = 0;
    private boolean includeSystemObjects = false;

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 3;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            ArrayList<DmObject> allQueues;
            DmQueueManager nextQm = qmgrs.get(i);
            if (this.all_q_query == null) {
                this.all_q_query = new DmObjectFilter(t, 13);
            }
            if ((allQueues = this.syncDataModelQuery(t, nextQm, this.all_q_query)) == null) break;
            this.getGUIMonitor().worked(1);
            DmQueue deadletterq = this.getDLQ(t, nextQm, allQueues);
            if (deadletterq == null) {
                this.getGUIMonitor().worked(2);
            } else {
                ArrayList<DmObject> channels;
                this.checkDLQdepth(t, deadletterq, nextQm);
                this.checkDLQprocs(t, deadletterq, nextQm);
                if (this.all_chans_query == null) {
                    this.all_chans_query = new DmObjectFilter(t, 25);
                }
                if ((channels = this.syncDataModelQuery(t, nextQm, this.all_chans_query)) == null) break;
                this.getGUIMonitor().worked(1);
                int j = 0;
                while (j < channels.size()) {
                    DmChannel nxtChannel = (DmChannel)channels.get(j);
                    this.analyseChannel(t, nxtChannel, deadletterq, nextQm);
                    ++j;
                }
                this.getGUIMonitor().worked(1);
            }
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private DmQueue getDLQ(Trace t, DmQueueManager qmgr, ArrayList allqs) {
        DmQueue dlq = null;
        String nxtDLQ = qmgr.getAttributeValue(t, 2006, 0);
        if (nxtDLQ == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "DLQ.error", DLQ.getQueueManagerName(t, qmgr)), DLQ.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "DLQ.getDLQ", 900, "Error encountered while getting dead letter queue attribute from " + DLQ.getQueueManagerName(t, qmgr));
            }
        } else if (nxtDLQ.length() == 0) {
            this.testresults.add(new WMQTestResult(1, Messages.getString(t, "DLQ.noDLQ", qmgr.getTitle()), DLQ.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        } else {
            dlq = this.getQueue(t, nxtDLQ, allqs);
            if (dlq == null) {
                int i = 0;
                while (i < allqs.size()) {
                    DmQueue nxtQueue = (DmQueue)allqs.get(i);
                    if (nxtQueue.getTitle().equalsIgnoreCase(nxtDLQ)) {
                        dlq = nxtQueue;
                        break;
                    }
                    ++i;
                }
                if (dlq != null) {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "DLQ.badCaps", nxtDLQ), DLQ.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                } else {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "DLQ.notExist", nxtDLQ), DLQ.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                }
            } else {
                int dlqtype = DLQ.getAttr(t, (DmObject)dlq, 20);
                if (dlqtype != 1) {
                    dlq = null;
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "DLQ.notLocal", nxtDLQ), DLQ.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                }
            }
        }
        return dlq;
    }

    private void checkDLQdepth(Trace t, DmQueue dlq, DmQueueManager qmgr) {
        int depth;
        int putdisattr = DLQ.getAttr(t, (DmObject)dlq, 10);
        if (putdisattr == 1) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "DLQ.putDisabled", dlq.getTitle()), DLQ.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        }
        if ((depth = DLQ.getAttr(t, (DmObject)dlq, 3)) > 0) {
            int maxdepth = DLQ.getAttr(t, (DmObject)dlq, 15);
            if (depth < maxdepth) {
                this.testresults.add(new WMQTestResult(1, Messages.getString(t, "DLQ.hasMessages", new String[]{dlq.getTitle(), "" + depth}), DLQ.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            } else {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "DLQ.full", dlq.getTitle()), DLQ.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            }
        }
    }

    private void checkDLQprocs(Trace t, DmQueue dlq, DmQueueManager qmgr) {
        int ipprocs = DLQ.getAttr(t, (DmObject)dlq, 17);
        if (ipprocs <= 0) {
            this.testresults.add(new WMQTestResult(1, Messages.getString(t, "DLQ.noHandler", dlq.getTitle()), DLQ.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        }
    }

    private void analyseChannel(Trace t, DmChannel nxtChannel, DmQueue dlq, DmQueueManager qmgr) {
        int queuemsglen;
        String channelName = nxtChannel.getTitle();
        if (!this.includeSystemObjects && channelName.startsWith("SYSTEM.")) {
            return;
        }
        int chanmsglen = DLQ.getAttr(t, (DmObject)nxtChannel, 1510);
        if (chanmsglen > (queuemsglen = DLQ.getAttr(t, (DmObject)dlq, 13))) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "DLQ.maxLenTooBig", new String[]{nxtChannel.getTitle(), "" + chanmsglen, "" + queuemsglen, dlq.getTitle()}), DLQ.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        }
    }
}

