/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.ConnectionName;
import com.ibm.mq.commonservices.internal.utils.ConnectionNameList;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;

public class ConnNames
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/ConnNames.java";
    private static final int NUMBER_OF_STAGES_PER_QMGR = 2;
    private int NUMBER_OF_TEST_STAGES = 0;
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private boolean includeSystemObjects = false;
    private HashSet<String> verifiedConnNames;
    private HashSet<String> problemConnNames;
    DmObjectFilter query = null;

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        this.verifiedConnNames = new HashSet();
        this.problemConnNames = new HashSet();
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        int numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 2;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        block0: while (i < numqmgrs) {
            ArrayList<DmObject> channels;
            DmQueueManager nextQm = qmgrs.get(i);
            if (this.query == null) {
                this.query = new DmObjectFilter(t, 25);
            }
            if ((channels = this.syncDataModelQuery(t, nextQm, this.query)) == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < channels.size()) {
                DmChannel nxtChannel = (DmChannel)channels.get(j);
                this.analyseChannel(t, nxtChannel, nextQm);
                if (this.isCancelled()) break block0;
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseChannel(Trace t, DmChannel chan, DmQueueManager qmgr) {
        String channelName = chan.getTitle();
        if (!this.includeSystemObjects && channelName.startsWith("SYSTEM.")) {
            return;
        }
        int chltype = ConnNames.getAttr(t, (DmObject)chan, 1511);
        int trptype = ConnNames.getAttr(t, (DmObject)chan, 1501);
        if (chltype != 7 && chltype != 3 && chltype != 11) {
            if (chan.isRunning(t) || trptype != 2) {
                return;
            }
            String conn_name = chan.getAttributeValue(t, 3506, 0);
            if (conn_name == null) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ConnNames.attrError", chan.getTitle()), ConnNames.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            } else if (conn_name.equals("") || conn_name.equals("[not_found]")) {
                int messageSeverity = 2;
                if (chltype == 2 || chltype == 8) {
                    messageSeverity = 0;
                }
                this.testresults.add(new WMQTestResult(messageSeverity, Messages.getString(t, "ConnNames.connMissing", chan.getTitle()), ConnNames.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            } else if (!this.checkConnName(t, conn_name)) {
                this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ConnNames.resolveError", new String[]{chan.getTitle(), conn_name}), ConnNames.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            }
        }
    }

    private boolean checkConnName(Trace t, String conn_name) {
        boolean result = true;
        ConnectionNameList cnl = new ConnectionNameList(t, conn_name);
        ArrayList list = cnl.getListOfConnNames();
        int i = 0;
        while (i < list.size()) {
            String host = ((ConnectionName)list.get(i)).getHost();
            if (this.problemConnNames.contains(host)) {
                result = false;
                break;
            }
            if (!this.verifiedConnNames.contains(host)) {
                try {
                    InetAddress.getByName(host);
                }
                catch (UnknownHostException unknownHostException) {
                    this.problemConnNames.add(host);
                    result = false;
                    break;
                }
                this.verifiedConnNames.add(host);
            }
            ++i;
        }
        return result;
    }
}

