/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChannelPings
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/ChannelPings.java";
    private boolean includeSystemObjects = false;
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private static final int NUMBER_OF_STAGES_PER_QMGR = 2;
    private int NUMBER_OF_TEST_STAGES = 0;
    DmObjectFilter query = new DmObjectFilter(Trace.getDefault(), 25);

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 2;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        block0: while (i < numqmgrs) {
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> channels = this.syncDataModelQuery(t, nextQm, this.query);
            if (channels == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < channels.size()) {
                DmChannel nxtChannel = (DmChannel)channels.get(j);
                this.analyseChannel(t, nxtChannel, nextQm);
                if (this.isCancelled()) break block0;
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseChannel(Trace t, DmChannel chan, DmQueueManager qmgr) {
        int pingresult;
        String channelName = chan.getTitle();
        if (!this.includeSystemObjects && channelName.startsWith("SYSTEM.")) {
            return;
        }
        int chltype = ChannelPings.getAttr(t, (DmObject)chan, 1511);
        if (!(chltype != 1 && chltype != 2 && chltype != 9 || chan.isRunning(t) || (pingresult = chan.actionPing(t, null)) == 0)) {
            this.generateError(t, pingresult, channelName, ChannelPings.getQueueManagerName(t, qmgr));
        }
    }

    private void generateError(Trace t, int errorcode, String channame, String qmgrname) {
        switch (errorcode) {
            case 4009: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.allocationFailed", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 4024: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.bindFailed", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 3049: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.ccsidError", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 4090: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.chanClosed", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 4031: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.inUse", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 4032: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.notFound", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 4011: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.confErr", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 4017: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.connClosed", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 4012: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.connRefused", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 4013: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.invalidConn", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 4010: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.unavailable", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 4035: {
                this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ChannelPings.qmgrTerminating", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 4034: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.qmgrUnavailable", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 4065: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.secExit", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 4033: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.unknown", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 4039: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.userExit", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 2042: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.inUse", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 2085: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.unknownObj", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 2033: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.noMsgAvail", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 3211: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.dispConflict", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            case 3235: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.chlErr", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
                break;
            }
            default: {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPings.otherError", new String[]{channame, "" + errorcode}), qmgrname, this.getTestSubCategory()));
            }
        }
    }
}

