/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChannelPairs
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/ChannelPairs.java";
    private boolean includeSystemObjects = false;
    private ArrayList testresults = new ArrayList();
    private static final int NUMBER_OF_STAGES_PER_QMGR = 10;
    private int NUMBER_OF_TEST_STAGES = 0;
    DmObjectFilter sdrchanquery = new DmObjectFilter(Trace.getDefault(), 25, 1);
    DmObjectFilter rcvchanquery = new DmObjectFilter(Trace.getDefault(), 25, 3);
    DmObjectFilter reqchanquery = new DmObjectFilter(Trace.getDefault(), 25, 4);
    DmObjectFilter svrchanquery = new DmObjectFilter(Trace.getDefault(), 25, 2);
    private HashMap channelscollection = new HashMap();

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.channelscollection = new HashMap();
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 10;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            ArrayList<DmObject> senderChannels;
            DmQueueManager nextQm = qmgrs.get(i);
            IntChannelStore currstore = (IntChannelStore)this.channelscollection.get(nextQm);
            if (currstore == null) {
                currstore = new IntChannelStore();
                currstore.setQmName(nextQm.getTitle());
                currstore.setUUID(nextQm.getUUID());
            }
            if ((senderChannels = this.syncDataModelQuery(t, nextQm, this.sdrchanquery)) == null) break;
            this.getGUIMonitor().worked(1);
            currstore.setSdrChans(senderChannels);
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> receiverChannels = this.syncDataModelQuery(t, nextQm, this.rcvchanquery);
            if (receiverChannels == null) break;
            this.getGUIMonitor().worked(1);
            currstore.setRcvChans(receiverChannels);
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> requesterChannels = this.syncDataModelQuery(t, nextQm, this.reqchanquery);
            if (requesterChannels == null) break;
            this.getGUIMonitor().worked(1);
            currstore.setReqChans(requesterChannels);
            this.getGUIMonitor().worked(1);
            ArrayList<DmObject> serverChannels = this.syncDataModelQuery(t, nextQm, this.svrchanquery);
            if (serverChannels == null) break;
            this.getGUIMonitor().worked(1);
            currstore.setSvrChans(serverChannels);
            this.getGUIMonitor().worked(1);
            this.channelscollection.put(nextQm, currstore);
            this.getGUIMonitor().worked(1);
            ++i;
        }
        int qmidx = 0;
        while (qmidx < numqmgrs) {
            DmQueueManager qmgr = qmgrs.get(qmidx);
            IntChannelStore nextStore = (IntChannelStore)this.channelscollection.get(qmgr);
            if (nextStore != null) {
                this.analyseSenderChannels(t, nextStore.getSdrChans(), qmgr);
                this.analyseRequesterChannels(t, nextStore.getReqChans(), qmgr);
                this.analyseServerChannels(t, nextStore.getSvrChans(), qmgr);
            }
            this.getGUIMonitor().worked(1);
            ++qmidx;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseSenderChannels(Trace t, ArrayList channels, DmQueueManager hostqmgr) {
        int i = 0;
        while (i < channels.size()) {
            DmChannel nextSdrChan = (DmChannel)channels.get(i);
            String channelname = nextSdrChan.getTitle();
            if (this.includeSystemObjects || !channelname.startsWith("SYSTEM.")) {
                ArrayList<DmChannel> matches = new ArrayList<DmChannel>();
                Set entries = this.channelscollection.entrySet();
                for (Map.Entry entry : entries) {
                    IntChannelStore nxtStore = (IntChannelStore)entry.getValue();
                    DmChannel match = nxtStore.getReceiverChannel(channelname);
                    if (match == null) continue;
                    matches.add(match);
                }
                switch (matches.size()) {
                    case 0: {
                        this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ChannelPairs.noSenderMatch", channelname), ChannelPairs.getQueueManagerName(t, hostqmgr), this.getTestSubCategory()));
                        break;
                    }
                    case 1: {
                        DmChannel match = (DmChannel)matches.get(0);
                        if (!match.getTitle().equals(channelname)) {
                            this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ChannelPairs.closeCaseReceiverForSender", new String[]{channelname, match.getTitle()}), ChannelPairs.getQueueManagerName(t, hostqmgr), this.getTestSubCategory()));
                            break;
                        }
                        this.compareSdrRcvrAttrs(t, nextSdrChan, match);
                        break;
                    }
                    default: {
                        DmChannel match = this.findMatchingChannel(t, nextSdrChan, matches);
                        if (match == null) {
                            this.testresults.add(new WMQTestResult(0, Messages.getString(t, "ChannelPairs.multipleRecivers", channelname), ChannelPairs.getQueueManagerName(t, hostqmgr), this.getTestSubCategory()));
                            break;
                        }
                        this.compareSdrRcvrAttrs(t, nextSdrChan, match);
                    }
                }
            }
            ++i;
        }
    }

    private void analyseServerChannels(Trace t, ArrayList channels, DmQueueManager hostqmgr) {
        int i = 0;
        while (i < channels.size()) {
            DmChannel nextSvrChan = (DmChannel)channels.get(i);
            String channelname = nextSvrChan.getTitle();
            if (this.includeSystemObjects || !channelname.startsWith("SYSTEM.")) {
                ArrayList<DmChannel> matches = new ArrayList<DmChannel>();
                Set entries = this.channelscollection.entrySet();
                for (Map.Entry entry : entries) {
                    IntChannelStore nxtStore = (IntChannelStore)entry.getValue();
                    DmChannel match = nxtStore.getReceiverChannel(channelname);
                    if (match == null) continue;
                    matches.add(match);
                }
                switch (matches.size()) {
                    case 0: {
                        this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ChannelPairs.noRecieverForServerconn", channelname), ChannelPairs.getQueueManagerName(t, hostqmgr), this.getTestSubCategory()));
                        break;
                    }
                    case 1: {
                        DmChannel match = (DmChannel)matches.get(0);
                        if (!match.getTitle().equals(channelname)) {
                            this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ChannelPairs.closeCaseReceiverForServer", new String[]{channelname, match.getTitle()}), ChannelPairs.getQueueManagerName(t, hostqmgr), this.getTestSubCategory()));
                            break;
                        }
                        this.compareSvrRcvrAttrs(t, nextSvrChan, match);
                        break;
                    }
                    default: {
                        DmChannel match = this.findMatchingChannel(t, nextSvrChan, matches);
                        if (match == null) {
                            this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ChannelPairs.mutipleRecvForSvrconn", channelname), ChannelPairs.getQueueManagerName(t, hostqmgr), this.getTestSubCategory()));
                            break;
                        }
                        this.compareSvrRcvrAttrs(t, nextSvrChan, match);
                    }
                }
            }
            ++i;
        }
    }

    private void analyseRequesterChannels(Trace t, ArrayList channels, DmQueueManager hostqmgr) {
        int i = 0;
        while (i < channels.size()) {
            DmChannel nextReqChan = (DmChannel)channels.get(i);
            String channelname = nextReqChan.getTitle();
            if (this.includeSystemObjects || !channelname.startsWith("SYSTEM.")) {
                ArrayList<DmChannel> matches = new ArrayList<DmChannel>();
                Set entries = this.channelscollection.entrySet();
                for (Map.Entry entry : entries) {
                    DmChannel match2;
                    IntChannelStore nxtStore = (IntChannelStore)entry.getValue();
                    DmChannel match = nxtStore.getSenderChannel(channelname);
                    if (match != null) {
                        matches.add(match);
                    }
                    if ((match2 = nxtStore.getServerChannel(channelname)) == null) continue;
                    matches.add(match2);
                }
                switch (matches.size()) {
                    case 0: {
                        this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ChannelPairs.noMatchForRequester", channelname), ChannelPairs.getQueueManagerName(t, hostqmgr), this.getTestSubCategory()));
                        break;
                    }
                    case 1: {
                        DmChannel match = (DmChannel)matches.get(0);
                        int type = ChannelPairs.getAttr(t, (DmObject)match, 1511);
                        String msgString = "";
                        if (type == 1) {
                            msgString = Messages.getString(t, "ChannelPairs.closeMatchSenderForReq");
                        } else if (type == 2) {
                            msgString = Messages.getString(t, "ChannelPairs.closeMatchServerForReq");
                        }
                        if (!match.getTitle().equals(channelname)) {
                            msgString = MessageFormat.format(msgString, channelname, match.getTitle());
                            this.testresults.add(new WMQTestResult(1, msgString, ChannelPairs.getQueueManagerName(t, hostqmgr), this.getTestSubCategory()));
                            break;
                        }
                        if (type == 1) {
                            this.compareReqSdrAttrs(t, nextReqChan, match);
                            break;
                        }
                        if (type != 2) break;
                        this.compareReqSvrAttrs(t, nextReqChan, match);
                        break;
                    }
                    default: {
                        DmChannel match = this.findMatchingChannel(t, nextReqChan, matches);
                        if (match == null) {
                            this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ChannelPairs.mutipleSendOrServForReq", channelname), ChannelPairs.getQueueManagerName(t, hostqmgr), this.getTestSubCategory()));
                            break;
                        }
                        int type = ChannelPairs.getAttr(t, (DmObject)match, 1511);
                        if (type == 1) {
                            this.compareReqSdrAttrs(t, nextReqChan, match);
                            break;
                        }
                        if (type != 2) break;
                        this.compareReqSvrAttrs(t, nextReqChan, match);
                    }
                }
            }
            ++i;
        }
    }

    private void compareSdrRcvrAttrs(Trace t, DmChannel senderchan, DmChannel receiverchan) {
        this.compareGenericAttrs(t, senderchan, receiverchan);
    }

    private void compareSvrRcvrAttrs(Trace t, DmChannel serverchan, DmChannel receiverchan) {
        this.compareGenericAttrs(t, serverchan, receiverchan);
    }

    private void compareReqSdrAttrs(Trace t, DmChannel requesterchan, DmChannel senderchan) {
        this.compareGenericAttrs(t, requesterchan, senderchan);
    }

    private void compareReqSvrAttrs(Trace t, DmChannel requesterchan, DmChannel serverchan) {
        this.compareGenericAttrs(t, requesterchan, serverchan);
    }

    private void compareGenericAttrs(Trace t, DmChannel channel1, DmChannel channel2) {
        int maxmsglen2;
        int maxmsglen1;
        String sslciph1 = channel1.getAttributeValue(t, 3544, 0);
        String sslciph2 = channel2.getAttributeValue(t, 3544, 0);
        if (sslciph1 == null) {
            sslciph1 = "";
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPairs.sslciphAttrErr", channel1.getTitle()), ChannelPairs.getQueueManagerName(t, channel1.getQueueManager()), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "ChannelPairs.compareGenericAttrs", 900, "Error encountered while getting SSLCIPH attribute from channel " + channel1.getTitle() + " on " + channel1.getQueueManager().getTitle());
            }
        }
        if (sslciph2 == null) {
            sslciph2 = "";
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPairs.sslciphAttrErr", channel2.getTitle()), ChannelPairs.getQueueManagerName(t, channel2.getQueueManager()), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "ChannelPairs.compareGenericAttrs", 900, "Error encountered while getting SSLCIPH attribute from channel " + channel2.getTitle() + " on " + channel2.getQueueManager().getTitle());
            }
        }
        int type = ChannelPairs.getAttr(t, (DmObject)channel1, 1511);
        int type2 = ChannelPairs.getAttr(t, (DmObject)channel2, 1511);
        String msgText = "";
        if (type == 1) {
            if (type2 == 3) {
                msgText = Messages.getString(t, "ChannelPairs.sslMismatchSenderReceiver");
            }
        } else if (type == 2) {
            if (type2 == 3) {
                msgText = Messages.getString(t, "ChannelPairs.sslMismatchServerReceiver");
            }
        } else if (type == 4) {
            if (type2 == 1) {
                msgText = Messages.getString(t, "ChannelPairs.sslMismatchRequesterSender");
            } else if (type2 == 2) {
                msgText = Messages.getString(t, "ChannelPairs.sslMismatchRequesterServer");
            }
        }
        if (!sslciph1.equals(sslciph2)) {
            msgText = MessageFormat.format(msgText, channel1.getTitle(), sslciph1, sslciph2);
            this.testresults.add(new WMQTestResult(2, msgText, ChannelPairs.getQueueManagerName(t, channel1.getQueueManager()), this.getTestSubCategory()));
        }
        if ((maxmsglen1 = ChannelPairs.getAttr(t, (DmObject)channel1, 1510)) != (maxmsglen2 = ChannelPairs.getAttr(t, (DmObject)channel2, 1510))) {
            msgText = Messages.getString(t, "ChannelPairs.maxMsgLenDifferent");
            msgText = MessageFormat.format(msgText, channel1.getTitle());
            this.testresults.add(new WMQTestResult(1, msgText, ChannelPairs.getQueueManagerName(t, channel1.getQueueManager()), this.getTestSubCategory()));
        }
    }

    private DmChannel findMatchingChannel(Trace t, DmChannel orig, ArrayList potentials) {
        ArrayList potentials_copy;
        block17: {
            potentials_copy = (ArrayList)potentials.clone();
            int i = 0;
            while (i < potentials.size()) {
                DmChannel nxtChan = (DmChannel)potentials.get(i);
                if (!orig.getTitle().equals(nxtChan.getTitle())) {
                    potentials_copy.remove(nxtChan);
                }
                ++i;
            }
            if (potentials_copy.size() > 1) {
                String destconnname = orig.getAttributeValue(t, 3506, 0);
                if (destconnname == null) {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPairs.getConnNameErr", orig.getTitle()), ChannelPairs.getQueueManagerName(t, orig.getQueueManager()), this.getTestSubCategory()));
                    if (Trace.isTracing) {
                        t.data(66, "ChannelPairs.findMatchingChannel", 900, "Error encountered while getting connection name from " + orig.getTitle() + " on " + orig.getQueueManager().getTitle());
                    }
                } else {
                    try {
                        String host = this.getHostName(t, destconnname);
                        InetAddress target = InetAddress.getByName(host);
                        int i2 = 0;
                        while (i2 < potentials.size()) {
                            DmChannel nxtChan = (DmChannel)potentials.get(i2);
                            DmQueueManager nxtChanHost = nxtChan.getQueueManager();
                            if (!nxtChanHost.isLocal()) {
                                InetAddress potentialaddr = InetAddress.getLocalHost();
                                if (!target.equals(potentialaddr)) {
                                    potentials_copy.remove(nxtChan);
                                }
                            } else {
                                String machineaddr;
                                InetAddress potentialaddr;
                                DmQueueManagerHandle hnd = nxtChanHost.getParent().getQueueManager().getConnectionHandle();
                                QueueManagerHandle connhandle = hnd.getQueueManagerHandle(t);
                                String conname = connhandle.getConnectionName();
                                if (!conname.equals("[not_defined]") && conname.length() > 0 && !target.equals(potentialaddr = InetAddress.getByName(machineaddr = this.getHostName(t, conname)))) {
                                    potentials_copy.remove(nxtChan);
                                }
                            }
                            ++i2;
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ChannelPairs.hostResolvErr", destconnname), ChannelPairs.getQueueManagerName(t, orig.getQueueManager()), this.getTestSubCategory()));
                        if (!Trace.isTracing) break block17;
                        t.data(66, "ChannelPairs.findMatchingChannel", 900, "Error encountered while resolving the hostname (" + destconnname + ")");
                    }
                }
            }
        }
        switch (potentials_copy.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (DmChannel)potentials_copy.get(0);
            }
        }
        return null;
    }

    private String getHostName(Trace t, String conname) {
        String hostname = conname;
        int index = conname.lastIndexOf("(");
        if (index != -1) {
            hostname = conname.substring(0, index);
        }
        return hostname;
    }

    private static class IntChannelStore {
        private String qmname = "";
        private String qmuuid = "";
        private ArrayList sdrchans = new ArrayList();
        private ArrayList rcvchans = new ArrayList();
        private ArrayList reqchans = new ArrayList();
        private ArrayList svrchans = new ArrayList();

        private IntChannelStore() {
        }

        public String getQmName() {
            return this.qmname;
        }

        public void setQmName(String name) {
            this.qmname = name;
        }

        public String getUUID() {
            return this.qmuuid;
        }

        public void setUUID(String uuid) {
            this.qmuuid = uuid;
        }

        public ArrayList getRcvChans() {
            return this.rcvchans;
        }

        public void setRcvChans(ArrayList chans) {
            this.rcvchans = chans;
        }

        public ArrayList getReqChans() {
            return this.reqchans;
        }

        public void setReqChans(ArrayList chans) {
            this.reqchans = chans;
        }

        public ArrayList getSdrChans() {
            return this.sdrchans;
        }

        public void setSdrChans(ArrayList chans) {
            this.sdrchans = chans;
        }

        public ArrayList getSvrChans() {
            return this.svrchans;
        }

        public void setSvrChans(ArrayList chans) {
            this.svrchans = chans;
        }

        public DmChannel getSenderChannel(String name) {
            return this.getSingleChannel(name, this.getSdrChans());
        }

        public DmChannel getReceiverChannel(String name) {
            return this.getSingleChannel(name, this.getRcvChans());
        }

        public DmChannel getRequesterChannel(String name) {
            return this.getSingleChannel(name, this.getReqChans());
        }

        public DmChannel getServerChannel(String name) {
            return this.getSingleChannel(name, this.getSvrChans());
        }

        private DmChannel getSingleChannel(String name, ArrayList coll) {
            DmChannel nxtChannel;
            int i = 0;
            while (i < coll.size()) {
                nxtChannel = (DmChannel)coll.get(i);
                if (nxtChannel.getTitle().equals(name)) {
                    return nxtChannel;
                }
                ++i;
            }
            int j = 0;
            while (j < coll.size()) {
                nxtChannel = (DmChannel)coll.get(j);
                if (nxtChannel.getTitle().equalsIgnoreCase(name)) {
                    return nxtChannel;
                }
                ++j;
            }
            return null;
        }
    }
}

