/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChannelIntervalValues
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/ChannelIntervalValues.java";
    private boolean includeSystemObjects = false;
    private ArrayList testresults = new ArrayList();
    private static final int NUMBER_OF_STAGES_PER_QMGR = 2;
    private int NUMBER_OF_TEST_STAGES = 0;
    DmObjectFilter chan_query = new DmObjectFilter(Trace.getDefault(), 25);

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 2;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = qmgrs.get(i);
            ArrayList<DmObject> channels = this.syncDataModelQuery(t, nextQm, this.chan_query);
            if (channels == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < channels.size()) {
                DmChannel channel = (DmChannel)channels.get(j);
                this.analyseChannel(t, channel, nextQm);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseChannel(Trace t, DmChannel chan, DmQueueManager qmgr) {
        String channelName = chan.getTitle();
        if (!this.includeSystemObjects && channelName.startsWith("SYSTEM.")) {
            return;
        }
        boolean discintavail = false;
        int chltype = ChannelIntervalValues.getAttr(t, (DmObject)chan, 1511);
        switch (chltype) {
            case 1: 
            case 2: 
            case 8: 
            case 9: {
                discintavail = true;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                discintavail = false;
            }
        }
        int hbint = ChannelIntervalValues.getAttr(t, (DmObject)chan, 1563);
        int discint = -1;
        if (discintavail) {
            discint = ChannelIntervalValues.getAttr(t, (DmObject)chan, 1503);
        }
        int kaint = chltype != 11 ? ChannelIntervalValues.getAttr(t, (DmObject)chan, 1566) : ChannelIntervalValues.getAttr(t, (DmObject)chan, 1644);
        if (hbint > discint && hbint != -1 && discint != -1 && discint != 0) {
            this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ChannelIntervalValues.heartMoreThanDisc", new String[]{channelName, "" + hbint, "" + discint}), ChannelIntervalValues.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        }
        if (qmgr.isZos()) {
            if (kaint > hbint && kaint != -1 && hbint != -1) {
                this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ChannelIntervalValues.keepMoreThanHeart", new String[]{channelName, "" + kaint, "" + hbint}), ChannelIntervalValues.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            }
        } else if (chltype != 9 && chltype != 8 && kaint != -1) {
            this.testresults.add(new WMQTestResult(0, Messages.getString(t, "ChannelIntervalValues.kaintNonZos", new String[]{channelName, "" + kaint}), ChannelIntervalValues.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        }
    }
}

