/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueue;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmTopic;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.Messages;
import com.ibm.mq.explorer.tests.coretests.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class AliasQueueDefs
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests/src/com/ibm/mq/explorer/tests/coretests/internal/tests/AliasQueueDefs.java";
    private ArrayList<WMQTestResult> testresults;
    private DmObjectFilter alias_q_query = null;
    private DmObjectFilter all_q_query = null;
    private DmObjectFilter all_topics_query = null;
    private DmObjectFilter clus_q_query = null;
    private static final int NUMBER_OF_STAGES_PER_QMGR = 5;
    private int NUMBER_OF_TEST_STAGES = 0;
    private boolean includeSystemObjects = false;

    public MQExtObject[] getApplicableObjects(MQExtObject[] contextObjects) {
        Trace t = Trace.getDefault();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        Map<DmQueueManager, MQExtObject> qmgrMap = this.getFilteredQueueManagersMap(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        ArrayList<DmQueueManager> qmgrsToRemove = new ArrayList<DmQueueManager>();
        for (DmQueueManager qmgr : qmgrMap.keySet()) {
            if (qmgr.getCommandLevel() >= 700) continue;
            qmgrsToRemove.add(qmgr);
        }
        for (DmQueueManager qmgr : qmgrsToRemove) {
            qmgrMap.remove(qmgr);
        }
        MQExtObject[] validObjs = qmgrMap.values().toArray(new MQExtObject[0]);
        return validObjs;
    }

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList<DmQueueManager> qmgrs = this.getFilteredQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        int numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 5;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            ArrayList<DmObject> clusterQueues;
            ArrayList<DmObject> allTopics;
            ArrayList<DmObject> allQueues;
            ArrayList<DmObject> aliasQueues;
            DmQueueManager nextQm = qmgrs.get(i);
            if (this.alias_q_query == null) {
                this.alias_q_query = new DmObjectFilter(t, 13, 3);
            }
            if ((aliasQueues = this.syncDataModelQuery(t, nextQm, this.alias_q_query)) == null) break;
            this.getGUIMonitor().worked(1);
            if (this.all_q_query == null) {
                this.all_q_query = new DmObjectFilter(t, 13);
            }
            if ((allQueues = this.syncDataModelQuery(t, nextQm, this.all_q_query)) == null) break;
            this.getGUIMonitor().worked(1);
            if (this.all_topics_query == null) {
                this.all_topics_query = new DmObjectFilter(t, 174);
            }
            if ((allTopics = this.syncDataModelQuery(t, nextQm, this.all_topics_query)) == null) break;
            this.getGUIMonitor().worked(1);
            if (this.clus_q_query == null) {
                this.clus_q_query = new DmObjectFilter(t, 1004);
            }
            if ((clusterQueues = this.syncDataModelQuery(t, nextQm, this.clus_q_query)) == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < aliasQueues.size()) {
                DmQueue aliasQueue = (DmQueue)aliasQueues.get(j);
                this.analyseQueue(t, aliasQueue, allQueues, allTopics, clusterQueues, nextQm);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseQueue(Trace t, DmQueue aliasQueue, ArrayList allqueues, ArrayList alltopics, ArrayList clusterqueues, DmQueueManager qmgr) {
        String aliasQueueName = aliasQueue.getTitle();
        if (!this.includeSystemObjects && aliasQueueName.startsWith("SYSTEM.")) {
            return;
        }
        String targq = aliasQueue.getAttributeValue(t, 2002, 0);
        int targtype = AliasQueueDefs.getAttr(t, (DmObject)aliasQueue, 193);
        if (targq == null || targtype == -1) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "AliasQueueDefs.attrValError", aliasQueueName), AliasQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        } else if (targq.length() == 0) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "AliasQueueDefs.noBaseQ", aliasQueueName), AliasQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        } else if (targq.equals(aliasQueueName)) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "AliasQueueDefs.selfAlias", aliasQueueName), AliasQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        } else if (targtype == 8) {
            DmTopic targetTopic = this.getTopic(t, targq, alltopics);
            if (targetTopic == null) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "AliasQueueDefs.notExistTopic", new String[]{aliasQueueName, targq}), AliasQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            }
        } else {
            DmClusterQueue targetClusQobj = this.getClusterQueue(t, targq, clusterqueues);
            if (targetClusQobj == null) {
                DmQueue targetQobj = this.getQueue(t, targq, allqueues);
                if (targetQobj == null) {
                    this.testresults.add(new WMQTestResult(2, Messages.getString(t, "AliasQueueDefs.notExist", new String[]{aliasQueueName, targq}), AliasQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                } else {
                    int targqtype = AliasQueueDefs.getAttr(t, (DmObject)targetQobj, 20);
                    switch (targqtype) {
                        case 3: {
                            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "AliasQueueDefs.aliasOfAlias", new String[]{aliasQueueName, targq}), AliasQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                            break;
                        }
                        case 2: {
                            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "AliasQueueDefs.aliasToModel", new String[]{aliasQueueName, targq}), AliasQueueDefs.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                        }
                    }
                }
            }
        }
    }
}

