/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.wizards.ops;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import com.ibm.mq.explorer.clusterplugin.internal.actions.NamelistActions;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.ops.ClusterWizardOperation;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class QmgrRepositoryAttrOperation
extends ClusterWizardOperation {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/wizards/ops/QmgrRepositoryAttrOperation.java";
    private String oldREPOSattr;
    private String oldREPOSNLattr;
    private String repositoryNameList = null;

    public QmgrRepositoryAttrOperation(DmQueueManager queueManager, String clusname, String reposNameList) {
        super(queueManager, clusname);
        this.repositoryNameList = reposNameList;
    }

    @Override
    public boolean redo(Trace t, IProgressMonitor monitor) {
        monitor.subTask(ClusterPlugin.getResourceString("UI.QMGRS.SetClusterAttr.Wizard"));
        this.oldREPOSattr = this.fQmgr.getAttributeValue(t, 2035, 0);
        this.oldREPOSNLattr = this.fQmgr.getAttributeValue(t, 2036, 0);
        if (this.oldREPOSattr.equals("") && this.oldREPOSNLattr.equals("")) {
            if (Trace.isTracing) {
                t.data(66, "QmgrRepositoryAttrOperation.redo", 800, "Repository attributes indicate that " + this.fQmgr.getTitle() + " is not currently a full repository for any cluster");
            }
            Object jobid = this.fQmgr.beginUpdate(t);
            this.fQmgr.setAttributeValue(t, jobid, 2035, 0, (Object)this.fClusname);
            int returncode = this.fQmgr.actionChange(t, null, jobid, false);
            if (returncode != 0) {
                if (Trace.isTracing) {
                    t.data(66, "QmgrRepositoryAttrOperation.redo", 900, "Failed to set repository attribute for " + this.fQmgr.getTitle() + " to " + this.fClusname);
                }
                return false;
            }
        } else if (this.oldREPOSattr.equals("")) {
            boolean success;
            if (Trace.isTracing) {
                t.data(66, "QmgrRepositoryAttrOperation.redo", 800, "Repository attributes indicate that " + this.fQmgr.getTitle() + " is already a full repository for multiple clusters");
            }
            if (!(success = NamelistActions.addToNamelist(t, this.oldREPOSNLattr, this.fClusname, this.fQmgr))) {
                return false;
            }
        } else if (!this.oldREPOSattr.equals(this.fClusname)) {
            ArrayList<String> clusNames = new ArrayList<String>();
            clusNames.add(this.oldREPOSattr);
            clusNames.add(this.fClusname);
            boolean success = NamelistActions.createNamelist(t, this.repositoryNameList, this.fQmgr, clusNames);
            if (!success) {
                return false;
            }
            Object jobid = this.fQmgr.beginUpdate(t);
            this.fQmgr.setAttributeValue(t, jobid, 2035, 0, (Object)" ");
            this.fQmgr.actionChange(t, null, jobid, false);
            this.fQmgr.endUpdate(t, jobid);
            jobid = this.fQmgr.beginUpdate(t);
            this.fQmgr.setAttributeValue(t, jobid, 2036, 0, (Object)this.repositoryNameList);
            this.fQmgr.actionChange(t, null, jobid, false);
            this.fQmgr.endUpdate(t, jobid);
        }
        if (this.fFailed) {
            this.traceFailure(t, "QmgrRepositoryAttrOperation.redo");
            monitor.subTask(ClusterPlugin.getResourceString("UI.QMGRS.SetClusterAttrFail.Wizard"));
            monitor.done();
        }
        return this.fFailed;
    }

    @Override
    public boolean undo(Trace t) {
        if (this.oldREPOSattr != null) {
            if (this.oldREPOSattr.equals("")) {
                this.oldREPOSattr = " ";
            }
            Object jobid = this.fQmgr.beginUpdate(t);
            this.fQmgr.setAttributeValue(t, jobid, 2035, 0, (Object)this.oldREPOSattr);
            this.fQmgr.actionChange(t, null, jobid, false);
            this.fQmgr.endUpdate(t, jobid);
        }
        if (this.oldREPOSNLattr != null) {
            NamelistActions.removeFromNamelist(t, this.oldREPOSNLattr.trim(), this.fClusname, this.fQmgr);
        }
        return false;
    }

    @Override
    public void traceFailure(Trace t, String fid) {
    }

    @Override
    public String buildErrorMessageString(Trace t) {
        String userMsg = CommonServices.getSystemMessage((Trace)Trace.getDefault(), (String)"AMQ4512");
        String formMsg = Message.format((String)userMsg, (String)String.valueOf(this.fReturncode), (String)String.valueOf(this.fReturncode));
        return formMsg;
    }
}

