/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.wizards.ops;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.ops.ClusterWizardOperation;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClusterWizardOperations {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/wizards/ops/ClusterWizardOperations.java";
    protected boolean fFailed = false;
    private int fFailedOperationIdx = 0;
    private int fFailureReasonCode = 0;
    protected String fFailureMessageString = null;
    protected ArrayList<ClusterWizardOperation> operations = new ArrayList();

    public boolean performAll(Trace t) {
        return this.performAll(t, null);
    }

    public boolean performAll(Trace t, IProgressMonitor monitor) {
        this.fFailed = false;
        this.fFailedOperationIdx = this.operations.size() - 1;
        int fOperationIdx = 0;
        while (fOperationIdx < this.operations.size()) {
            ClusterWizardOperation op = this.operations.get(fOperationIdx);
            this.fFailed = op.redo(t, monitor);
            if (this.fFailed) {
                this.fFailedOperationIdx = fOperationIdx;
                this.fFailureReasonCode = op.getReasonCode();
                this.fFailureMessageString = op.buildErrorMessageString(t);
                break;
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            ++fOperationIdx;
        }
        return this.fFailed;
    }

    public void rollbackAll(Trace t) {
        int idx = this.fFailedOperationIdx - 1;
        while (idx >= 0) {
            ClusterWizardOperation op = this.operations.get(idx);
            op.undo(t);
            --idx;
        }
    }

    public int getReasonCode() {
        return this.fFailureReasonCode;
    }

    public String getfFailureMessageString() {
        return this.fFailureMessageString;
    }

    public boolean hasFailed() {
        return this.fFailed;
    }
}

