/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.wizards.ops;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.ops.ClusterWizardOperation;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClusterSenderCreateOperation
extends ClusterWizardOperation {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/wizards/ops/ClusterSenderCreateOperation.java";
    private String fChanName = "";
    private String fConnName = "";
    private DmChannel fChanHandle = null;

    public ClusterSenderCreateOperation(DmQueueManager queueManager, String clusname, String chan, String conn) {
        super(queueManager, clusname);
        this.fConnName = conn;
        this.fChanName = chan;
    }

    @Override
    public boolean redo(Trace t, IProgressMonitor monitor) {
        String tasklabel = Message.format((String)ClusterPlugin.getResourceString("UI.QMGRS.CreateClusSnd.Wizard"), (String)this.fChanName);
        monitor.subTask(tasklabel);
        this.fChanHandle = (DmChannel)DmObject.clone((Trace)t, (DmQueueManager)this.fQmgr, (String)this.fChanName, (int)25, (int)9);
        if (this.fChanHandle != null) {
            Object jobid = this.fChanHandle.beginUpdate(t);
            this.fChanHandle.setAttributeValue(t, jobid, 1501, 0, (Object)2);
            this.fChanHandle.setAttributeValue(t, jobid, 2029, 0, (Object)this.fClusname);
            this.fChanHandle.setAttributeValue(t, jobid, 3506, 0, (Object)this.fConnName);
            this.fReturncode = this.fChanHandle.actionCreate(t, null, jobid);
            if (this.fReturncode != 0) {
                this.fFailed = true;
                this.traceFailure(t, "ClusterSenderCreateOperation.redo");
            }
        } else {
            this.fFailed = true;
        }
        if (this.fFailed) {
            this.traceFailure(t, "ClusterSenderCreateOperation.redo");
            monitor.subTask(ClusterPlugin.getResourceString("UI.QMGRS.CreateClusSndFail.Wizard"));
            monitor.done();
        }
        return this.fFailed;
    }

    @Override
    public boolean undo(Trace t) {
        if (this.fChanHandle != null) {
            this.fChanHandle.actionStop(t, null, 0, 0, null, null);
            this.fChanHandle.actionDelete(t, null);
        }
        return false;
    }

    @Override
    public void traceFailure(Trace t, String fid) {
        if (Trace.isTracing) {
            t.data(66, fid, 900, "Failed to create cluster sender channel " + this.fChanName + " on " + this.fQmgr.getTitle());
        }
    }

    @Override
    public String buildErrorMessageString(Trace t) {
        String userMsg = CommonServices.getSystemMessage((Trace)Trace.getDefault(), (String)"AMQ4512");
        String formMsg = Message.format((String)userMsg, (String)String.valueOf(this.fReturncode), (String)String.valueOf(this.fReturncode));
        return formMsg;
    }
}

