/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.wizards.ops;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.ops.ClusterWizardOperation;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClusterChannelStopOperation
extends ClusterWizardOperation {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/wizards/ops/ClusterChannelStopOperation.java";
    private DmChannel fChanHandle = null;
    private String fChanName = null;
    private boolean fForce = false;

    public ClusterChannelStopOperation(DmQueueManager queueManager, String clusname, DmChannel channel, boolean force) {
        super(queueManager, clusname);
        this.fChanHandle = channel;
        this.fChanName = this.fChanHandle.getTitle();
        this.fForce = force;
        this.fAbsorbedReturnCodes = new int[]{4064};
    }

    @Override
    public boolean redo(Trace t, IProgressMonitor monitor) {
        this.fReturncode = this.fChanHandle.actionStop(t, null, this.fForce ? 0 : 1, 6, null, null);
        if (this.fReturncode != 0 && !this.isReturnCodeAbsorbed(t)) {
            this.fFailed = true;
            this.traceFailure(t, "ClusterChannelStopOperation.redo");
        }
        return this.fFailed;
    }

    @Override
    public boolean undo(Trace t) {
        return false;
    }

    @Override
    public void traceFailure(Trace t, String fid) {
        if (Trace.isTracing) {
            t.data(66, fid, 900, "Failed to stop channel " + this.fChanName + " on " + this.fQmgr.getTitle());
        }
    }

    @Override
    public String buildErrorMessageString(Trace t) {
        String userMsg = CommonServices.getSystemMessage((Trace)Trace.getDefault(), (String)"AMQ4512");
        String formMsg = Message.format((String)userMsg, (String)String.valueOf(this.fReturncode), (String)String.valueOf(this.fReturncode));
        return formMsg;
    }
}

