/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.wizards;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import com.ibm.mq.explorer.clusterplugin.internal.ImageCache;
import com.ibm.mq.explorer.clusterplugin.internal.actions.GetChannelNames;
import com.ibm.mq.explorer.clusterplugin.internal.factory.ClusterFactory;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.CreateClusterWiz;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.CreateClusterWizPage;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateClusterWizPage5
extends CreateClusterWizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/wizards/CreateClusterWizPage5.java";
    protected Text textChanName = null;
    protected ArrayList knownchannelNames = null;
    protected String selectedchannelname = "";
    protected String selectedcconname = "";
    protected boolean refresh = true;
    protected ExtCombo comboConnName = null;
    protected static final IStatus ERRORSTATE_CHANNAME = new Status(4, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.QueueManagerNotUsed.Status"), 0, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.ChannelExists.Status"), null);
    protected static final IStatus NULLSTATE = new Status(4, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.QueueManagerNotUsed.Status"), 0, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.ChannelNameRequired.Status"), null);
    protected static final IStatus NULLSTATE_CON = new Status(4, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.QueueManagerNotUsed.Status"), 0, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.ChannelConNameRequired.Status"), null);
    protected static final IStatus INVALIDCHARS = new Status(4, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.QueueManagerNotUsed.Status"), 0, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.ChannelNameInvalid.Status"), null);
    private boolean valid = true;

    public CreateClusterWizPage5(String pageName, String title, String imgName) {
        super(pageName, title, imgName);
    }

    @Override
    protected void createPageContent(Composite parent) {
        Trace t = Trace.getDefault();
        this.wizard = (CreateClusterWiz)this.getWizard();
        parent.setLayout((Layout)new GridLayout(2, false));
        Composite compositeL = new Composite(parent, 0);
        compositeL.setLayout((Layout)new GridLayout(1, false));
        GridData gridDat = new GridData();
        compositeL.setLayoutData((Object)gridDat);
        Composite compositeR = new Composite(parent, 0);
        gridDat = new GridData(2);
        compositeR.setLayout((Layout)new GridLayout(1, false));
        compositeR.setLayoutData((Object)gridDat);
        Label pic = new Label(compositeL, 0);
        pic.setLayoutData((Object)new GridData(1040));
        pic.setImage(ImageCache.getImage(t, this.imageName));
        Text exp = new Text(compositeR, 64);
        exp.setText(ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.ClusterReceiver.Info"));
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)exp, (boolean)true);
        gridDat = new GridData();
        gridDat.horizontalSpan = 2;
        exp.setLayoutData((Object)gridDat);
        Label labelChanName = new Label(compositeR, 0);
        labelChanName.setText(ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.ClusterReceiverName.Label"));
        gridDat = new GridData(2);
        labelChanName.setLayoutData((Object)gridDat);
        this.textChanName = new Text(compositeR, 2048);
        this.textChanName.setText("");
        this.textChanName.setTextLimit(20);
        this.textChanName.setFocus();
        gridDat = new GridData(770);
        gridDat.widthHint = 200;
        this.textChanName.setLayoutData((Object)gridDat);
        Label space = new Label(compositeR, 64);
        gridDat = new GridData();
        gridDat.horizontalSpan = 2;
        space.setLayoutData((Object)gridDat);
        Label conname = new Label(compositeR, 0);
        conname.setText(ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.RECEIVER.CONNAME"));
        this.comboConnName = new ExtCombo(compositeR, 4);
        gridDat = new GridData(770);
        this.comboConnName.setLayoutData((Object)gridDat);
        this.comboConnName.setTextLimit(264);
        this.textChanName.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Trace t2 = Trace.getDefault();
                CreateClusterWizPage5.this.valid = StringValidation.verifyMQObjectName((Trace)t2, (VerifyEvent)e);
            }
        });
        this.textChanName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CreateClusterWizPage5.this.selectedchannelname = CreateClusterWizPage5.this.textChanName.getText();
                CreateClusterWizPage5.this.setChannelName(CreateClusterWizPage5.this.selectedchannelname);
            }
        });
        this.comboConnName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int selIndex = CreateClusterWizPage5.this.comboConnName.getSelectionIndex();
                if (selIndex != -1) {
                    CreateClusterWizPage5.this.setConnName((String)CreateClusterWizPage5.this.comboConnName.getObject(selIndex));
                }
            }
        });
        this.comboConnName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CreateClusterWizPage5.this.selectedcconname = CreateClusterWizPage5.this.comboConnName.getText();
                CreateClusterWizPage5.this.setConnName(CreateClusterWizPage5.this.selectedcconname);
            }
        });
    }

    protected void setConnName(String conname) {
        this.wizard.setFirstReposConnName(conname);
        this.selectedcconname = conname;
        this.checkState();
    }

    protected void checkState() {
        boolean isChannelError = false;
        boolean isChannelEmpty = false;
        boolean isConnameEmpty = false;
        if (this.selectedchannelname.compareTo("") == 0) {
            isChannelEmpty = true;
        }
        if (this.knownchannelNames.contains(this.selectedchannelname)) {
            isChannelError = true;
        }
        if (this.wizard.getSecondReposChannelName() != null && this.wizard.getSecondReposChannelName().compareTo(this.selectedchannelname) == 0) {
            isChannelError = true;
        }
        if (this.selectedcconname.compareTo("") == 0) {
            isConnameEmpty = true;
        }
        if (!this.valid) {
            this.applyToStatusLine(INVALIDCHARS);
            this.setPageComplete(false);
        } else if (isChannelEmpty) {
            this.applyToStatusLine(NULLSTATE);
            this.setPageComplete(false);
        } else if (isChannelError) {
            this.applyToStatusLine(ERRORSTATE_CHANNAME);
            this.setPageComplete(false);
        } else if (isConnameEmpty) {
            this.applyToStatusLine(NULLSTATE_CON);
            this.setPageComplete(false);
        } else {
            this.applyToStatusLine(OKSTATE);
            this.setPageComplete(true);
        }
    }

    protected void setChannelName(String name) {
        this.wizard.setFirstReposChannelName(name);
        this.checkState();
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        boolean pageIdIs5 = this.wizard.getContainer().getCurrentPage().getName().equals("page5");
        this.refresh = pageIdIs5 ? this.wizard.isFirstQueueManagerChanged() : this.wizard.isSecondQueueManagerChanged();
        if (this.refresh && visible) {
            GetChannelNames action;
            block12: {
                action = new GetChannelNames();
                if (pageIdIs5) {
                    action.init(this.wizard.getFirstRepos().getDmQueueManagerObject());
                } else {
                    action.init(this.wizard.getSecondRepos().getDmQueueManagerObject());
                }
                try {
                    boolean forkable = true;
                    boolean cancelable = false;
                    this.getWizard().getContainer().run(forkable, cancelable, (IRunnableWithProgress)action);
                }
                catch (InvocationTargetException e) {
                    if (Trace.isTracing) {
                        t.data(66, "CreateClusterWizPage5.setVisible", 900, "Exception occurred when trying to obtain a list of potential channels: " + e.getMessage());
                    }
                }
                catch (InterruptedException e) {
                    if (!Trace.isTracing) break block12;
                    t.data(66, "CreateClusterWizPage5.setVisible", 900, "Exception occurred when trying to obtain a list of potential channels: " + e.getMessage());
                }
            }
            this.knownchannelNames = action.getChannelNames();
            this.selectedchannelname = action.getDefaultNewName();
            this.textChanName.setText(this.selectedchannelname);
            UiQueueManager qmgr = null;
            qmgr = pageIdIs5 ? this.wizard.getFirstRepos() : this.wizard.getSecondRepos();
            ClusterFactory factory = ClusterFactory.getDefault();
            ArrayList listenersArray = factory.getListeners(t, qmgr, (IWizard)this.wizard);
            ArrayList<String> connectionsList = null;
            connectionsList = qmgr.isLocal() ? factory.getConnectionListForLocalQM(t, listenersArray) : factory.getConnectionListForRemoteQM(t, listenersArray, qmgr);
            this.comboConnName.removeAll();
            int idx = 0;
            while (idx < connectionsList.size()) {
                this.comboConnName.add((Object)connectionsList.get(idx));
                ++idx;
            }
            this.comboConnName.sort();
            if (pageIdIs5) {
                this.wizard.setFirstQueueManagerChanged(false);
            } else {
                this.wizard.setSecondQueueManagerChanged(false);
            }
        }
        super.setVisible(visible);
        if (visible) {
            this.comboConnName.setFocus();
            if (this.comboConnName.getItemCount() > 0 && this.comboConnName.getSelectionIndex() == -1) {
                this.comboConnName.select(0);
            }
        }
    }

    @Override
    protected void checkIfEnableButtons() {
        boolean isEnableFinish = false;
        this.wizard.setEnableFinish(isEnableFinish);
        this.wizard.updateButtons();
    }
}

