/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.wizards;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import com.ibm.mq.explorer.clusterplugin.internal.actions.GetChannelNames;
import com.ibm.mq.explorer.clusterplugin.internal.factory.ClusterFactory;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWiz;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWizPage;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWizPage4;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtCCombo;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AddToClusterWizPage7
extends AddToClusterWizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/wizards/AddToClusterWizPage7.java";
    private static String titleText = null;
    private Image errorIcon = null;
    private IStatus lastStatus = null;
    private boolean hasErrInvalidChars = false;
    private boolean hasErrNullState = false;
    private boolean hasErrErrorState = false;
    private boolean hasErrConnNullState = false;
    private ArrayList<DmQueueManager> full_repositories = null;
    private Hashtable<DmQueueManager, ArrayList<String>> qmgrsHash = null;
    private Table qmgrsList;
    private TableItem[] items = new TableItem[0];
    private TableEditor[] nameEditors = new TableEditor[0];
    private TableEditor[] connEditors = new TableEditor[0];
    private Text[] nameTexts = new Text[0];
    private ExtCCombo[] connCombos = new ExtCCombo[0];
    private Composite composite;
    static final IStatus NORECEIVERS = new Status(4, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.QueueManagerNotUsed.Status"), 0, ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.NO.RECEIVER.CHANNELS"), null);

    public AddToClusterWizPage7(String pageName) {
        super(pageName);
        this.full_repositories = new ArrayList();
        this.qmgrsHash = new Hashtable();
        this.setHeadingsInfo();
    }

    public AddToClusterWizPage7(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setHeadingsInfo();
        this.full_repositories = new ArrayList();
        this.qmgrsHash = new Hashtable();
    }

    private void setHeadingsInfo() {
        if (titleText == null) {
            titleText = ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.EnableComms4");
        }
        this.setTitle(titleText);
        if (this.errorIcon == null) {
            this.errorIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
        }
    }

    @Override
    protected void createPageContent(Composite parent) {
        Trace t = Trace.getDefault();
        this.wizard = (AddToClusterWiz)this.getWizard();
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        GridData gridDat = new GridData(1808);
        gridDat.horizontalSpan = 5;
        this.composite.setLayoutData((Object)gridDat);
        this.composite.setLayout((Layout)layout);
        this.setControl((Control)this.composite);
        Text exp = new Text(this.composite, 64);
        exp.setText(ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.SELECT.SENDER.CHANNEL.DESCRIPTION"));
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)exp, (boolean)true);
        gridDat = new GridData(2);
        exp.setLayoutData((Object)gridDat);
        this.qmgrsList = new Table(this.composite, 67588);
        this.qmgrsList.setLinesVisible(true);
        this.qmgrsList.setHeaderVisible(true);
        TableColumn qmgrs = new TableColumn(this.qmgrsList, 0);
        qmgrs.setText(ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.FULL.REPOS.TABLE.TITLE"));
        TableColumn chans = new TableColumn(this.qmgrsList, 0);
        chans.setText(ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.CLUSTER.SENDER.TABLE.TITLE"));
        TableColumn conns = new TableColumn(this.qmgrsList, 0);
        conns.setText(ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.CLUSTER.CONNAME.TABLE.TITLE"));
        chans.setWidth(100);
        conns.setWidth(150);
        gridDat = new GridData(768);
        this.qmgrsList.setLayoutData((Object)gridDat);
    }

    private void setChannelNames() {
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < this.nameTexts.length) {
            names.add(this.nameTexts[i].getText());
            ++i;
        }
        ArrayList<String> conns = new ArrayList<String>();
        int i2 = 0;
        while (i2 < this.connCombos.length) {
            conns.add(this.connCombos[i2].getText());
            ++i2;
        }
        this.wizard.setSenderQmgrs(this.full_repositories);
        this.wizard.setSenderChannelNames(names);
        this.wizard.setSenderConnNames(conns);
    }

    @Override
    protected void nextPressed() {
        this.setChannelNames();
        super.nextPressed();
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        if (visible) {
            AddToClusterWiz wiz = (AddToClusterWiz)this.getWizard();
            this.full_repositories = wiz.getFullRepositories();
            Hashtable<DmQueueManager, String> suggestions = new Hashtable<DmQueueManager, String>();
            int numrepos = this.full_repositories.size();
            this.qmgrsHash.clear();
            int i = 0;
            while (i < numrepos) {
                GetChannelNames action = new GetChannelNames();
                action.init(this.full_repositories.get(i));
                try {
                    boolean forkable = true;
                    boolean cancelable = false;
                    this.getWizard().getContainer().run(forkable, cancelable, (IRunnableWithProgress)action);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
                DmQueueManager dmQm = this.full_repositories.get(i);
                DmChannel[] dmChlAry = action.getChannels();
                ArrayList<String> dmChlArrLst = new ArrayList<String>();
                int j = 0;
                while (j < dmChlAry.length) {
                    dmChlArrLst.add(dmChlAry[j].getTitle());
                    ++j;
                }
                this.qmgrsHash.put(dmQm, dmChlArrLst);
                suggestions.put(dmQm, action.getDefaultNewName(t, this.wizard.getQueueManager().getDmQueueManagerObject()));
                ++i;
            }
            if (wiz.getSenderQmgrs() == null) {
                this.qmgrsList.removeAll();
                i = 0;
                while (i < this.nameTexts.length) {
                    this.nameTexts[i].dispose();
                    ++i;
                }
                i = 0;
                while (i < this.connCombos.length) {
                    this.connCombos[i].dispose();
                    ++i;
                }
                this.nameEditors = new TableEditor[this.full_repositories.size()];
                this.nameTexts = new Text[this.full_repositories.size()];
                this.connEditors = new TableEditor[this.full_repositories.size()];
                this.connCombos = new ExtCCombo[this.full_repositories.size()];
                this.items = new TableItem[this.full_repositories.size()];
                i = 0;
                while (i < this.full_repositories.size()) {
                    DmQueueManager qmgr = this.full_repositories.get(i);
                    this.items[i] = new TableItem(this.qmgrsList, 0);
                    this.items[i].setText(0, qmgr.getTreeName(t));
                    this.nameTexts[i] = new Text((Composite)this.qmgrsList, 2048);
                    this.nameTexts[i].setText((String)suggestions.get(qmgr));
                    this.nameEditors[i] = new TableEditor(this.qmgrsList);
                    this.nameEditors[i].grabHorizontal = true;
                    this.nameEditors[i].grabVertical = true;
                    this.nameEditors[i].setEditor((Control)this.nameTexts[i], this.items[i], 1);
                    this.nameTexts[i].addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent arg0) {
                            AddToClusterWizPage7.this.checkValues(Trace.getDefault());
                        }
                    });
                    this.connCombos[i] = new ExtCCombo((Composite)this.qmgrsList, 4);
                    this.connEditors[i] = new TableEditor(this.qmgrsList);
                    this.connEditors[i].grabHorizontal = true;
                    this.connEditors[i].grabVertical = true;
                    this.connEditors[i].setEditor((Control)this.connCombos[i], this.items[i], 2);
                    this.connCombos[i].getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            AddToClusterWizPage7.this.checkValues(Trace.getDefault());
                        }
                    });
                    this.connCombos[i].getCombo().addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent arg0) {
                            AddToClusterWizPage7.this.checkValues(Trace.getDefault());
                        }
                    });
                    ClusterFactory factory = ClusterFactory.getDefault();
                    ArrayList listenersArray = factory.getListeners(t, this.wizard.getQueueManager(), (IWizard)this.wizard);
                    ArrayList<String> connectionsList = null;
                    connectionsList = this.wizard.getQueueManager().isLocal() ? factory.getConnectionListForLocalQM(t, listenersArray) : factory.getConnectionListForRemoteQM(t, listenersArray, this.wizard.getQueueManager());
                    this.connCombos[i].removeAll();
                    int idx = 0;
                    while (idx < connectionsList.size()) {
                        this.connCombos[i].add((Object)connectionsList.get(idx));
                        ++idx;
                    }
                    this.connCombos[i].sort();
                    if (this.connCombos[i].getItemCount() > 0 && this.connCombos[i].getSelectionIndex() == -1) {
                        this.connCombos[i].select(0);
                    }
                    ++i;
                }
                this.qmgrsList.getColumn(0).pack();
                this.qmgrsList.getColumn(1).pack();
                this.composite.layout(true);
            }
            this.hasErrConnNullState = false;
            this.hasErrErrorState = false;
            this.hasErrInvalidChars = false;
            this.hasErrNullState = false;
            this.checkValues(t);
        }
        super.setVisible(visible);
    }

    private void checkValues(Trace t) {
        boolean hasError = false;
        boolean curErrInvalidChars = false;
        boolean curErrNullState = false;
        boolean curErrErrorState = false;
        boolean curErrConnNullState = false;
        if (this.items != null) {
            String name;
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i] != null) {
                    this.items[i].setImage(0, null);
                }
                ++i;
            }
            i = 0;
            while (i < this.nameTexts.length) {
                if (this.nameTexts[i] != null) {
                    name = this.nameTexts[i].getText();
                    if (!StringValidation.isValidMQName((Trace)t, (String)name, (int)20)) {
                        this.items[i].setImage(0, this.errorIcon);
                        UiPlugin.getDisplay().beep();
                        hasError = true;
                        curErrInvalidChars = true;
                    } else if (name.compareTo("") == 0) {
                        this.items[i].setImage(0, this.errorIcon);
                        hasError = true;
                        curErrNullState = true;
                    } else if (this.qmgrsHash.get(this.full_repositories.get(i)).contains(name)) {
                        this.items[i].setImage(0, this.errorIcon);
                        hasError = true;
                        curErrErrorState = true;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.connCombos.length) {
                if (this.connCombos[i] != null && (name = this.connCombos[i].getText()).compareTo("") == 0) {
                    this.items[i].setImage(0, this.errorIcon);
                    hasError = true;
                    curErrConnNullState = true;
                }
                ++i;
            }
            if (hasError) {
                if (curErrConnNullState && !this.hasErrConnNullState) {
                    this.lastStatus = AddToClusterWizPage4.ConnNULLSTATE;
                } else if (curErrErrorState && !this.hasErrErrorState) {
                    this.lastStatus = AddToClusterWizPage4.ERRORSTATE;
                } else if (curErrInvalidChars && !this.hasErrInvalidChars) {
                    this.lastStatus = AddToClusterWizPage4.INVALIDCHARS;
                } else if (curErrNullState && !this.hasErrNullState) {
                    this.lastStatus = AddToClusterWizPage4.NULLSTATE;
                }
            } else {
                this.lastStatus = null;
            }
            this.hasErrConnNullState = curErrConnNullState;
            this.hasErrErrorState = curErrErrorState;
            this.hasErrInvalidChars = curErrInvalidChars;
            this.hasErrNullState = curErrNullState;
            if (this.lastStatus == null) {
                this.applyToStatusLine(OKSTATE);
                this.setPageComplete(true);
            } else {
                this.applyToStatusLine(this.lastStatus);
                this.setPageComplete(false);
            }
        }
    }

    @Override
    protected void checkIfEnableButtons() {
        boolean isEnableNext = this.isPageComplete();
        boolean isEnableFinish = false;
        this.setPageComplete(isEnableNext);
        this.wizard.setEnableFinish(isEnableFinish);
        this.wizard.updateButtons();
    }
}

