/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.wizards;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import com.ibm.mq.explorer.clusterplugin.internal.actions.GetChannelNames;
import com.ibm.mq.explorer.clusterplugin.internal.actions.GetReceiverChannelNames;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWiz;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWizPage;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.internal.controls.ExtCCombo;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AddToClusterWizPage6
extends AddToClusterWizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/wizards/AddToClusterWizPage6.java";
    private static String errorText = ClusterPlugin.getResourceString("UI.CLUS.LocalNameClash.Status");
    private static String titleText = null;
    private Image errorIcon = null;
    private boolean loadComplete = false;
    private ArrayList<DmQueueManager> full_repositories = null;
    private Hashtable<DmQueueManager, DmChannel[]> qmgrsRecvHash = null;
    private ArrayList qmgrsAllHash = null;
    private Table qmgrsList;
    private TableItem[] items = new TableItem[0];
    private TableEditor[] editors = new TableEditor[0];
    private ExtCCombo[] combos = new ExtCCombo[0];
    private Composite composite;
    static final IStatus NORECEIVERS = new Status(4, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.QueueManagerNotUsed.Status"), 0, ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.NO.RECEIVER.CHANNELS"), null);

    public AddToClusterWizPage6(String pageName) {
        super(pageName);
        this.full_repositories = new ArrayList();
        this.qmgrsRecvHash = new Hashtable();
        this.setHeadingsInfo();
    }

    public AddToClusterWizPage6(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setHeadingsInfo();
        this.full_repositories = new ArrayList();
        this.qmgrsRecvHash = new Hashtable();
    }

    private void setHeadingsInfo() {
        if (titleText == null) {
            titleText = ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.EnableComms3");
        }
        this.setTitle(titleText);
        if (this.errorIcon == null) {
            this.errorIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
        }
    }

    @Override
    protected void createPageContent(Composite parent) {
        Trace t = Trace.getDefault();
        this.wizard = (AddToClusterWiz)this.getWizard();
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        GridData gridDat = new GridData(1808);
        gridDat.horizontalSpan = 5;
        this.composite.setLayoutData((Object)gridDat);
        this.composite.setLayout((Layout)layout);
        this.setControl((Control)this.composite);
        Text exp = new Text(this.composite, 64);
        exp.setText(ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.SELECT.RECEIVER.CHANNEL.DESCRIPTION"));
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)exp, (boolean)true);
        gridDat = new GridData(2);
        exp.setLayoutData((Object)gridDat);
        this.qmgrsList = new Table(this.composite, 67588);
        this.qmgrsList.setLinesVisible(true);
        this.qmgrsList.setHeaderVisible(true);
        TableColumn qmgrs = new TableColumn(this.qmgrsList, 0);
        qmgrs.setText(ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.FULL.REPOS.TABLE.TITLE"));
        TableColumn chans = new TableColumn(this.qmgrsList, 0);
        chans.setText(ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.CLUSTER.RECEIVER.TABLE.TITLE"));
        chans.setWidth(100);
        gridDat = new GridData(768);
        this.qmgrsList.setLayoutData((Object)gridDat);
    }

    private void setChannelNames() {
        int numcmbs = this.combos.length;
        ArrayList<DmChannel> chans = new ArrayList<DmChannel>();
        int i = 0;
        while (i < numcmbs) {
            int sel = this.combos[i].getSelectionIndex();
            if (sel != -1) {
                chans.add((DmChannel)this.combos[i].getObject(sel));
            }
            ++i;
        }
        this.wizard.setKnownReceiverChanels(chans);
    }

    @Override
    protected void nextPressed() {
        this.setChannelNames();
        super.nextPressed();
    }

    private void checkValues(Trace t) {
        if (!this.loadComplete) {
            return;
        }
        boolean noError = true;
        Enumeration<DmQueueManager> en = this.qmgrsRecvHash.keys();
        while (en.hasMoreElements()) {
            DmQueueManager qmgr = en.nextElement();
            DmChannel[] channels = this.qmgrsRecvHash.get(qmgr);
            if (channels.length != 0) continue;
            this.applyToStatusLine(NORECEIVERS);
            this.setPageComplete(false);
            return;
        }
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] != null) {
                this.items[i].setImage(0, null);
            }
            ++i;
        }
        if (this.items != null) {
            i = 0;
            while (i < this.items.length) {
                int sel = this.combos[i].getSelectionIndex();
                if (sel != -1) {
                    DmChannel c = (DmChannel)this.combos[i].getObject(sel);
                    if (this.qmgrsAllHash.contains(c.getTitle())) {
                        String errorMsg = MessageFormat.format(errorText, c.getTitle(), this.wizard.getQueueManager().getTreeName());
                        Status status = new Status(4, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.QueueManagerNotUsed.Status"), 0, errorMsg, null);
                        this.applyToStatusLine((IStatus)status);
                        this.items[i].setImage(0, this.errorIcon);
                        noError = false;
                    }
                } else {
                    this.applyToStatusLine(NORECEIVERS);
                    noError = false;
                }
                ++i;
            }
            if (noError) {
                this.applyToStatusLine(AddToClusterWizPage.OKSTATE);
            }
            this.setPageComplete(noError);
        }
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        if (visible) {
            this.loadComplete = false;
            AddToClusterWiz wiz = (AddToClusterWiz)this.getWizard();
            this.full_repositories = wiz.getFullRepositories();
            String clustername = wiz.getClusterName();
            int numrepos = this.full_repositories.size();
            GetChannelNames actionAll = new GetChannelNames();
            actionAll.init(this.wizard.getQueueManager().getDmQueueManagerObject());
            try {
                boolean forkable = true;
                boolean cancelable = false;
                this.getWizard().getContainer().run(forkable, cancelable, (IRunnableWithProgress)actionAll);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
            this.qmgrsAllHash = actionAll.getChannelNames();
            this.qmgrsRecvHash.clear();
            int i = 0;
            while (i < numrepos) {
                GetReceiverChannelNames action = new GetReceiverChannelNames();
                action.init(this.full_repositories.get(i), clustername);
                try {
                    boolean forkable = true;
                    boolean cancelable = false;
                    this.getWizard().getContainer().run(forkable, cancelable, (IRunnableWithProgress)action);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
                DmQueueManager dmQm = this.full_repositories.get(i);
                DmChannel[] dmChlAry = action.getChannels();
                this.qmgrsRecvHash.put(dmQm, dmChlAry);
                ++i;
            }
            this.qmgrsList.removeAll();
            i = 0;
            while (i < this.combos.length) {
                this.combos[i].dispose();
                ++i;
            }
            this.items = new TableItem[this.full_repositories.size()];
            this.editors = new TableEditor[this.full_repositories.size()];
            this.combos = new ExtCCombo[this.full_repositories.size()];
            i = 0;
            Enumeration<DmQueueManager> en = this.qmgrsRecvHash.keys();
            while (en.hasMoreElements()) {
                DmQueueManager qmgr = en.nextElement();
                DmChannel[] channels = this.qmgrsRecvHash.get(qmgr);
                this.items[i] = new TableItem(this.qmgrsList, 0);
                this.items[i].setText(0, qmgr.getTreeName(t));
                this.combos[i] = new ExtCCombo((Composite)this.qmgrsList, 2056);
                this.editors[i] = new TableEditor(this.qmgrsList);
                this.editors[i].grabHorizontal = true;
                this.editors[i].grabVertical = true;
                this.editors[i].setEditor((Control)this.combos[i], this.items[i], 1);
                int k = 0;
                while (k < channels.length) {
                    this.combos[i].add((Object)channels[k]);
                    ++k;
                }
                if (channels.length > 0) {
                    this.combos[i].select(0);
                } else {
                    this.applyToStatusLine(NORECEIVERS);
                }
                ++i;
            }
            this.qmgrsList.getColumn(0).pack();
            this.qmgrsList.getColumn(1).pack();
            this.composite.layout(true);
            this.loadComplete = true;
            this.checkValues(t);
        }
        super.setVisible(visible);
    }

    @Override
    protected void checkIfEnableButtons() {
        boolean isEnableNext = this.isPageComplete();
        boolean isEnableFinish = false;
        this.setPageComplete(isEnableNext);
        this.wizard.setEnableFinish(isEnableFinish);
        this.wizard.updateButtons();
    }
}

