/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.wizards;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import com.ibm.mq.explorer.clusterplugin.internal.actions.GetChannelNames;
import com.ibm.mq.explorer.clusterplugin.internal.factory.ClusterFactory;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWiz;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWizPage;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddToClusterWizPage4
extends AddToClusterWizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/wizards/AddToClusterWizPage4.java";
    private static String titleText = null;
    protected Text textChanName = null;
    protected ExtCombo comboConnName = null;
    protected ArrayList knownchannelNames = null;
    protected String selectedchannelname = "";
    protected String selectedcconname = "";
    protected boolean refresh = true;
    protected static final IStatus ERRORSTATE = new Status(4, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.QueueManagerNotUsed.Status"), 0, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.ChannelExists.Status"), null);
    protected static final IStatus NULLSTATE = new Status(4, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.QueueManagerNotUsed.Status"), 0, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.ChannelNameRequired.Status"), null);
    protected static final IStatus ConnNULLSTATE = new Status(4, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.QueueManagerNotUsed.Status"), 0, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.ConnNameRequired.Status"), null);
    protected static final IStatus INVALIDCHARS = new Status(4, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.QueueManagerNotUsed.Status"), 0, ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.ChannelNameInvalid.Status"), null);
    private boolean valid = true;

    public AddToClusterWizPage4(String pageName) {
        super(pageName);
        this.setHeadingsInfo();
    }

    public AddToClusterWizPage4(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setHeadingsInfo();
    }

    protected void setHeadingsInfo() {
        if (titleText == null) {
            titleText = ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.EnableComms1");
        }
        this.setTitle(titleText);
    }

    @Override
    protected void createPageContent(Composite parent) {
        Trace t = Trace.getDefault();
        this.wizard = (AddToClusterWiz)this.getWizard();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData gridDat = new GridData();
        gridDat.horizontalSpan = 6;
        composite.setLayoutData((Object)gridDat);
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        Text exp = new Text(composite, 64);
        exp.setText(ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.ClusterReceiver.Info"));
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)exp, (boolean)true);
        gridDat = new GridData();
        gridDat.horizontalSpan = 2;
        exp.setLayoutData((Object)gridDat);
        Label labelChanName = new Label(composite, 0);
        labelChanName.setText(ClusterPlugin.getResourceString("UI.WIZ.CRTCLUS.ClusterReceiverName.Label"));
        gridDat = new GridData(2);
        labelChanName.setLayoutData((Object)gridDat);
        this.textChanName = new Text(composite, 2048);
        this.textChanName.setText("");
        this.textChanName.setTextLimit(20);
        this.textChanName.setFocus();
        gridDat = new GridData(770);
        gridDat.widthHint = 200;
        this.textChanName.setLayoutData((Object)gridDat);
        Label space = new Label(composite, 64);
        gridDat = new GridData();
        gridDat.horizontalSpan = 2;
        space.setLayoutData((Object)gridDat);
        Label conname = new Label(composite, 0);
        conname.setText(ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.RECEIVER.CONNAME"));
        this.comboConnName = new ExtCombo(composite, 4);
        gridDat = new GridData(770);
        this.comboConnName.setLayoutData((Object)gridDat);
        this.comboConnName.setTextLimit(264);
        this.textChanName.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Trace t2 = Trace.getDefault();
                AddToClusterWizPage4.this.valid = StringValidation.verifyMQObjectName((Trace)t2, (VerifyEvent)e);
            }
        });
        this.textChanName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AddToClusterWizPage4.this.selectedchannelname = AddToClusterWizPage4.this.textChanName.getText();
                AddToClusterWizPage4.this.setChannelName(AddToClusterWizPage4.this.selectedchannelname);
            }
        });
        this.comboConnName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int selIndex = AddToClusterWizPage4.this.comboConnName.getSelectionIndex();
                if (selIndex != -1) {
                    AddToClusterWizPage4.this.setConnName((String)AddToClusterWizPage4.this.comboConnName.getObject(selIndex));
                }
            }
        });
        this.comboConnName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AddToClusterWizPage4.this.selectedcconname = AddToClusterWizPage4.this.comboConnName.getText();
                AddToClusterWizPage4.this.setConnName(AddToClusterWizPage4.this.selectedcconname);
            }
        });
    }

    protected void setChannelName(String name) {
        this.wizard.setReceiverChannelName(name);
        this.checkState();
    }

    protected void setConnName(String conname) {
        this.wizard.setReceiverConnName(conname);
        this.selectedcconname = conname;
        this.checkState();
    }

    private void checkState() {
        String name = this.textChanName.getText();
        String conname = this.comboConnName.getText();
        if (!this.valid) {
            this.applyToStatusLine(INVALIDCHARS);
            this.setPageComplete(false);
        } else if (name.compareTo("") == 0) {
            this.applyToStatusLine(NULLSTATE);
            this.setPageComplete(false);
        } else if (this.knownchannelNames.contains(this.selectedchannelname)) {
            this.applyToStatusLine(ERRORSTATE);
            this.setPageComplete(false);
        } else if (conname.compareTo("") == 0) {
            this.applyToStatusLine(ConnNULLSTATE);
            this.setPageComplete(false);
        } else {
            this.applyToStatusLine(OKSTATE);
            this.setPageComplete(true);
        }
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        this.refresh = this.wizard.isQueueManagerChanged();
        if (this.refresh && visible) {
            GetChannelNames action = new GetChannelNames();
            action.init(this.wizard.getQueueManager().getDmQueueManagerObject());
            try {
                boolean forkable = true;
                boolean cancelable = false;
                this.getWizard().getContainer().run(forkable, cancelable, (IRunnableWithProgress)action);
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace();
            }
            catch (InterruptedException interruptedException) {}
            this.knownchannelNames = action.getChannelNames();
            this.selectedchannelname = action.getDefaultNewName();
            this.textChanName.setText(this.selectedchannelname);
            this.setChannelName(this.selectedchannelname);
            UiQueueManager qmgr = this.wizard.getQueueManager();
            ClusterFactory factory = ClusterFactory.getDefault();
            ArrayList listenersArray = factory.getListeners(t, qmgr, (IWizard)this.wizard);
            ArrayList<String> connectionsList = null;
            connectionsList = qmgr.isLocal() ? factory.getConnectionListForLocalQM(t, listenersArray) : factory.getConnectionListForRemoteQM(t, listenersArray, qmgr);
            this.comboConnName.removeAll();
            int idx = 0;
            while (idx < connectionsList.size()) {
                this.comboConnName.add((Object)connectionsList.get(idx));
                ++idx;
            }
            this.comboConnName.sort();
            this.wizard.setQueueManagerChanged(false);
        }
        super.setVisible(visible);
        if (visible) {
            this.comboConnName.setFocus();
            if (this.comboConnName.getItemCount() > 0 && this.comboConnName.getSelectionIndex() == -1) {
                this.comboConnName.select(0);
            }
        }
    }

    @Override
    protected void checkIfEnableButtons() {
        boolean isEnableNext = this.isPageComplete();
        boolean isEnableFinish = false;
        this.setPageComplete(isEnableNext);
        this.wizard.setEnableFinish(isEnableFinish);
        this.wizard.updateButtons();
    }
}

