/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.wizards;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import com.ibm.mq.explorer.clusterplugin.internal.actions.AddQueueManagerToCluster;
import com.ibm.mq.explorer.clusterplugin.internal.actions.CreateSenderChannelsForQueueManager;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWizDlg;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWizPage;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWizPage1;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWizPage2;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWizPage3;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWizPage4;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWizPage5;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWizPage6;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWizPage7;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.AddToClusterWizPage8;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class AddToClusterWiz
extends Wizard {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/wizards/AddToClusterWiz.java";
    private static String wizardName = null;
    private UiQueueManager queueManager = null;
    private String clusterName = null;
    private boolean isFullRepository = false;
    private String receiverChannelName = null;
    private String receiverConnName = null;
    private List<DmQueueManager> senderQmgrs = null;
    private List<String> senderChannelNames = null;
    private List<String> senderConnNames = null;
    private ArrayList<DmQueueManager> fullRepositories = null;
    private ArrayList<DmChannel> knownReceiverChanels = null;
    private boolean queueManagerChanged = true;
    private boolean enableFinish = false;
    private AddToClusterWizPage page1 = null;
    public static final String page1Name = "Pick QM Name";
    private AddToClusterWizPage page2 = null;
    public static final String page2Name = "Pick Cluster Name";
    private AddToClusterWizPage page3 = null;
    public static final String page3Name = "Pick Cluster Type";
    private AddToClusterWizPage page4 = null;
    public static final String page4Name = "Enter cluster receiver channel";
    private AddToClusterWizPage page5 = null;
    public static final String page5Name = "Select cluster sender qmgrs";
    private AddToClusterWizPage page6 = null;
    public static final String page6Name = "Select cluster receiver channels";
    private AddToClusterWizPage page7 = null;
    public static final String page7Name = "Create remote cluster sender channels";
    private AddToClusterWizPage8 page8 = null;
    public static final String page8Name = "Summary info before join";
    private int fFailureReason = 0;
    private AddToClusterWizDlg addToClusterWizDlg = null;

    public AddToClusterWiz() {
        if (wizardName == null) {
            wizardName = ClusterPlugin.getResourceString("UI.CLUS.Add.Wizard");
        }
        this.fullRepositories = new ArrayList();
        this.knownReceiverChanels = new ArrayList();
        this.page1 = new AddToClusterWizPage1(page1Name);
        this.page2 = new AddToClusterWizPage2(page2Name);
        this.page3 = new AddToClusterWizPage3(page3Name);
        this.page4 = new AddToClusterWizPage4(page4Name);
        this.page5 = new AddToClusterWizPage5(page5Name);
        this.page6 = new AddToClusterWizPage6(page6Name);
        this.page7 = new AddToClusterWizPage7(page7Name);
        this.page8 = new AddToClusterWizPage8(page8Name);
        this.setWindowTitle(wizardName);
    }

    public boolean performFinish() {
        String chl;
        DmChannel dmChl;
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            String tracedata = "";
            tracedata = String.valueOf(tracedata) + "selected cluster name: " + this.clusterName + "\n";
            tracedata = String.valueOf(tracedata) + "qmgr joining: " + this.getQueueManager().getTreeName() + "\n";
            tracedata = String.valueOf(tracedata) + "isFullRepository: " + this.isFullRepository() + "\n";
            tracedata = String.valueOf(tracedata) + "receiver chl name: " + this.getReceiverChannelName() + "\n";
            tracedata = String.valueOf(tracedata) + "receiver chl conname: " + this.getReceiverConnName() + "\n";
            if (this.senderQmgrs != null && this.senderChannelNames != null && this.senderConnNames != null) {
                tracedata = String.valueOf(tracedata) + "sender chl(s): \n";
                int i = 0;
                while (i < this.senderChannelNames.size()) {
                    tracedata = String.valueOf(tracedata) + "  qmgr: " + this.senderQmgrs.get(i).getTreeName(t) + " channel name: " + this.senderChannelNames.get(i) + " conname: " + this.senderConnNames.get(i) + "\n";
                    ++i;
                }
            }
            int k = 0;
            while (k < this.getFullRepositories().size()) {
                String line = ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.SUMMARY.SENDER.CHANNEL");
                dmChl = this.getKnownReceiverChanels().get(k);
                chl = dmChl.getTitle();
                DmQueueManager dqm = this.getFullRepositories().get(k);
                String qm = dqm.getTreeName(t);
                line = MessageFormat.format(line, chl, qm);
                tracedata = String.valueOf(tracedata) + line + "\n";
                ++k;
            }
            t.data(66, "AddToClusterWiz.performFinish", 800, tracedata);
        }
        String[] sendChlNames = new String[this.getFullRepositories().size()];
        String[] sendChlConNames = new String[this.getFullRepositories().size()];
        int k = 0;
        while (k < this.getFullRepositories().size()) {
            dmChl = this.getKnownReceiverChanels().get(k);
            sendChlNames[k] = chl = dmChl.getTitle();
            Attr att = dmChl.getAttribute(t, 3506, 0);
            sendChlConNames[k] = (String)att.getValue(t);
            ++k;
        }
        AddQueueManagerToCluster addAction = new AddQueueManagerToCluster();
        addAction.init(t, this.getQueueManager().getDmQueueManagerObject(), this.clusterName, "", this.isFullRepository, this.getReceiverChannelName(), this.getReceiverConnName(), sendChlNames, sendChlConNames);
        try {
            boolean forkable = true;
            boolean cancelable = true;
            this.getContainer().run(forkable, cancelable, (IRunnableWithProgress)addAction);
            if (addAction.hasFailed()) {
                this.fFailureReason = addAction.getReasonCode();
                addAction.rollbackAll(t);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            addAction.rollbackAll(t);
        }
        catch (InterruptedException interruptedException) {
            addAction.rollbackAll(t);
        }
        if (addAction.hasFailed()) {
            return true;
        }
        boolean failed = false;
        if (this.isFullRepository) {
            ArrayList<CreateSenderChannelsForQueueManager> actions = new ArrayList<CreateSenderChannelsForQueueManager>();
            if (this.senderQmgrs != null && this.senderChannelNames != null && this.senderConnNames != null) {
                int i = 0;
                while (i < this.senderQmgrs.size()) {
                    CreateSenderChannelsForQueueManager senderCreateAction = new CreateSenderChannelsForQueueManager();
                    senderCreateAction.init(t, this.senderQmgrs.get(i), this.clusterName, this.senderChannelNames.get(i), this.senderConnNames.get(i));
                    actions.add(senderCreateAction);
                    ++i;
                }
            }
            boolean revert = false;
            int curAction = 0;
            curAction = 0;
            while (curAction < actions.size()) {
                try {
                    boolean forkable = true;
                    boolean cancelable = true;
                    this.getContainer().run(forkable, cancelable, (IRunnableWithProgress)actions.get(curAction));
                    if (((CreateSenderChannelsForQueueManager)actions.get(curAction)).hasFailed()) {
                        this.fFailureReason = ((CreateSenderChannelsForQueueManager)actions.get(curAction)).getReasonCode();
                        revert = true;
                        break;
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    revert = true;
                }
                catch (InterruptedException interruptedException) {
                    revert = true;
                }
                ++curAction;
            }
            if (revert) {
                while (curAction >= 0) {
                    ((CreateSenderChannelsForQueueManager)actions.get(curAction)).rollbackAll(t);
                    --curAction;
                }
            }
            int i = 0;
            while (i < actions.size()) {
                failed = failed || ((CreateSenderChannelsForQueueManager)actions.get(i)).hasFailed();
                ++i;
            }
        }
        return failed;
    }

    public int getFailureReason() {
        return this.fFailureReason;
    }

    public String getSummary() {
        String line;
        Trace t = Trace.getDefault();
        String line1 = ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.SUMMARY.LINE1");
        line1 = MessageFormat.format(line1, this.getQueueManager().getTreeName(), this.getClusterName());
        String line2 = "";
        line2 = this.isFullRepository ? ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.SUMMARY.ADDING.FULL") : ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.SUMMARY.ADDING.PARTIAL");
        String line3 = ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.SUMMARY.RECEIVER");
        line3 = MessageFormat.format(line3, this.getReceiverChannelName());
        String line4 = ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.SUMMARY.CONNAME");
        line4 = MessageFormat.format(line4, this.getReceiverConnName());
        String NEWLINE = "\n";
        String summary = String.valueOf(line1) + NEWLINE;
        summary = String.valueOf(summary) + line2 + NEWLINE;
        summary = String.valueOf(summary) + line3 + NEWLINE;
        summary = String.valueOf(summary) + line4 + NEWLINE;
        int k = 0;
        while (k < this.getFullRepositories().size()) {
            line = ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.SUMMARY.SENDER.CHANNEL");
            DmChannel dmChl = this.getKnownReceiverChanels().get(k);
            String chl = dmChl.getTitle();
            DmQueueManager dqm = dmChl.getQueueManager();
            String qm = dqm.getTreeName(t);
            line = MessageFormat.format(line, chl, qm);
            summary = String.valueOf(summary) + line + NEWLINE;
            ++k;
        }
        if (this.isFullRepository && this.senderQmgrs != null && this.senderChannelNames != null && this.senderConnNames != null) {
            int i = 0;
            while (i < this.getSenderQmgrs().size()) {
                line = ClusterPlugin.getResourceString("UI.WIZ.JOINCLUS.SUMMARY.REMOTE.SENDER.CHANNEL");
                String chl = this.getSenderChannelNames().get(i);
                String rqm = this.getSenderQmgrs().get(i).getTreeName(t);
                String qm = this.queueManager.getTreeName();
                line = MessageFormat.format(line, chl, rqm, qm);
                summary = String.valueOf(summary) + line + NEWLINE;
                ++i;
            }
        }
        return summary;
    }

    public void addPages() {
        if (this.getQueueManager() == null) {
            this.addPage((IWizardPage)this.page1);
        }
        if (this.getClusterName() == null) {
            this.addPage((IWizardPage)this.page2);
        }
        this.addPage((IWizardPage)this.page3);
        this.addPage((IWizardPage)this.page4);
        this.addPage((IWizardPage)this.page5);
        this.addPage((IWizardPage)this.page6);
        this.addPage((IWizardPage)this.page7);
        this.addPage((IWizardPage)this.page8);
        this.setNeedsProgressMonitor(true);
    }

    public IWizardPage getNextPage(IWizardPage curPage) {
        if (!this.isFullRepository && curPage == this.page6) {
            return this.page8;
        }
        return super.getNextPage(curPage);
    }

    public void setEnableFinish(boolean enableFinishValue) {
        this.enableFinish = enableFinishValue;
    }

    public boolean canFinish() {
        return this.enableFinish;
    }

    public void updateButtons() {
        if (this.addToClusterWizDlg == null) {
            this.addToClusterWizDlg = (AddToClusterWizDlg)this.getContainer();
        }
        this.addToClusterWizDlg.updateButtons();
    }

    public UiQueueManager getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(UiQueueManager queueManager) {
        if (this.queueManager != queueManager) {
            this.queueManager = queueManager;
            this.senderQmgrs = null;
            this.senderChannelNames = null;
            this.senderConnNames = null;
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public boolean isFullRepository() {
        return this.isFullRepository;
    }

    public void setFullRepository(boolean isFullRepository) {
        this.isFullRepository = isFullRepository;
        if (this.isFullRepository) {
            this.page8.setPageNumber(7);
        } else {
            this.page8.setPageNumber(6);
        }
    }

    public String getReceiverChannelName() {
        return this.receiverChannelName;
    }

    public void setReceiverChannelName(String receiverChannelName) {
        this.receiverChannelName = receiverChannelName;
    }

    public String getReceiverConnName() {
        return this.receiverConnName;
    }

    public void setReceiverConnName(String receiverConnName) {
        this.receiverConnName = receiverConnName;
    }

    public List<String> getSenderChannelNames() {
        return this.senderChannelNames;
    }

    public void setSenderChannelNames(List<String> senderChannelNames) {
        this.senderChannelNames = senderChannelNames;
    }

    public List<String> getSenderConnNames() {
        return this.senderConnNames;
    }

    public void setSenderConnNames(List<String> senderConnNames) {
        this.senderConnNames = senderConnNames;
    }

    public List<DmQueueManager> getSenderQmgrs() {
        return this.senderQmgrs;
    }

    public void setSenderQmgrs(List<DmQueueManager> senderQmgrs) {
        this.senderQmgrs = senderQmgrs;
    }

    public ArrayList<DmQueueManager> getFullRepositories() {
        return this.fullRepositories;
    }

    public void setFullRepositories(ArrayList<DmQueueManager> fullRepositories) {
        this.fullRepositories = fullRepositories;
    }

    public ArrayList<DmChannel> getKnownReceiverChanels() {
        return this.knownReceiverChanels;
    }

    public void setKnownReceiverChanels(ArrayList<DmChannel> knownReceiverChanels) {
        this.knownReceiverChanels = knownReceiverChanels;
    }

    public boolean isQueueManagerChanged() {
        return this.queueManagerChanged;
    }

    public void setQueueManagerChanged(boolean queueManagerChanged) {
        this.queueManagerChanged = queueManagerChanged;
    }
}

