/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.treenodes;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.ImageCache;
import com.ibm.mq.explorer.clusterplugin.internal.objects.BaseClusterObject;
import com.ibm.mq.explorer.clusterplugin.internal.objects.OptimisticCluster;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public final class ClusterObjectTreeNode
extends TreeNode {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/treenodes/ClusterObjectTreeNode.java";
    private BaseClusterObject clusterObject = null;

    public ClusterObjectTreeNode(Trace trace, TreeNode parent, MQExtObject object) {
        super(parent, object, "com.ibm.mq.explorer.clusterplugin");
        this.clusterObject = (BaseClusterObject)object;
    }

    public final String toString() {
        String name = "";
        if (this.clusterObject != null) {
            name = this.clusterObject.getClusterName();
        }
        return name;
    }

    public final BaseClusterObject getClusterObject() {
        return this.clusterObject;
    }

    public void setClusterObject(BaseClusterObject obj) {
        this.clusterObject = obj;
    }

    public final String getId() {
        return "com.ibm.mq.explorer.clusterplugin.id.nodeid.cluster." + this.clusterObject.getClusterName();
    }

    public final String getContentPageId() {
        return "com.ibm.mq.explorer.clusterplugin.id.pageid.cluster";
    }

    public final Image getIcon() {
        Trace t = Trace.getDefault();
        Image icon = null;
        icon = this.clusterObject instanceof OptimisticCluster || this.clusterObject.getProvider() == null ? ImageCache.getImage(t, "clusterWarningSmall.gif") : ImageCache.getImage(t, "clusterSmall.gif");
        return icon;
    }

    public final String getSequence() {
        return "99999";
    }

    public final int compare(TreeNode child1, TreeNode child2) {
        return TreeNode.compareBySequence((TreeNode)child1, (TreeNode)child2);
    }

    public final boolean isContextMenuFromUiObject() {
        return false;
    }

    public final boolean isAddChildrenWhenExpanded() {
        return false;
    }

    public void appendToContextMenu(Shell shell, IMenuManager manager) {
        manager.add((IContributionItem)new Separator("com.ibm.mq.explorer.clusterplugin.menu.new.group"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    public String getHelpId() {
        return "com.ibm.mq.explorer.ui.infopop.UI_ClusterTreeNode";
    }
}

