/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.UiClusterQueueManager;
import com.ibm.mq.explorer.clusterplugin.internal.factory.ClusterFactory;
import com.ibm.mq.explorer.clusterplugin.internal.factory.ExplorerTreeNodeFactory;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ClusterQueueManagerFolder;
import com.ibm.mq.explorer.clusterplugin.internal.objects.IClusterObject;
import com.ibm.mq.explorer.clusterplugin.internal.objects.OptimisticCluster;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ProviderChangedEvent;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ProviderChangedListener;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.pcf.event.PCFFilter;
import java.util.ArrayList;
import java.util.Vector;

public abstract class BaseClusterObject
extends MQExtObject
implements IClusterObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/objects/BaseClusterObject.java";
    protected TreeNode treenode = null;
    protected ExplorerTreeNodeFactory treeFactory = null;
    protected DmQueueManager provider = null;
    protected PCFFilter pcfFilter = null;
    protected DmObjectFilter filter = null;
    protected ClusterQueueManagerFolder fullRepositories = null;
    protected ClusterQueueManagerFolder partRepositories = null;
    private Vector providerChangedListeners = null;

    public BaseClusterObject(MQExtObject parentObj, Object obj, String type, String objId, String objName) {
        super(parentObj, obj, type, objId, objName);
        Trace t = Trace.getDefault();
        this.providerChangedListeners = new Vector();
        this.treeFactory = ExplorerTreeNodeFactory.getDefault();
        this.fullRepositories = new ClusterQueueManagerFolder(this, null, "", "", ClusterPlugin.getResourceString("UI.NAVI.FullRepositoryFolder"), 0);
        this.partRepositories = new ClusterQueueManagerFolder(this, null, "", "", ClusterPlugin.getResourceString("UI.NAVI.PartialRepositoryFolder"), 1);
        this.pcfFilter = PCFFilter.getFilter((int)2029, (PCFFilter.Operation)PCFFilter.EQUAL_TO, (String)objName);
        this.filter = new DmObjectFilter(t, 70, this.pcfFilter);
    }

    protected void hideRepositoryFolders(Trace t) {
        TreeNode node = this.fullRepositories.getTreeNode();
        node.setVisible(false);
        node = this.partRepositories.getTreeNode();
        node.setVisible(false);
        this.treeFactory.updateCluster(t, this);
    }

    protected void showRepositoryFolders(Trace t) {
        TreeNode node = this.fullRepositories.getTreeNode();
        node.setVisible(true);
        node = this.partRepositories.getTreeNode();
        node.setVisible(true);
        this.treeFactory.updateCluster(t, this);
    }

    @Override
    public DmQueueManager getProvider() {
        return this.provider;
    }

    @Override
    public String getClusterName() {
        return this.getName();
    }

    @Override
    public void setTreeNode(TreeNode node) {
        this.treenode = node;
    }

    @Override
    public TreeNode getTreeNode() {
        return this.treenode;
    }

    @Override
    public void setInput(Trace t, DmQueueManager qmgr) {
        int repostype;
        DmClusterQueueManager dmObj;
        UiClusterQueueManager uiObj;
        ArrayList<UiClusterQueueManager> members = this.partRepositories.getClusterQueueManagers();
        int idx = 0;
        while (idx < members.size()) {
            uiObj = members.get(idx);
            dmObj = uiObj.getDmClusterQueueManagerObject();
            repostype = this.getRepositoryType(t, dmObj);
            this.treeFactory.delClusterQueueManager(t, uiObj, repostype);
            ++idx;
        }
        members = this.fullRepositories.getClusterQueueManagers();
        idx = 0;
        while (idx < members.size()) {
            uiObj = members.get(idx);
            dmObj = uiObj.getDmClusterQueueManagerObject();
            repostype = this.getRepositoryType(t, dmObj);
            this.treeFactory.delClusterQueueManager(t, uiObj, repostype);
            ++idx;
        }
        this.fullRepositories.clearInformation(t);
        this.partRepositories.clearInformation(t);
        if (this.provider != null) {
            this.provider.deleteObserver(t, (DmObjectListener)this);
        }
        if (qmgr == null) {
            this.provider = null;
        } else {
            this.provider = qmgr;
            this.provider.addObserver(t, (DmObjectListener)this, this.filter);
        }
        UiPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                BaseClusterObject.this.sendProviderChangedEvent(Trace.getDefault(), BaseClusterObject.this.provider);
            }
        });
    }

    protected int getRepositoryType(Trace t, DmClusterQueueManager clusqmgr) {
        int value = -1;
        Attr attrValue = clusqmgr.getAttribute(t, 1085, 0);
        if (attrValue != null) {
            value = (Integer)attrValue.getValue(t);
        }
        return value;
    }

    private UiClusterQueueManager addClusterQueueManager(Trace t, DmClusterQueueManager clusqmgr, int repostype) {
        UiClusterQueueManager uiObj = null;
        if (repostype == 1) {
            uiObj = this.fullRepositories.addClusterQueueManager(t, clusqmgr);
        }
        if (repostype == 0) {
            uiObj = this.partRepositories.addClusterQueueManager(t, clusqmgr);
        }
        return uiObj;
    }

    private UiClusterQueueManager delClusterQueueManager(Trace t, DmClusterQueueManager clusqmgr, int repostype) {
        UiClusterQueueManager uiObj = null;
        if (repostype == 1) {
            uiObj = this.fullRepositories.delClusterQueueManager(t, clusqmgr);
        }
        if (repostype == 0) {
            uiObj = this.partRepositories.delClusterQueueManager(t, clusqmgr);
        }
        return uiObj;
    }

    private void switchRepositoryType(Trace t, DmClusterQueueManager clusqmgr, int repostype) {
        UiClusterQueueManager uiObj = null;
        switch (repostype) {
            case 1: {
                uiObj = this.partRepositories.getClusterQueueManager(t, clusqmgr);
                if (uiObj == null) break;
                this.treeFactory.delClusterQueueManager(t, uiObj, 0);
                this.delClusterQueueManager(t, clusqmgr, 0);
                uiObj = null;
                uiObj = this.addClusterQueueManager(t, clusqmgr, repostype);
                this.treeFactory.addClusterQueueManager(t, uiObj, repostype);
                break;
            }
            case 0: {
                uiObj = this.fullRepositories.getClusterQueueManager(t, clusqmgr);
                if (uiObj == null) break;
                this.treeFactory.delClusterQueueManager(t, uiObj, 1);
                this.delClusterQueueManager(t, clusqmgr, 1);
                uiObj = null;
                uiObj = this.addClusterQueueManager(t, clusqmgr, repostype);
                this.treeFactory.addClusterQueueManager(t, uiObj, repostype);
            }
        }
    }

    public void dmObjectAdded(DmObjectEvent event) {
        final DmObjectEvent lEvent = event;
        new Thread(){

            @Override
            public void run() {
                Trace t2 = Trace.getDefault();
                DmClusterQueueManager clusqmgr = (DmClusterQueueManager)lEvent.getSource();
                this.setName("IBM MQ Cluster Comp : Add object for " + clusqmgr.getAttributeValue(t2, 2031, 0));
                int repostype = BaseClusterObject.this.getRepositoryType(t2, clusqmgr);
                UiClusterQueueManager uiObj = BaseClusterObject.this.addClusterQueueManager(t2, clusqmgr, repostype);
                if (uiObj != null) {
                    BaseClusterObject.this.treeFactory.addClusterQueueManager(t2, uiObj, repostype);
                }
            }
        }.start();
    }

    public void dmObjectChanged(DmObjectEvent event) {
        final DmObjectEvent lEvent = event;
        new Thread(){

            @Override
            public void run() {
                Trace t2 = Trace.getDefault();
                UiClusterQueueManager uiObj = null;
                DmClusterQueueManager clusqmgr = (DmClusterQueueManager)lEvent.getSource();
                this.setName("IBM MQ Cluster Comp : Change object for " + clusqmgr.getAttributeValue(t2, 2031, 0));
                int repostype = BaseClusterObject.this.getRepositoryType(t2, clusqmgr);
                switch (repostype) {
                    case 1: {
                        uiObj = BaseClusterObject.this.fullRepositories.getClusterQueueManager(t2, clusqmgr);
                        break;
                    }
                    case 0: {
                        uiObj = BaseClusterObject.this.partRepositories.getClusterQueueManager(t2, clusqmgr);
                    }
                }
                if (uiObj != null) {
                    BaseClusterObject.this.treeFactory.updateClusterQueueManager(t2, uiObj);
                } else {
                    BaseClusterObject.this.switchRepositoryType(t2, clusqmgr, repostype);
                }
            }
        }.start();
    }

    public void dmObjectDeleted(DmObjectEvent event) {
        final Trace t = Trace.getDefault();
        final DmObjectEvent lEvent = event;
        final BaseClusterObject self = this;
        new Thread(){

            @Override
            public void run() {
                DmClusterQueueManager clusqmgr = (DmClusterQueueManager)lEvent.getSource();
                this.setName("IBM MQ Cluster Comp : Delete object for " + clusqmgr.getAttributeValue(t, 2031, 0));
                int repostype = BaseClusterObject.this.getRepositoryType(t, clusqmgr);
                UiClusterQueueManager uiObj = BaseClusterObject.this.delClusterQueueManager(t, clusqmgr, repostype);
                if (uiObj != null) {
                    BaseClusterObject.this.treeFactory.delClusterQueueManager(t, uiObj, repostype);
                    uiObj = null;
                    if (self instanceof OptimisticCluster && BaseClusterObject.this.fullRepositories.size() == 0 && BaseClusterObject.this.partRepositories.size() == 0) {
                        ClusterFactory factory = ClusterFactory.getDefault();
                        factory.deleteCluster(t, (OptimisticCluster)self, false);
                    }
                }
            }
        }.start();
    }

    public void addProviderChangedListener(Trace t, ProviderChangedListener listener) {
        this.providerChangedListeners.addElement(listener);
    }

    public void removeProviderChangedListener(Trace t, ProviderChangedListener listener) {
        this.providerChangedListeners.removeElement(listener);
    }

    private void sendProviderChangedEvent(Trace t, DmQueueManager provider) {
        int size = this.providerChangedListeners.size();
        if (size > 0) {
            ProviderChangedEvent provEvent = new ProviderChangedEvent(this, provider);
            int i = 0;
            while (i < size) {
                ProviderChangedListener listener = (ProviderChangedListener)this.providerChangedListeners.elementAt(i);
                listener.providerChanged(provEvent);
                ++i;
            }
        }
    }
}

