/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.listeners;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.UiClusterQueueManager;
import com.ibm.mq.explorer.clusterplugin.internal.factory.ClusterFactory;
import com.ibm.mq.explorer.clusterplugin.internal.listeners.IViaConnectionListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ViaConnectionListener
implements DmQueueManagerListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/listeners/ViaConnectionListener.java";
    private IViaConnectionListener viaListener;
    private boolean connected;
    private int timeoutValue = 5;
    private BusyDialog busyDialog = null;

    public ViaConnectionListener(IViaConnectionListener listener) {
        this.viaListener = listener;
        this.connected = false;
    }

    public ViaConnectionListener(IViaConnectionListener listener, int timeout) {
        this.viaListener = listener;
        this.connected = false;
        this.timeoutValue = timeout;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void connect(Trace t, final DmQueueManager qmgr, final String qmname, final UiClusterQueueManager uiClusQm) {
        final ViaConnectionListener listener = this;
        final DmQueueManager theQmgr = qmgr;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace t2 = Trace.getDefault();
                Shell shell = Display.getDefault().getActiveShell();
                String msg = Message.format((String)ClusterPlugin.getResourceString("UI.CONT.AttemptViaConnection"), (String)qmgr.getTitle());
                ViaConnectionListener.this.busyDialog = new BusyDialog(shell, msg);
                String qmid = uiClusQm.getClusterQueueManagerIdAttr();
                DmQueueManager dmQmgr = null;
                if (qmid != null && qmid != "") {
                    if (Trace.isTracing) {
                        t2.data(66, "ViaConnectionListener.connect.run", 300, "Trying to locate a qmgr with UUID: " + qmid);
                    }
                    if ((dmQmgr = CoreServices.getMatchingQueueManager((Trace)t2, (String)qmid, (boolean)false)) != null) {
                        if (Trace.isTracing) {
                            t2.data(66, "ViaConnectionListener.connect.run", 300, "Found dm queue manager: " + dmQmgr.toString(t2));
                        }
                        if (!dmQmgr.connectSynchronously(t2)) {
                            if (Trace.isTracing) {
                                t2.data(66, "ViaConnectionListener.connect.run", 300, "Failed to connect, try to create a new Via connection instead");
                            }
                            dmQmgr = null;
                        }
                    }
                }
                if (dmQmgr == null) {
                    if (Trace.isTracing) {
                        t2.data(66, "ViaConnectionListener.connect.run", 300, "Trying to create a new via connection to " + qmname + " via " + theQmgr.toString(t2));
                    }
                    UiPlugin.getTheDataModel().addQueueManagerAndObserver(t2, theQmgr, "SYSTEM.ADMIN.COMMAND.QUEUE", qmname, ViaConnectionListener.this.timeoutValue, true, true, listener);
                    ViaConnectionListener.this.showBusyDialog(t2);
                }
            }
        });
    }

    private void showBusyDialog(Trace t) {
        this.busyDialog.showDialog(t);
    }

    private void closeBusyDialog(Trace t) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace t2 = Trace.getDefault();
                ViaConnectionListener.this.busyDialog.closeDialog(t2);
            }
        });
    }

    private void disconnect(Trace t) {
        UiPlugin.getTheDataModel().deleteObserver(t, (DmObjectListener)this);
    }

    public void dmQueueManagerShown(DmObjectEvent event) {
    }

    public void dmQueueManagerHidden(DmObjectEvent event) {
    }

    public void dmQueueManagerConnected(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        ClusterFactory factory = ClusterFactory.getDefault();
        DmQueueManager qmgr = (DmQueueManager)event.getSource();
        factory.createProvider(t, qmgr);
        this.closeBusyDialog(t);
        DmQueueManagerHandle dmqmh = qmgr.getConnectionHandle();
        Object job = dmqmh.beginUpdate(t);
        dmqmh.setAttributeValue(t, job, 11005, 0, (Object)0);
        dmqmh.actionChange(t, null, job, false);
        this.connected = true;
        this.disconnect(t);
        this.viaListener.viaConnectionNotification(t, event);
        qmgr.notifyListeners(t);
    }

    public void dmQueueManagerDisconnected(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        this.closeBusyDialog(t);
        this.connected = false;
        this.disconnect(t);
        this.viaListener.viaConnectionNotification(t, event);
    }

    public void dmQueueManagerConnecting(DmObjectEvent event) {
    }

    public void dmObjectAdded(DmObjectEvent event) {
    }

    public void dmObjectChanged(DmObjectEvent event) {
    }

    public void dmObjectDeleted(DmObjectEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }
}

