/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.listeners;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.listeners.INamelistNamesListener;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.objects.DmNamelist;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import java.util.ArrayList;

public class NamelistNamesListener
implements DmObjectListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/listeners/NamelistNamesListener.java";
    private DmQueueManager theQmgr = null;
    private INamelistNamesListener iParty = null;
    private DmObjectFilter filter = null;

    public NamelistNamesListener(Trace t, INamelistNamesListener party, DmQueueManager qmgr, String namelistname) {
        this.theQmgr = qmgr;
        this.iParty = party;
        this.filter = new DmObjectFilter(t, namelistname, 36);
    }

    private String[] extractNames(Trace t, DmNamelist namelist) {
        String[] names = null;
        Attr attr = namelist.getAttribute(t, 2020, 0);
        if (attr != null) {
            ArrayList clusters = (ArrayList)attr.getValue(t);
            names = new String[clusters.size()];
            int idx = 0;
            while (idx < names.length) {
                names[idx] = new String(((String)clusters.get(idx)).trim());
                ++idx;
            }
        }
        return names;
    }

    public void beginListener(Trace t) {
        this.theQmgr.addObserver(t, (DmObjectListener)this, this.filter);
    }

    public void stopListener(Trace t) {
        this.theQmgr.deleteObserver(t, (DmObjectListener)this);
    }

    public void dmObjectAdded(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        String[] names = null;
        DmNamelist namelist = (DmNamelist)event.getSource();
        names = this.extractNames(t, namelist);
        if (names != null) {
            this.iParty.initialNamesList(t, this.theQmgr, names);
        }
    }

    public void dmObjectChanged(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        String[] names = null;
        DmNamelist namelist = (DmNamelist)event.getSource();
        names = this.extractNames(t, namelist);
        if (names != null) {
            this.iParty.namesChanged(t, this.theQmgr, names);
        }
    }

    public void dmObjectDeleted(DmObjectEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }
}

