/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.listeners;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.factory.ClusterFactory;
import com.ibm.mq.explorer.clusterplugin.internal.listeners.INamelistNamesListener;
import com.ibm.mq.explorer.clusterplugin.internal.listeners.NamelistNamesListener;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ClusterObject;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.pcf.event.PCFFilter;
import java.util.ArrayList;
import java.util.Vector;

public class FieldChangeListener
implements DmObjectListener,
INamelistNamesListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/listeners/FieldChangeListener.java";
    private String repos = "";
    private String reposnl = "";
    private DmQueueManager theQmgr = null;
    private NamelistNamesListener namesListener = null;
    private Vector clusters = null;
    private PCFFilter pcfFilter = null;
    private DmObjectFilter filter = null;

    public FieldChangeListener(Trace t, DmQueueManager qmgr) {
        this.theQmgr = qmgr;
        this.clusters = new Vector();
        this.pcfFilter = new PCFFilter(2029, 18, "*");
        this.filter = new DmObjectFilter(t, 70, this.pcfFilter);
    }

    public void initialise(Trace t) {
        this.processChangeEvent(t, null);
    }

    public void addCluster(Trace t, ClusterObject cluster) {
        if (!this.clusters.contains(cluster)) {
            this.clusters.add(cluster);
        }
    }

    public void removeCluster(Trace t, ClusterObject cluster) {
        this.clusters.remove(cluster);
    }

    public Vector getClusters() {
        return this.clusters;
    }

    private void processChangeEvent(Trace t, DmObjectEvent event) {
        DmQueueManager qmgr = null;
        qmgr = event != null ? (DmQueueManager)event.getSource() : this.theQmgr;
        ClusterFactory factory = ClusterFactory.getDefault();
        String attrValue1 = qmgr.getAttributeValue(t, 2035, 0);
        String attrValue2 = qmgr.getAttributeValue(t, 2036, 0);
        if (!attrValue1.equals(this.repos)) {
            if (!this.repos.equals("") && !this.clusters.isEmpty()) {
                try {
                    ClusterObject cluster = (ClusterObject)this.clusters.get(0);
                    if (cluster.getProvider() == this.theQmgr) {
                        cluster.setInput(t, null);
                    }
                    this.removeCluster(t, cluster);
                    factory.deleteCluster(t, cluster);
                }
                catch (Exception e) {
                    t.FFST(66, "FieldChangeListener.processChangeEvent", 1, -1, "Exception during REPOS attribute change processing -" + e.getMessage());
                }
            }
            this.repos = attrValue1;
            if (!this.repos.equals("")) {
                String[] names = new String[]{this.repos.trim()};
                factory.namesChanged(t, qmgr, names);
            }
        }
        if (!attrValue2.equals(this.reposnl)) {
            if (this.namesListener != null) {
                this.namesListener.stopListener(t);
            }
            this.reposnl = attrValue2;
            if (!this.reposnl.equals("")) {
                this.namesListener = new NamelistNamesListener(t, this, this.theQmgr, this.reposnl);
                this.namesListener.beginListener(t);
            } else {
                int idx = this.clusters.size() - 1;
                while (idx >= 0) {
                    ClusterObject cluster = (ClusterObject)this.clusters.get(idx);
                    if (cluster.getProvider() == this.theQmgr) {
                        cluster.setInput(t, null);
                    }
                    this.removeCluster(t, cluster);
                    factory.deleteCluster(t, cluster);
                    --idx;
                }
            }
        }
    }

    public void dmObjectAdded(DmObjectEvent event) {
    }

    public void dmObjectChanged(DmObjectEvent event) {
        final Trace t = Trace.getDefault();
        final DmObjectEvent lEvent = event;
        new Thread(){

            @Override
            public void run() {
                FieldChangeListener.this.processChangeEvent(t, lEvent);
            }
        }.start();
    }

    public void dmObjectDeleted(DmObjectEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        if (this.repos.equals("") && this.reposnl.equals("")) {
            this.theQmgr.getObjects(t, (DmObjectListListener)this, this.filter);
        }
    }

    public void dmObjectListDone(DmObjectListEvent event) {
        Trace t = Trace.getDefault();
        ClusterFactory factory = ClusterFactory.getDefault();
        ArrayList list = event.getList();
        int idx = 0;
        while (idx < list.size()) {
            DmClusterQueueManager clusqmgr = (DmClusterQueueManager)list.get(idx);
            String clusname = clusqmgr.getAttributeValue(t, 2029, 0);
            factory.createCluster(t, this.theQmgr, clusname, false);
            ++idx;
        }
    }

    @Override
    public void namesChanged(Trace t, DmQueueManager qmgr, String[] names) {
        ClusterFactory factory = ClusterFactory.getDefault();
        this.removeClustersNoLongerInList(t, names);
        factory.namesChanged(t, qmgr, names);
    }

    @Override
    public void initialNamesList(Trace t, DmQueueManager qmgr, String[] names) {
        ClusterFactory factory = ClusterFactory.getDefault();
        this.removeClustersNoLongerInList(t, names);
        int idx1 = 0;
        while (idx1 < names.length) {
            factory.createCluster(t, qmgr, names[idx1]);
            ++idx1;
        }
    }

    private void removeClustersNoLongerInList(Trace t, String[] names) {
        ClusterFactory factory = ClusterFactory.getDefault();
        int idx1 = this.clusters.size() - 1;
        while (idx1 >= 0) {
            ClusterObject cluster = (ClusterObject)this.clusters.get(idx1);
            if (cluster.getProvider() == this.theQmgr) {
                boolean found = false;
                int idx2 = 0;
                while (idx2 < names.length) {
                    if (cluster.getClusterName().equals(names[idx2])) {
                        found = true;
                        break;
                    }
                    ++idx2;
                }
                if (!found) {
                    this.removeCluster(t, cluster);
                    factory.deleteCluster(t, cluster);
                }
            }
            --idx1;
        }
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    public String toString() {
        String s = "Cluster Component FieldChangeListener for " + this.theQmgr.getTitle();
        return s;
    }
}

