/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.factory;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.ClusterQueueManagerTreeNodeFactory;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.UiClusterQueueManager;
import com.ibm.mq.explorer.clusterplugin.internal.factory.ClusterFactory;
import com.ibm.mq.explorer.clusterplugin.internal.factory.ClusterTreeNodeFactory;
import com.ibm.mq.explorer.clusterplugin.internal.objects.BaseClusterObject;
import com.ibm.mq.explorer.clusterplugin.internal.treenodes.ClusterFolderTreeNode;
import com.ibm.mq.explorer.ui.extensions.ITreeNodeFactory;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;

public final class ExplorerTreeNodeFactory
implements IExecutableExtension,
ITreeNodeFactory {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/factory/ExplorerTreeNodeFactory.java";
    private static ExplorerTreeNodeFactory factory = null;
    private ClusterFolderTreeNode clusterFolder = null;
    private ClusterTreeNodeFactory clusterTreeNodeFactory = null;
    private ClusterQueueManagerTreeNodeFactory clusqmgrTreeNodeFactory = null;

    public ExplorerTreeNodeFactory() {
        factory = this;
    }

    public ClusterFolderTreeNode getRootNode() {
        return this.clusterFolder;
    }

    public static ExplorerTreeNodeFactory getDefault() {
        return factory;
    }

    public ClusterQueueManagerTreeNodeFactory getClusterQmgrFactory() {
        return this.clusqmgrTreeNodeFactory;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void addChildrenToTreeNode(TreeNode parent) {
        Trace t = Trace.getDefault();
        if (parent.getId().compareTo("com.ibm.mq.explorer.treenode.wmq") == 0 && this.clusterFolder == null) {
            this.clusterFolder = new ClusterFolderTreeNode(parent, new ClusterFactory());
            this.clusterTreeNodeFactory = new ClusterTreeNodeFactory(t, this.clusterFolder);
            this.clusqmgrTreeNodeFactory = new ClusterQueueManagerTreeNodeFactory(t);
            parent.addChildToNode((TreeNode)this.clusterFolder, 0);
        }
    }

    public void addCluster(Trace t, BaseClusterObject cluster) {
        if (this.clusterTreeNodeFactory != null) {
            this.clusterTreeNodeFactory.addNode(t, cluster);
            UiPlugin.asyncRefreshAllViews((Trace)t, null, (boolean)true);
        }
    }

    public void removeCluster(Trace t, BaseClusterObject cluster) {
        if (this.clusterTreeNodeFactory != null) {
            this.clusterTreeNodeFactory.removeNode(t, cluster);
        }
    }

    public void updateCluster(Trace t, BaseClusterObject cluster) {
        if (this.clusterTreeNodeFactory != null) {
            this.clusterTreeNodeFactory.updateNode(t, cluster);
        }
    }

    public void addClusterQueueManager(Trace t, UiClusterQueueManager uiObj, int repostype) {
        if (this.clusqmgrTreeNodeFactory != null) {
            this.clusqmgrTreeNodeFactory.addNode(t, uiObj);
        }
    }

    public void delClusterQueueManager(Trace t, UiClusterQueueManager uiObj, int repostype) {
        if (this.clusqmgrTreeNodeFactory != null) {
            this.clusqmgrTreeNodeFactory.removeNode(t, uiObj);
        }
    }

    public void updateClusterQueueManager(Trace t, UiClusterQueueManager uiObj) {
        if (this.clusqmgrTreeNodeFactory != null) {
            this.clusqmgrTreeNodeFactory.updateNode(t, uiObj);
        }
    }
}

