/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.factory;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.objects.BaseClusterObject;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ClusterObject;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ClusterQueueManagerFolder;
import com.ibm.mq.explorer.clusterplugin.internal.treenodes.AddTreeNodeRunnable;
import com.ibm.mq.explorer.clusterplugin.internal.treenodes.ClusterObjectTreeNode;
import com.ibm.mq.explorer.clusterplugin.internal.treenodes.ClusterQueueManagerFolderTreeNode;
import com.ibm.mq.explorer.clusterplugin.internal.treenodes.RemoveTreeNodeRunnable;
import com.ibm.mq.explorer.clusterplugin.internal.treenodes.UpdateTreeNodeRunnable;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.widgets.Display;

public final class ClusterTreeNodeFactory
implements IExecutableExtension {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/factory/ClusterTreeNodeFactory.java";
    private TreeNode parentNode = null;

    public ClusterTreeNodeFactory(Trace t, TreeNode parent) {
        this.parentNode = parent;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void addNode(Trace t, BaseClusterObject cluster) {
        TreeNode node = cluster.getTreeNode();
        if (node == null) {
            node = new ClusterObjectTreeNode(t, this.parentNode, cluster);
            cluster.setTreeNode(node);
            Display.getDefault().asyncExec((Runnable)new AddTreeNodeRunnable(t, this.parentNode, node));
            if (cluster instanceof ClusterObject) {
                ClusterObject clus = (ClusterObject)cluster;
                ClusterQueueManagerFolder fullobj = clus.getFullRepositoryContainer();
                ClusterQueueManagerFolderTreeNode fullnode = new ClusterQueueManagerFolderTreeNode(t, node, fullobj, 1);
                fullobj.setTreeNode(fullnode);
                Display.getDefault().asyncExec((Runnable)new AddTreeNodeRunnable(t, node, fullnode));
                ClusterQueueManagerFolder partobj = clus.getPartRepositoryContainer();
                ClusterQueueManagerFolderTreeNode partnode = new ClusterQueueManagerFolderTreeNode(t, node, partobj, 2);
                partobj.setTreeNode(partnode);
                Display.getDefault().asyncExec((Runnable)new AddTreeNodeRunnable(t, node, partnode));
            }
        }
    }

    public void removeNode(Trace t, BaseClusterObject cluster) {
        TreeNode node = cluster.getTreeNode();
        if (node != null) {
            Display.getDefault().asyncExec((Runnable)new RemoveTreeNodeRunnable(t, this.parentNode, node));
            cluster.setTreeNode(null);
        }
    }

    public void updateNode(Trace t, BaseClusterObject cluster) {
        TreeNode node = cluster.getTreeNode();
        if (node != null) {
            Display.getDefault().asyncExec((Runnable)new UpdateTreeNodeRunnable(t, node));
        }
    }
}

