/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.factory;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterInformationProvider;
import com.ibm.mq.explorer.clusterplugin.internal.actions.GetListeners;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.UiClusterQueueManager;
import com.ibm.mq.explorer.clusterplugin.internal.factory.ExplorerTreeNodeFactory;
import com.ibm.mq.explorer.clusterplugin.internal.objects.BaseClusterObject;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ClusterObject;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ClusterQueueManagerFolder;
import com.ibm.mq.explorer.clusterplugin.internal.objects.IClusterObject;
import com.ibm.mq.explorer.clusterplugin.internal.objects.OptimisticCluster;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.objects.DmListenerStatus;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;

public class ClusterFactory
extends MQExtObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/factory/ClusterFactory.java";
    private Vector<ClusterInformationProvider> providers = new Vector();
    private static ClusterFactory clusterFactory = null;
    private Vector<ClusterObject> clusters = new Vector();
    private Vector<OptimisticCluster> knownClusters = new Vector();
    private ExplorerTreeNodeFactory treeFactory = ExplorerTreeNodeFactory.getDefault();
    private static Object provlock = null;
    private static Object cluslock = null;

    public ClusterFactory() {
        super(null, null, "com.ibm.mq.explorer.clusterplugin.internal.factory.ClustersFactory", "com.ibm.mq.explorer.clusterplugin.id.objectid.root", "Queue Manager Clusters");
        provlock = new Object();
        cluslock = new Object();
        clusterFactory = this;
    }

    public static ClusterFactory getDefault() {
        return clusterFactory;
    }

    public void pluginDisabled(Trace t) {
        if (this.providers != null) {
            int idx = this.providers.size() - 1;
            while (idx >= 0) {
                ClusterInformationProvider provider = this.providers.get(idx);
                DmQueueManager qmgr = provider.getProvider();
                this.deleteProvider(t, qmgr);
                --idx;
            }
        }
    }

    public void ProcessQueueManagerEvent(Trace t, DmObjectEvent event) {
        DmQueueManager qmgr = (DmQueueManager)event.getSource();
        if (qmgr.getPlatform() != 27) {
            switch (event.getEventType()) {
                case 100: 
                case 103: {
                    this.createProvider(t, qmgr);
                    break;
                }
                case 101: 
                case 102: {
                    this.deleteProvider(t, qmgr);
                }
            }
        }
    }

    public Vector<ClusterObject> getClusters() {
        return this.clusters;
    }

    public ArrayList<String> getClusterNames(Trace t) {
        ArrayList<String> clusternames = new ArrayList<String>();
        int idx = 0;
        while (idx < this.clusters.size()) {
            clusternames.add(((IClusterObject)this.clusters.get(idx)).getClusterName());
            ++idx;
        }
        return clusternames;
    }

    public DmQueueManager getAnyProviderForCluster(Trace t, BaseClusterObject cluster) {
        DmQueueManager altQueueManager = null;
        ClusterInformationProvider provider = null;
        int idx = 0;
        while (idx < this.providers.size()) {
            ClusterInformationProvider nextProvider = this.providers.get(idx);
            if (nextProvider.contains(t, (ClusterObject)cluster)) {
                provider = nextProvider;
                break;
            }
            ++idx;
        }
        if (provider != null) {
            altQueueManager = provider.getProvider();
        }
        return altQueueManager;
    }

    public void createCluster(Trace t, DmQueueManager qmgr, String clusname) {
        this.createCluster(t, qmgr, clusname, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCluster(Trace t, DmQueueManager qmgr, String clusname, boolean isFullRepository) {
        Object object = cluslock;
        synchronized (object) {
            if (isFullRepository) {
                ClusterObject cluster;
                OptimisticCluster clus = this.getKnownCluster(t, clusname);
                if (clus != null) {
                    this.treeFactory.removeCluster(t, clus);
                    this.knownClusters.remove(clus);
                }
                if ((cluster = this.getCluster(t, clusname)) == null) {
                    cluster = (ClusterObject)this.create(t, clusname, isFullRepository);
                    this.treeFactory.addCluster(t, cluster);
                    cluster.setInput(t, qmgr);
                } else if (cluster.getProvider() == null) {
                    cluster.setInput(t, qmgr);
                }
                ClusterInformationProvider infProvider = this.contains(t, qmgr);
                infProvider.addCluster(t, cluster);
            } else {
                OptimisticCluster clus = null;
                ClusterObject cluster = this.getCluster(t, clusname);
                if (cluster == null && (clus = this.getKnownCluster(t, clusname)) == null) {
                    clus = (OptimisticCluster)this.create(t, clusname, isFullRepository);
                    this.treeFactory.addCluster(t, clus);
                    clus.setInput(t, qmgr);
                }
            }
        }
    }

    public void deleteCluster(Trace t, BaseClusterObject cluster) {
        this.deleteCluster(t, cluster, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCluster(Trace t, BaseClusterObject cluster, boolean isFullRepositroy) {
        Object object = cluslock;
        synchronized (object) {
            if (cluster instanceof ClusterObject) {
                boolean found = false;
                int idx = 0;
                while (idx < this.providers.size()) {
                    ClusterInformationProvider infProvider = this.providers.get(idx);
                    if (infProvider.contains(t, (ClusterObject)cluster)) {
                        found = true;
                        break;
                    }
                    ++idx;
                }
                if (!found) {
                    this.treeFactory.removeCluster(t, cluster);
                    this.clusters.remove(cluster);
                }
            } else {
                this.treeFactory.removeCluster(t, cluster);
                this.knownClusters.remove(cluster);
            }
        }
    }

    private ClusterInformationProvider contains(Trace t, DmQueueManager qmgr) {
        ClusterInformationProvider provider = null;
        int idx = 0;
        while (idx < this.providers.size()) {
            ClusterInformationProvider nextProvider = this.providers.get(idx);
            if (nextProvider.getProvider() == qmgr) {
                provider = nextProvider;
                break;
            }
            ++idx;
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterInformationProvider createProvider(Trace t, DmQueueManager qmgr) {
        ClusterInformationProvider provider = null;
        Object object = provlock;
        synchronized (object) {
            provider = this.contains(t, qmgr);
            if (provider == null) {
                provider = new ClusterInformationProvider(t, qmgr);
                this.providers.add(provider);
                provider.beginListener(t);
            } else {
                provider.beginListener(t);
            }
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProvider(Trace t, DmQueueManager qmgr) {
        Object object = cluslock;
        synchronized (object) {
            ClusterInformationProvider provider = this.contains(t, qmgr);
            if (provider != null) {
                BaseClusterObject cluster;
                Vector clusvect = provider.getClusters(t);
                int idx = clusvect.size() - 1;
                while (idx >= 0) {
                    cluster = (ClusterObject)clusvect.get(idx);
                    if (cluster.getProvider() == qmgr) {
                        ((ClusterObject)cluster).setInput(t, null);
                    }
                    provider.removeCluster(t, (ClusterObject)cluster);
                    this.deleteCluster(t, cluster);
                    --idx;
                }
                idx = this.knownClusters.size() - 1;
                while (idx >= 0) {
                    cluster = this.knownClusters.get(idx);
                    if (cluster.getProvider() == qmgr) {
                        ((OptimisticCluster)cluster).setInput(t, null);
                        this.treeFactory.removeCluster(t, cluster);
                        this.knownClusters.remove(cluster);
                    }
                    --idx;
                }
                this.providers.remove(provider);
                provider.endListener(t);
            }
        }
    }

    private BaseClusterObject create(Trace t, String clusname, boolean isFulRepository) {
        BaseClusterObject cluster = null;
        if (isFulRepository) {
            ClusterObject clus = new ClusterObject(this, null, "", "", clusname);
            this.clusters.add(clus);
            cluster = clus;
        } else {
            OptimisticCluster clus = new OptimisticCluster(this, null, "", "", clusname);
            this.knownClusters.add(clus);
            cluster = clus;
        }
        return cluster;
    }

    public ClusterObject getCluster(Trace t, String clusname) {
        ClusterObject cluster = null;
        int idx = 0;
        while (idx < this.clusters.size()) {
            ClusterObject clus = this.clusters.get(idx);
            if (clusname.equals(clus.getClusterName())) {
                cluster = clus;
                break;
            }
            ++idx;
        }
        return cluster;
    }

    public OptimisticCluster getKnownCluster(Trace t, String clusname) {
        OptimisticCluster cluster = null;
        int idx = 0;
        while (idx < this.knownClusters.size()) {
            OptimisticCluster clus = this.knownClusters.get(idx);
            if (clusname.equals(clus.getClusterName())) {
                cluster = clus;
                break;
            }
            ++idx;
        }
        return cluster;
    }

    public UiClusterQueueManager[] getFullRepositoriesForCluster(Trace t, String clusname) {
        int size = 0;
        UiClusterQueueManager[] members = null;
        ArrayList<UiClusterQueueManager> list = null;
        ClusterObject cluster = this.getCluster(t, clusname);
        if (cluster != null) {
            list = cluster.getFullRepositoryContainer().getClusterQueueManagers();
            size = list.size();
            members = list.toArray(new UiClusterQueueManager[size]);
        } else {
            members = new UiClusterQueueManager[]{};
        }
        return members;
    }

    public void namesChanged(Trace t, DmQueueManager qmgr, String[] names) {
        int idx1 = 0;
        while (idx1 < names.length) {
            this.createCluster(t, qmgr, names[idx1]);
            ++idx1;
        }
    }

    private ArrayList<UiQueueManager> getPotentialQueueManagersForCluster(Trace t, String clusname) {
        ArrayList<UiQueueManager> possibilities = new ArrayList<UiQueueManager>();
        UiQueueManager[] knownQueueManagers = UiPlugin.getKnownUiQueueManagers((Trace)t, (boolean)false);
        ClusterObject cluster = this.getCluster(t, clusname);
        int idx = 0;
        while (idx < knownQueueManagers.length) {
            UiQueueManager uiqmgr = knownQueueManagers[idx];
            DmQueueManager qmgr = uiqmgr.getDmQueueManagerObject();
            if (qmgr != null && qmgr.isConnected()) {
                possibilities.add(uiqmgr);
            }
            ++idx;
        }
        if (cluster != null) {
            ArrayList<UiClusterQueueManager> allClusterQueueManagers = new ArrayList<UiClusterQueueManager>();
            allClusterQueueManagers.addAll(cluster.getFullRepositoryContainer().getClusterQueueManagers());
            allClusterQueueManagers.addAll(cluster.getPartRepositoryContainer().getClusterQueueManagers());
            int idx1 = 0;
            while (idx1 < allClusterQueueManagers.size()) {
                UiClusterQueueManager uiObj = (UiClusterQueueManager)((Object)allClusterQueueManagers.get(idx1));
                DmQueueManager qmgr = uiObj.getRealQueueManager(t);
                if (qmgr != null) {
                    int idx2 = 0;
                    while (idx2 < knownQueueManagers.length) {
                        UiQueueManager uiqmgr = knownQueueManagers[idx2];
                        DmQueueManager testqmgr = uiqmgr.getDmQueueManagerObject();
                        if (testqmgr == qmgr) {
                            if (!possibilities.contains(uiqmgr)) break;
                            possibilities.remove(uiqmgr);
                            break;
                        }
                        ++idx2;
                    }
                }
                ++idx1;
            }
        }
        return possibilities;
    }

    public UiQueueManager[] getQueueManagersNotInCluster(Trace t, String clusname) {
        ArrayList<UiQueueManager> possibilities = this.getPotentialQueueManagersForCluster(t, clusname);
        UiQueueManager[] list = new UiQueueManager[possibilities.size()];
        possibilities.toArray(list);
        return list;
    }

    public UiQueueManager[] getSuitableRepositoryQueueManagers(Trace t, String clusname) {
        ArrayList<UiQueueManager> possibilities = this.getPotentialQueueManagersForCluster(t, clusname);
        int idx = possibilities.size() - 1;
        while (idx >= 0) {
            UiQueueManager uiObj = possibilities.get(idx);
            DmQueueManager dmObj = uiObj.getDmQueueManagerObject();
            String reposnlAttr = dmObj.getAttributeValue(t, 2036, 0);
            String reposAttr = dmObj.getAttributeValue(t, 2035, 0);
            if (!reposnlAttr.equals("") || !reposAttr.equals("")) {
                possibilities.remove(uiObj);
            }
            --idx;
        }
        UiQueueManager[] list = new UiQueueManager[possibilities.size()];
        possibilities.toArray(list);
        return list;
    }

    public boolean isProviderOfCluster(Trace t, DmQueueManager qmgr) {
        boolean isProvider = false;
        int idx = 0;
        while (idx < this.clusters.size()) {
            ClusterObject cluster = this.clusters.get(idx);
            if (cluster.getProvider() == qmgr) {
                isProvider = true;
                break;
            }
            ++idx;
        }
        return isProvider;
    }

    public boolean isMemberOfCluster(Trace t, DmQueueManager qmgr) {
        String compareId = qmgr.getAttributeValue(t, 2032, 0);
        boolean isMember = false;
        int idx1 = 0;
        while (idx1 < this.clusters.size()) {
            ClusterObject cluster = this.clusters.get(idx1);
            ClusterQueueManagerFolder[] repos = new ClusterQueueManagerFolder[]{cluster.getFullRepositoryContainer(), cluster.getPartRepositoryContainer()};
            int idx2 = 0;
            while (idx2 < repos.length) {
                ArrayList<UiClusterQueueManager> members = repos[idx2].getClusterQueueManagers();
                int idx3 = 0;
                while (idx3 < members.size()) {
                    UiClusterQueueManager uiObj = members.get(idx3);
                    String uuid = uiObj.getClusterQueueManagerIdAttr();
                    if (uuid.equals(compareId)) {
                        isMember = true;
                        break;
                    }
                    ++idx3;
                }
                if (isMember) break;
                ++idx2;
            }
            if (isMember) break;
            ++idx1;
        }
        return isMember;
    }

    public ArrayList getListeners(Trace t, UiQueueManager qmgr, IWizard wizard) {
        GetListeners getListenersAction;
        ArrayList listenersArray;
        block4: {
            listenersArray = new ArrayList();
            getListenersAction = new GetListeners();
            getListenersAction.init(qmgr);
            try {
                boolean forkable = true;
                boolean cancelable = false;
                wizard.getContainer().run(forkable, cancelable, (IRunnableWithProgress)getListenersAction);
            }
            catch (InvocationTargetException e) {
                if (Trace.isTracing) {
                    t.data(66, "ClusterFactory.getListeners", 900, "Exception occurred when trying to obtain a list of active listeners: " + e.getMessage());
                }
            }
            catch (InterruptedException e) {
                if (!Trace.isTracing) break block4;
                t.data(66, "ClusterFactory.getListeners", 900, "Exception occurred when trying to obtain a list of active listeners: " + e.getMessage());
            }
        }
        listenersArray = getListenersAction.getListeners();
        return listenersArray;
    }

    public ArrayList getConnectionListForLocalQM(Trace t, ArrayList listenersArray) {
        String hostname;
        ArrayList<Object> connectionsList;
        block2: {
            connectionsList = new ArrayList();
            InetAddress localhost = null;
            hostname = "";
            try {
                localhost = InetAddress.getLocalHost();
                hostname = localhost.getHostName();
            }
            catch (UnknownHostException e1) {
                if (!Trace.isTracing) break block2;
                t.data(66, "ClusterFactory.getConnectionListForLocalQM", 900, "Exception occurred when trying to obtain the hostname: " + e1.getMessage());
            }
        }
        connectionsList = this.createConnectionsList(t, hostname, listenersArray);
        return connectionsList;
    }

    private ArrayList<String> createConnectionsList(Trace t, String hostname, ArrayList listenersArray) {
        ArrayList<String> tcpConnectionList = new ArrayList<String>();
        String tcpConnection = "";
        if (!hostname.equals("")) {
            int idx = 0;
            while (idx < listenersArray.size()) {
                DmListenerStatus listener = (DmListenerStatus)listenersArray.get(idx);
                AttrInt attr = (AttrInt)listener.getAttribute(t, 1522, 0);
                if (attr != null) {
                    Integer port = (Integer)attr.getValue(t);
                    int number = port;
                    tcpConnection = String.valueOf(hostname) + "(" + number + ")";
                    tcpConnectionList.add(tcpConnection);
                }
                ++idx;
            }
        }
        return tcpConnectionList;
    }

    public ArrayList<String> getConnectionListForRemoteQM(Trace t, ArrayList listenersArray, UiQueueManager qmgr) {
        ArrayList<String> connectionList = new ArrayList<String>();
        DmQueueManager dmQueueManager = qmgr.getDmQueueManagerObject();
        DmQueueManagerHandle dmQueueManagerHandle = null;
        QueueManagerHandle queueManagerHandle = null;
        String hostName = "";
        if (dmQueueManager != null) {
            dmQueueManagerHandle = dmQueueManager.getConnectionHandle();
        }
        if (dmQueueManagerHandle != null) {
            queueManagerHandle = dmQueueManagerHandle.getQueueManagerHandle(t);
        }
        if (queueManagerHandle != null && (dmQueueManagerHandle.isConnectionTypeClient(t) || dmQueueManagerHandle.isConnectionTypeMultiInstance(t))) {
            hostName = queueManagerHandle.getHostName(t);
            if (dmQueueManager.isZos()) {
                connectionList.add(queueManagerHandle.getConnectionName());
            }
        }
        if (!dmQueueManager.isZos()) {
            connectionList = this.createConnectionsList(t, hostName, listenersArray);
        }
        return connectionList;
    }
}

