/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.content;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.UiClusterQueueManager;
import com.ibm.mq.explorer.clusterplugin.internal.content.BaseCanvas;
import com.ibm.mq.explorer.clusterplugin.internal.content.BaseQmgrObjectContentPageTab;
import com.ibm.mq.explorer.clusterplugin.internal.content.CanvasSenderImageProvider;
import com.ibm.mq.explorer.clusterplugin.internal.content.ExplorerTableForSenders;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedListener;
import com.ibm.mq.explorer.ui.internal.views.ExplorerViewPart;
import java.util.ArrayList;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;

public final class QmgrObjectContentPageSenderTab
extends BaseQmgrObjectContentPageTab
implements ExplorerTableContentChangedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/content/QmgrObjectContentPageSenderTab.java";
    Combo destinationSelector;
    private ArrayList<UiClusterQueueManager> destinations = new ArrayList();
    SelectionListener sdrChanMenuListener;

    public QmgrObjectContentPageSenderTab(TabFolder folder, CanvasSenderImageProvider img, ExplorerViewPart viewPart) {
        super((Composite)folder);
        final Trace t = Trace.getDefault();
        this.imageProvider = img;
        this.setBackground(this.getBackground());
        this.setLayout((Layout)new FillLayout());
        this.destinations = new ArrayList();
        this.upperPage = new Composite((Composite)this, 2048);
        this.upperPage.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(this.upperPage, 0);
        label.setText(ClusterPlugin.getResourceString("UI.CHL.ClusSndChannels.Label"));
        GridData sndChanControl1Data = new GridData(3);
        label.setLayoutData((Object)sndChanControl1Data);
        this.destinationSelector = new Combo(this.upperPage, 12);
        GridData sndChanControl2Data = new GridData(770);
        sndChanControl2Data.grabExcessHorizontalSpace = true;
        sndChanControl2Data.horizontalSpan = 1;
        this.destinationSelector.setLayoutData((Object)sndChanControl2Data);
        this.canvas = new BaseCanvas(this.upperPage, this.imageProvider);
        GridData sndChanCanvasData = new GridData(1810);
        this.canvas.setLayoutData(sndChanCanvasData);
        this.lowerPage = new Composite((Composite)this, 2048);
        this.lowerPage.setLayout((Layout)new GridLayout(1, false));
        this.theTable = new ExplorerTableForSenders(t, this.lowerPage, this.canvas, viewPart);
        this.theTable.addContentChangedListener(t, this);
        this.imageProvider.setExplorerTable(this.theTable);
        this.setWeights(new int[]{25, 75});
        this.canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (QmgrObjectContentPageSenderTab.this.context != null) {
                    QmgrObjectContentPageSenderTab.this.canvas.redraw(t);
                }
            }
        });
        this.sdrChanMenuListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                if (QmgrObjectContentPageSenderTab.this.context != null) {
                    QmgrObjectContentPageSenderTab.this.onSenderChannelSelect(t2);
                }
            }
        };
        this.destinationSelector.addSelectionListener(this.sdrChanMenuListener);
    }

    private String[] buildSenderChannelsIndex(Trace t) {
        String[] listcontents = null;
        this.destinations.clear();
        UiClusterQueueManager[] objlist = this.theTable.getObjectsAsUiArray(t);
        int idx1 = 0;
        while (idx1 < objlist.length) {
            UiClusterQueueManager uiObj = objlist[idx1];
            String uuid = uiObj.getClusterQueueManagerIdAttr();
            boolean found = false;
            int idx2 = 0;
            while (idx2 < this.destinations.size()) {
                UiClusterQueueManager nextuiObj = this.destinations.get(idx2);
                if (nextuiObj.getClusterQueueManagerIdAttr().equalsIgnoreCase(uuid)) {
                    found = true;
                    break;
                }
                ++idx2;
            }
            if (!found) {
                this.destinations.add(uiObj);
            }
            listcontents = new String[this.destinations.size()];
            int idx = 0;
            while (idx < this.destinations.size()) {
                String label = "";
                UiClusterQueueManager nextQmgr = this.destinations.get(idx);
                String qmname = nextQmgr.getClusterQueueManagerNameAttr();
                label = nextQmgr.isFullRepository(t) ? String.valueOf(qmname) + ClusterPlugin.getResourceString("UI.CHL.FullRepository.Menu") : String.valueOf(qmname) + ClusterPlugin.getResourceString("UI.CHL.PartialRepository.Menu");
                listcontents[idx] = label;
                ++idx;
            }
            ++idx1;
        }
        return listcontents;
    }

    void onSenderChannelSelect(Trace t) {
        int index = this.destinationSelector.getSelectionIndex();
        if (index != -1) {
            UiClusterQueueManager destinationobj = this.destinations.get(index);
            int totalChannels = ((CanvasSenderImageProvider)this.imageProvider).getChannelCount(t, destinationobj);
            this.canvas.setUiObject2(t, destinationobj, totalChannels);
        }
    }

    public void contentChanged(ExplorerTableContentChangedEvent event) {
        Trace t = Trace.getDefault();
        final String[] newmenucontents = this.buildSenderChannelsIndex(t);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Trace t2 = Trace.getDefault();
                QmgrObjectContentPageSenderTab.this.destinationSelector.removeAll();
                if (newmenucontents != null) {
                    QmgrObjectContentPageSenderTab.this.destinationSelector.setItems(newmenucontents);
                    QmgrObjectContentPageSenderTab.this.destinationSelector.select(0);
                    QmgrObjectContentPageSenderTab.this.onSenderChannelSelect(t2);
                }
            }
        });
    }
}

