/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.content;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.UiClusterQueueManager;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ClusterObject;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ClusterQueueManagerFolder;
import com.ibm.mq.explorer.ui.extensions.ContentPage;
import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import java.util.ArrayList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class ClusterQueueManagerFolderContentPage
extends ContentPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/content/ClusterQueueManagerFolderContentPage.java";
    private ClusterQueueManagerFolder repositoryFolder = null;
    private ContentTitleBar contentTitleBar;
    private String reposFolderInstanceId = "com.ibm.mq.explorer.clusterplugin.internal.repos.folder";
    private ExplorerTable repositoriesTable = null;

    public ClusterQueueManagerFolderContentPage(Composite parent, int style) {
        super(parent, style);
    }

    public void init() {
        Trace t = Trace.getDefault();
        GridData gridData = null;
        Label label = null;
        FillLayout fillLayout = new FillLayout();
        this.setLayout((Layout)fillLayout);
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this, 768);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)gridData);
        this.contentTitleBar = new ContentTitleBar(composite, 0);
        gridData = new GridData(768);
        gridData.heightHint = 30;
        this.contentTitleBar.setLayoutData((Object)gridData);
        label = new Label(composite, 2048);
        gridData = new GridData(768);
        gridData.heightHint = 0;
        label.setLayoutData((Object)gridData);
        this.repositoriesTable = new ExplorerTable(t, composite, 65540, ClusterPlugin.getResourceString(""), false, true, true, false, null);
        this.repositoriesTable.setObjectId(t, "com.ibm.mq.explorer.clusterqueuemanager");
        this.repositoriesTable.setAttributeOrderId(t, "com.ibm.mq.explorer.orderid.clusterqueuemanagers");
        AttributeOrderManager attrOrderManager = UiPlugin.getAttributeOrderManager();
        attrOrderManager.setSelectedAttrOrder(t, "com.ibm.mq.explorer.orderid.clusterqueuemanagers", this.reposFolderInstanceId, "com.ibm.mq.explorer.scheme.uid.clusterreposqueuemanager", false, false);
        this.repositoriesTable.setInstance(t, this.reposFolderInstanceId, false);
        gridData = new GridData(1810);
        this.repositoriesTable.setLayoutData((Object)gridData);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        composite.layout();
    }

    public void updatePage() {
        Trace t = Trace.getDefault();
        if (this.repositoryFolder == null) {
            return;
        }
        this.repositoriesTable.removeAll(t);
        ArrayList<UiClusterQueueManager> list = this.repositoryFolder.getClusterQueueManagers();
        int idx = 0;
        while (idx < list.size()) {
            UiClusterQueueManager nextQmgr = list.get(idx);
            TreeNode node = nextQmgr.getTreeNode();
            if (node != null && node.isVisible()) {
                this.repositoriesTable.addTableItem(t, (UiMQObject)nextQmgr);
            }
            ++idx;
        }
    }

    public String getId() {
        return "com.ibm.mq.explorer.clusterplugin.id.pageid.repository";
    }

    public void setObject(MQExtObject object) {
        this.repositoryFolder = (ClusterQueueManagerFolder)object;
        String contentTitle = "";
        ClusterObject cluster = (ClusterObject)this.repositoryFolder.getParent();
        if (this.repositoryFolder.getFolderInstance() == 0) {
            contentTitle = Message.format((String)ClusterPlugin.getResourceString("UI.CONT.FullRepository.Title"), (String)cluster.getClusterName());
            this.contentTitleBar.setText(ClusterPlugin.getResourceString(contentTitle));
            UiPlugin.getHelpSystem().setHelp((Control)this, "com.ibm.mq.explorer.ui.infopop.UI_FullRepositoriesContentPage");
        } else {
            contentTitle = Message.format((String)ClusterPlugin.getResourceString("UI.CONT.PartialRepository.Title"), (String)cluster.getClusterName());
            this.contentTitleBar.setText(ClusterPlugin.getResourceString(contentTitle));
            UiPlugin.getHelpSystem().setHelp((Control)this, "com.ibm.mq.explorer.ui.infopop.UI_PartialRepositoriesContentPage");
        }
    }

    public void refresh() {
    }

    public boolean isEnableRefreshAction() {
        return true;
    }

    public void repaint() {
    }

    public void instanceDeleted(Object object) {
    }

    public boolean isEnableSystemObjectsAction() {
        return false;
    }

    public void showSystemObjects(boolean show) {
    }
}

