/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.content;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.clusterplugin.extensions.MQClusterQmgrExtObject;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.UiClusterQueueManager;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.UiClusterQueueManagerFactory;
import com.ibm.mq.explorer.clusterplugin.internal.factory.ClusterFactory;
import com.ibm.mq.explorer.clusterplugin.internal.filters.AlternativeSourceProvider;
import com.ibm.mq.explorer.clusterplugin.internal.filters.ExplicitClusterSenderChannels;
import com.ibm.mq.explorer.clusterplugin.internal.objects.BaseClusterObject;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ClusterObject;
import com.ibm.mq.explorer.clusterplugin.internal.objects.OptimisticCluster;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ProviderChangedEvent;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ProviderChangedListener;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.AddQmgrWiz;
import com.ibm.mq.explorer.qmgradmin.internal.qmgrs.AddQmgrWizDlg;
import com.ibm.mq.explorer.ui.extensions.ContentPage;
import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.SelectUiMQObjectDialog;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import com.ibm.mq.pcf.event.PCFFilter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class ClusterObjectContentPage
extends ContentPage
implements ProviderChangedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/content/ClusterObjectContentPage.java";
    BaseClusterObject clusterObject = null;
    private Button buttonSelectQueueManager;
    Group clusterInfoSourceBox;
    Text clusterInfoMessage;
    private ContentTitleBar contentTitleBar;
    Composite parentComposite;
    Composite additions;
    Composite composite;
    private Text reposQueueMgrTextbox;
    private static final int NUM_COLUMNS = 3;
    private static final int INITIAL_WIDTH = 400;
    private static final String DATASOURCEMSG = ClusterPlugin.getResourceString("UI.CONT.SelectFullRepos.Label");
    private ControlListener pageresizelistener = null;
    private SelectionListener selectqmgrlistener = null;

    public ClusterObjectContentPage(Composite parent, int style) {
        super(parent, style);
        this.parentComposite = parent;
    }

    public void init() {
        int myHeight;
        Trace t = Trace.getDefault();
        GridData gridData = null;
        Label label = null;
        FillLayout fillLayout = new FillLayout();
        this.setLayout((Layout)fillLayout);
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this, 768);
        this.composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.composite);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.verticalSpacing = 10;
        this.composite.setLayout((Layout)gridLayout);
        gridData = new GridData();
        this.composite.setLayoutData((Object)gridData);
        this.contentTitleBar = new ContentTitleBar(this.composite, 0);
        this.contentTitleBar.setText(ClusterPlugin.getResourceString("UI.CONT.ClusterName.Title"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 30;
        this.contentTitleBar.setLayoutData((Object)gridData);
        label = new Label(this.composite, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 0;
        label.setLayoutData((Object)gridData);
        label = new Label(this.composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 10;
        label.setLayoutData((Object)gridData);
        GridLayout boxLayout = new GridLayout(3, false);
        boxLayout.marginWidth = 10;
        boxLayout.marginHeight = 10;
        boxLayout.verticalSpacing = 15;
        GridData box1Data = new GridData(770);
        box1Data.grabExcessVerticalSpace = false;
        box1Data.verticalAlignment = 1;
        box1Data.horizontalSpan = 3;
        this.clusterInfoSourceBox = new Group(this.composite, 0);
        this.clusterInfoSourceBox.setLayout((Layout)boxLayout);
        this.clusterInfoSourceBox.setText(ClusterPlugin.getResourceString("UI.CONT.ClusInfo.Label"));
        this.clusterInfoSourceBox.setLayoutData((Object)box1Data);
        this.clusterInfoMessage = new Text((Composite)this.clusterInfoSourceBox, 64);
        this.clusterInfoMessage.setText(DATASOURCEMSG);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.clusterInfoMessage, (boolean)true);
        final GridData clusInfoMsgData = new GridData();
        clusInfoMsgData.horizontalAlignment = 1;
        clusInfoMsgData.horizontalSpan = 3;
        clusInfoMsgData.grabExcessHorizontalSpace = true;
        clusInfoMsgData.grabExcessVerticalSpace = false;
        clusInfoMsgData.widthHint = 400;
        clusInfoMsgData.heightHint = myHeight = this.clusterInfoMessage.computeSize((int)400, (int)-1).y;
        this.clusterInfoMessage.setLayoutData((Object)clusInfoMsgData);
        Label textboxLabel = new Label((Composite)this.clusterInfoSourceBox, 0);
        textboxLabel.setText(ClusterPlugin.getResourceString("UI.CONT.FullRepos.Label"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 2;
        textboxLabel.setLayoutData((Object)gridData);
        this.reposQueueMgrTextbox = new Text((Composite)this.clusterInfoSourceBox, 2056);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        this.reposQueueMgrTextbox.setLayoutData((Object)gridData);
        this.buttonSelectQueueManager = new Button((Composite)this.clusterInfoSourceBox, 8);
        this.buttonSelectQueueManager.setText(ClusterPlugin.getResourceString("UI.CONT.Select.Button"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 2;
        this.buttonSelectQueueManager.setLayoutData((Object)gridData);
        label = new Label(this.composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 5;
        label.setLayoutData((Object)gridData);
        Composite footer = new Composite(this.composite, 0);
        footer.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 3;
        gridData.horizontalSpan = 3;
        footer.setLayoutData((Object)gridData);
        this.additions = new Composite(footer, 0);
        GridLayout extLayout = new GridLayout(2, false);
        extLayout.horizontalSpacing = 0;
        extLayout.verticalSpacing = 0;
        extLayout.marginHeight = 0;
        extLayout.marginWidth = 0;
        this.additions.setLayout((Layout)extLayout);
        gridData = new GridData(776);
        gridData.horizontalSpan = 2;
        this.additions.setLayoutData((Object)gridData);
        UiPlugin.getHelpSystem().setHelp((Control)this, "com.ibm.mq.explorer.ui.infopop.UI_ClusterContentPage");
        this.pageresizelistener = new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                int newHeight;
                int newWidth;
                clusInfoMsgData.widthHint = newWidth = ClusterObjectContentPage.this.parentComposite.getSize().x - 60;
                clusInfoMsgData.heightHint = newHeight = ClusterObjectContentPage.this.clusterInfoMessage.computeSize((int)newWidth, (int)-1, (boolean)true).y;
                ClusterObjectContentPage.this.clusterInfoMessage.pack();
                ClusterObjectContentPage.this.clusterInfoMessage.redraw();
                ClusterObjectContentPage.this.clusterInfoSourceBox.pack();
                ClusterObjectContentPage.this.clusterInfoSourceBox.layout(true);
            }
        };
        this.parentComposite.addControlListener(this.pageresizelistener);
        this.selectqmgrlistener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                ClusterObjectContentPage.this.perforObjectmSelection(t2);
            }
        };
        this.buttonSelectQueueManager.addSelectionListener(this.selectqmgrlistener);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.composite.layout(true);
        scrolledComposite.setMinSize(this.composite.computeSize(-1, -1));
    }

    private void perforObjectmSelection(final Trace t) {
        String objectSelectDlgTitle = ClusterPlugin.getResourceString("UI.QMGRS.SelectConn.Wizard.Title");
        String objectSelectDlgDescription = ClusterPlugin.getResourceString("UI.QMGRS.SelectConn.Wizard.Description");
        String clusname = this.clusterObject.getClusterName();
        ViewerFilter viewFilter = null;
        PCFFilter pcfFilter = new PCFFilter(2029, 2, clusname);
        DmObjectFilter filter = new DmObjectFilter(t, "*", 70, pcfFilter);
        DmQueueManager provider = null;
        UiClusterQueueManager uiObj = null;
        SelectUiMQObjectDialog selDlg = new SelectUiMQObjectDialog(UiPlugin.getShell());
        selDlg.addViewerFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                MQClusterQmgrExtObject clusqmgrobj;
                Object obj;
                boolean show = true;
                if (element instanceof MQClusterQmgrExtObject && (obj = (clusqmgrobj = (MQClusterQmgrExtObject)((Object)element)).getInternalObject()) instanceof UiClusterQueueManager) {
                    UiClusterQueueManager uiClusQm = (UiClusterQueueManager)((Object)obj);
                    DmQueueManager dmQm = uiClusQm.getRealQueueManager(t);
                    if (dmQm != null) {
                        if (!dmQm.isVisible(t)) {
                            show = false;
                        }
                    } else {
                        show = false;
                    }
                }
                return show;
            }
        });
        if (this.clusterObject instanceof ClusterObject) {
            viewFilter = new AlternativeSourceProvider(this.clusterObject.getProvider());
        }
        if (this.clusterObject instanceof OptimisticCluster) {
            viewFilter = new ExplicitClusterSenderChannels();
        }
        if ((provider = this.clusterObject.getProvider()) != null) {
            selDlg.listenToDataModel(t, (IDmObservable)provider, 70, (IUiMQObjectFactory)new UiClusterQueueManagerFactory(null), (UiMQObject)this.clusterObject.getInternalObject());
            selDlg.setExplicitFilter(t, filter);
        } else {
            ClusterFactory factory = ClusterFactory.getDefault();
            provider = factory.getAnyProviderForCluster(t, this.clusterObject);
            if (provider != null) {
                selDlg.listenToDataModel(t, (IDmObservable)provider, 70, (IUiMQObjectFactory)new UiClusterQueueManagerFactory(null), (UiMQObject)this.clusterObject.getInternalObject());
                selDlg.setExplicitFilter(t, filter);
            }
        }
        String zeroObjectsMsg = ClusterPlugin.getResourceString("UI.WIZ.INFPROV.NoRepositoriesKnownLabel");
        selDlg.setNoObjectMessage(t, 0, zeroObjectsMsg);
        selDlg.setExplicitAttrOrderUniversalId(t, "com.ibm.mq.explorer.scheme.uid.clusterreposqueuemanager");
        if (selDlg.open(t, objectSelectDlgTitle, objectSelectDlgDescription, "com.ibm.mq.explorer.clusterqueuemanager", "", "com.ibm.mq.explorer.orderid.clusterqueuemanagers", false, "", null, null, viewFilter, true, true, "com.ibm.mq.explorer.ui.infopop.UI_SelectClusterSourceQmgr") && (uiObj = (UiClusterQueueManager)selDlg.getSelectedObject()) != null) {
            AddQmgrWizDlg addQmgrWizDlg;
            AddQmgrWiz addQmgrWiz;
            boolean connected = false;
            DmQueueManager qmgr = uiObj.getRealQueueManager(t);
            if (this.clusterObject instanceof ClusterObject) {
                if (qmgr != null) {
                    connected = qmgr.isConnected();
                    if (!connected) {
                        connected = qmgr.connectSynchronously(t);
                    }
                    if (connected) {
                        this.clusterObject.setInput(t, qmgr);
                        this.redrawScreenItems(t);
                    }
                } else {
                    DmQueueManagerHandle dmHandle;
                    addQmgrWiz = new AddQmgrWiz(t);
                    addQmgrWiz.setClusterPrefills(uiObj.getClusterQueueManagerNameAttr(), uiObj.getHostname(t), uiObj.getConnamePortInfo(t));
                    addQmgrWizDlg = new AddQmgrWizDlg(UiPlugin.getShell(), (IWizard)addQmgrWiz);
                    addQmgrWizDlg.create();
                    if (addQmgrWizDlg.open() != 256 && (dmHandle = addQmgrWiz.getAddedDmQueueManagerHandle()) != null) {
                        qmgr = dmHandle.getQueueManager();
                        this.clusterObject.setInput(t, qmgr);
                        this.redrawScreenItems(t);
                    }
                }
            }
            if (this.clusterObject instanceof OptimisticCluster) {
                if (qmgr == null) {
                    addQmgrWiz = new AddQmgrWiz(t);
                    addQmgrWiz.setClusterPrefills(uiObj.getClusterQueueManagerNameAttr(), uiObj.getHostname(t), uiObj.getConnamePortInfo(t));
                    addQmgrWizDlg = new AddQmgrWizDlg(UiPlugin.getShell(), (IWizard)addQmgrWiz);
                    addQmgrWizDlg.create();
                    if (addQmgrWizDlg.open() != 256) {
                        this.redrawScreenItems(t);
                    }
                } else {
                    connected = qmgr.isConnected();
                    if (!connected && (connected = qmgr.connectSynchronously(t))) {
                        this.redrawScreenItems(t);
                    }
                }
            }
        }
    }

    public String getId() {
        return "com.ibm.mq.explorer.clusterplugin.id.pageid.cluster";
    }

    public void setObject(MQExtObject object) {
        Trace t = Trace.getDefault();
        if (this.clusterObject != null && this.clusterObject != object) {
            this.clusterObject.removeProviderChangedListener(t, this);
        }
        this.clusterObject = (BaseClusterObject)object;
        this.clusterObject.addProviderChangedListener(t, this);
    }

    public void updatePage() {
        Trace t = Trace.getDefault();
        if (this.clusterObject == null) {
            return;
        }
        String title = Message.format((String)ClusterPlugin.getResourceString("UI.CONT.ClusterName.Title"), (String)this.clusterObject.toString());
        this.contentTitleBar.setText(title);
        this.redrawScreenItems(t);
    }

    private void redrawScreenItems(Trace trace) {
        if (this.clusterObject != null) {
            DmQueueManager providingQmgr = this.clusterObject.getProvider();
            if (this.clusterObject instanceof OptimisticCluster || providingQmgr == null) {
                this.reposQueueMgrTextbox.setText(ClusterPlugin.getResourceString("UI.CLUS.ClusInfo.Text"));
            } else {
                this.reposQueueMgrTextbox.setText(providingQmgr.getTitle());
            }
        }
        this.pageresizelistener.controlResized(null);
    }

    public void refresh() {
        Trace trace = Trace.getDefault();
        this.redrawScreenItems(trace);
    }

    public boolean isEnableRefreshAction() {
        return true;
    }

    public void repaint() {
    }

    public void instanceDeleted(Object object) {
    }

    public boolean isEnableSystemObjectsAction() {
        return false;
    }

    public void showSystemObjects(boolean show) {
    }

    @Override
    public void providerChanged(ProviderChangedEvent event) {
        this.updatePage();
    }
}

