/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.content;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.UiClusterQueueManager;
import com.ibm.mq.explorer.clusterplugin.internal.content.BaseCanvasImageProvider;
import com.ibm.mq.explorer.clusterplugin.internal.content.CanvasChannelIndicator;
import com.ibm.mq.explorer.clusterplugin.internal.content.CanvasFigure;
import com.ibm.mq.explorer.clusterplugin.internal.factory.CanvasFigureFactory;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class CanvasSenderImageProvider
extends BaseCanvasImageProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/content/CanvasSenderImageProvider.java";
    private CanvasFigure qmIcon1;
    private CanvasFigure qmIcon2;
    private static final int ICON_SPACING = 5;

    public CanvasSenderImageProvider() {
        ToolbarLayout layout = new ToolbarLayout(true);
        layout.setMinorAlignment(0);
        layout.setSpacing(5);
        this.setLayoutManager((LayoutManager)layout);
        this.setOpaque(true);
    }

    public int getChannelCount(Trace t, UiClusterQueueManager destinationobj) {
        int totalChannels = 0;
        if (destinationobj != null) {
            String qmid = destinationobj.getClusterQueueManagerIdAttr();
            UiClusterQueueManager[] list = this.theTable.getObjectsAsUiArray(t);
            int idx = 0;
            while (idx < list.length) {
                UiClusterQueueManager uiObj = list[idx];
                String compareqmid = uiObj.getClusterQueueManagerIdAttr();
                if (qmid.equals(compareqmid)) {
                    ++totalChannels;
                }
                ++idx;
            }
        }
        return totalChannels;
    }

    @Override
    public void provideImage(Trace t) {
        UiClusterQueueManager destinationobj = this.theCanvas.getUiObject2();
        int totalChannels = this.getChannelCount(t, destinationobj);
        this.provideImage(t, totalChannels);
    }

    @Override
    public void provideImage(Trace t, int total) {
        int h;
        int w;
        String qmname;
        this.removeAll();
        this.totalItems = total;
        if (this.theCanvas.getUiObject1() != null) {
            qmname = this.theCanvas.getUiObject1().getClusterQueueManagerNameAttr();
            this.qmIcon1 = this.theCanvas.getUiObject1().isFullRepository(t) ? CanvasFigureFactory.create(0, qmname) : CanvasFigureFactory.create(1, qmname);
            this.qmIcon1.setSize(this.qmIcon1.getPreferredSize());
            this.add((IFigure)this.qmIcon1);
            w = this.qmIcon1.getSize().width;
            h = this.qmIcon1.getSize().height;
            this.iconsize = new Dimension(w, h);
        }
        if (this.theCanvas.getUiObject2() != null) {
            CanvasFigure spacer = null;
            int idx = 0;
            while (idx < 4) {
                spacer = CanvasFigureFactory.create(9, "");
                spacer.setSize(spacer.getPreferredSize());
                spacer.setOpaque(true);
                this.add((IFigure)spacer);
                ++idx;
            }
            qmname = this.theCanvas.getUiObject2().getClusterQueueManagerNameAttr();
            this.qmIcon2 = this.theCanvas.getUiObject2().isFullRepository(t) ? CanvasFigureFactory.create(0, qmname) : CanvasFigureFactory.create(1, qmname);
            this.qmIcon2.setSize(this.qmIcon2.getPreferredSize());
            Color color = Display.getDefault().getSystemColor(24);
            this.totals = new Label(" " + this.totalItems + " ");
            this.totals.setBorder((Border)new LineBorder(color, 2));
            this.totals.setFont(CanvasChannelIndicator.CHANNEL_FONT);
            this.totals.setOpaque(true);
            this.totals.setSize(this.totals.getPreferredSize());
            Figure joined = new Figure();
            ToolbarLayout layout1 = new ToolbarLayout(true);
            layout1.setMinorAlignment(0);
            layout1.setSpacing(5);
            joined.setLayoutManager((LayoutManager)layout1);
            joined.setOpaque(true);
            joined.add((IFigure)this.totals);
            joined.add((IFigure)this.qmIcon2);
            CanvasChannelIndicator rcvChannel = new CanvasChannelIndicator(this.qmIcon1, joined, this.totalItems);
            rcvChannel.setSize(rcvChannel.getPreferredSize());
            joined.setSize(joined.getPreferredSize());
            this.add((IFigure)rcvChannel);
            this.add((IFigure)joined);
            if (spacer == null) {
                spacer = new Figure();
                spacer.setSize(1, 1);
            }
            w = this.qmIcon1.getSize().width + 5 * spacer.getSize().width + joined.getSize().width;
            h = this.qmIcon2.getSize().height;
            this.iconsize = new Dimension(w, h);
        }
        this.setSize(this.iconsize);
        int locx = this.theCanvas.getSize().x >> 1;
        int locy = this.theCanvas.getSize().y >> 1;
        this.setLocation(new Point(locx - (this.getSize().width >> 1), locy - (this.getSize().height >> 1)));
        this.theCanvas.addFigure(t, (IFigure)this);
    }
}

