/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.content;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.extensions.MQClusterQmgrExtObject;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.UiClusterQueueManager;
import com.ibm.mq.explorer.clusterplugin.internal.content.BaseCanvas;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ClusterObject;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedListener;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Display;

public abstract class BaseClusterExplorerTable
implements ExplorerTableContentChangedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/content/BaseClusterExplorerTable.java";
    protected ExplorerTableContentChangedListener contentListener = null;
    protected ExplorerTable explorerTable = null;
    protected ViewerFilter viewerFilter = null;
    protected GridData gridData = null;
    protected ClusterObject theCluster = null;
    protected BaseCanvas associatedCanvas = null;
    protected DmObjectFilter dmFilterToUse = null;

    public BaseClusterExplorerTable(BaseCanvas canvas) {
        this.associatedCanvas = canvas;
        this.contentListener = this;
    }

    public void refresh(Trace t) {
        if (this.explorerTable != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BaseClusterExplorerTable.this.explorerTable.refresh();
                }
            });
        }
    }

    public void setSize(Trace t, int w, int h) {
        if (this.explorerTable != null) {
            this.explorerTable.setSize(w, h);
        }
    }

    public void removeAll(Trace t) {
        if (this.explorerTable != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Trace t2 = Trace.getDefault();
                    BaseClusterExplorerTable.this.explorerTable.removeAll(t2);
                }
            });
        }
    }

    public void setFilter(Trace t, DmObjectFilter filter) {
        this.dmFilterToUse = filter;
    }

    public void setViewFilter(Trace t, ViewerFilter filter) {
        this.explorerTable.addViewerFilter(t, filter);
    }

    public UiClusterQueueManager[] getObjectsAsUiArray(Trace t) {
        ArrayList<UiClusterQueueManager> objects = new ArrayList<UiClusterQueueManager>();
        ArrayList objlist = this.explorerTable.getObjects(t);
        int idx = 0;
        while (idx < objlist.size()) {
            MQClusterQmgrExtObject exObj = (MQClusterQmgrExtObject)((Object)objlist.get(idx));
            UiClusterQueueManager uiObj = (UiClusterQueueManager)((Object)exObj.getInternalObject());
            objects.add(uiObj);
            ++idx;
        }
        return objects.toArray(new UiClusterQueueManager[objects.size()]);
    }

    public MQClusterQmgrExtObject[] getObjectsAsExtArray(Trace t) {
        ArrayList<MQClusterQmgrExtObject> objects = new ArrayList<MQClusterQmgrExtObject>();
        ArrayList objlist = this.explorerTable.getObjects(t);
        int idx = 0;
        while (idx < objlist.size()) {
            MQClusterQmgrExtObject exObj = (MQClusterQmgrExtObject)((Object)objlist.get(idx));
            objects.add(exObj);
            ++idx;
        }
        return objects.toArray(new MQClusterQmgrExtObject[objects.size()]);
    }

    public void addContentChangedListener(Trace t, ExplorerTableContentChangedListener listener) {
        this.explorerTable.addContentChangedListener(t, listener);
    }

    public UiMQObject getSelectedItem(Trace t) {
        return this.explorerTable.getSelectedItem(t);
    }

    public int getItemCount(Trace t) {
        return this.explorerTable.getItemCount(t);
    }

    public void beginListener(Trace t, DmQueueManager qmgr) {
        this.explorerTable.addContentChangedListener(t, this.contentListener);
        this.explorerTable.startListener(t, (IDmObservable)qmgr, this.dmFilterToUse);
    }

    public void stopListener(Trace t, DmQueueManager qmgr) {
        this.explorerTable.removeContentChangedListener(t, this.contentListener);
        this.explorerTable.stopListener(t, (IDmObservable)qmgr);
        this.explorerTable.removeAll(t);
    }

    public abstract void setContextObject(Trace var1, MQExtObject var2);

    public void setClusterFilterContextObject(Trace t, ClusterObject cluster) {
        this.theCluster = cluster;
    }

    public void contentChanged(ExplorerTableContentChangedEvent event) {
        final Trace t = Trace.getDefault();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BaseClusterExplorerTable.this.associatedCanvas != null) {
                    BaseClusterExplorerTable.this.associatedCanvas.redraw(t);
                }
            }
        });
    }

    public String getInstanceId(Trace t, MQExtObject obj) {
        String instanceId = null;
        UiClusterQueueManager uiQueueManager = (UiClusterQueueManager)((Object)obj.getInternalObject());
        if (uiQueueManager.getRealQueueManager(t) != null) {
            instanceId = uiQueueManager.getRealQueueManager(t).getTreeName(t);
        }
        return instanceId;
    }

    public boolean getIsInstanceZOS(Trace t, MQExtObject obj) {
        boolean isZos = false;
        UiClusterQueueManager uiQueueManager = (UiClusterQueueManager)((Object)obj.getInternalObject());
        if (uiQueueManager != null) {
            isZos = uiQueueManager.getRealQueueManager(t).isZos();
        }
        return isZos;
    }
}

