/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.content;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.UiClusterQueueManager;
import com.ibm.mq.explorer.clusterplugin.internal.content.BaseCanvasImageProvider;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Panel;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class BaseCanvas
extends Canvas
implements ControlListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/content/BaseCanvas.java";
    public static final int ARROW_LENGTH = 110;
    protected IFigure panel;
    protected LightweightSystem lws = new LightweightSystem((Canvas)this);
    protected UiClusterQueueManager uiObj1 = null;
    protected UiClusterQueueManager uiObj2 = null;
    protected BaseCanvasImageProvider provider = null;
    protected int itemQuantity;
    protected boolean imageCreated = false;
    protected boolean canRedraw = false;

    public BaseCanvas(Composite parent, BaseCanvasImageProvider imageprovider) {
        super(parent, 2048);
        this.panel = new Panel();
        this.addControlListener(this);
        this.lws.setContents(this.panel);
        this.panel.setOpaque(false);
        this.provider = imageprovider;
        if (this.provider != null) {
            this.provider.setCanvas(this);
        }
        Color bg = Display.getDefault().getSystemColor(25);
        this.setBackground(bg);
    }

    public final void addFigure(Trace t, IFigure newicon) {
        this.panel.add(newicon);
    }

    public final void delFigure(Trace t, IFigure icon) {
        icon.erase();
        this.panel.remove(icon);
    }

    public final void redraw(Trace t) {
        if (this.canRedraw) {
            this.provider.provideImage(t);
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void setUiObject1(Trace t, UiClusterQueueManager uiObj) {
        this.uiObj1 = uiObj;
        this.uiObj2 = null;
        String qmname = this.uiObj1.getClusterQueueManagerNameAttr();
        this.canRedraw = !qmname.startsWith("SYSTEM.TEMPQMGR.");
    }

    public void setUiObject2(Trace t, UiClusterQueueManager uiObj, int total) {
        this.uiObj2 = uiObj;
        this.provider.provideImage(t, total);
    }

    public UiClusterQueueManager getUiObject1() {
        return this.uiObj1;
    }

    public UiClusterQueueManager getUiObject2() {
        return this.uiObj2;
    }

    public void clearPanel(Trace t) {
        List figures = this.panel.getChildren();
        int idx = 0;
        while (idx < figures.size()) {
            Figure fig = (Figure)figures.get(idx);
            fig.removeAll();
            ++idx;
        }
    }

    public void controlResized(ControlEvent e) {
    }
}

